/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;

public class DataSatisfiabilityRule
extends AbstractTableauRule {
    public DataSatisfiabilityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    public void apply(Individual ind) {
        HashSet<Literal> nodes = new HashSet<Literal>();
        LinkedList<Literal> pending = new LinkedList<Literal>();
        HashMap<Literal, HashSet<Literal>> ne = new HashMap<Literal, HashSet<Literal>>();
        DependencySet ds = DependencySet.EMPTY;
        boolean nePresent = false;
        for (Edge e : ind.getOutEdges()) {
            Role r = e.getRole();
            if (!r.isDatatypeRole()) continue;
            ds = ds.union(e.getDepends(), this.strategy.getABox().doExplanation());
            Literal literal = (Literal)e.getTo();
            pending.add(literal);
            HashSet<Literal> disj = (HashSet<Literal>)ne.get(literal);
            for (Role s : r.getDisjointRoles()) {
                for (Edge f : ind.getOutEdges().getEdges(s)) {
                    Literal k = (Literal)f.getTo();
                    if (disj == null) {
                        disj = new HashSet<Literal>();
                        ne.put(literal, disj);
                        nePresent = true;
                    }
                    disj.add(k);
                }
            }
        }
        while (!pending.isEmpty()) {
            Literal l = (Literal)pending.removeFirst();
            if (!nodes.add(l)) continue;
            HashSet<Literal> disj = (HashSet<Literal>)ne.get(l);
            for (Node node : l.getDifferents()) {
                if (node.isLiteral()) {
                    Literal k = (Literal)node;
                    pending.add(k);
                    if (disj == null) {
                        disj = new HashSet<Literal>();
                        ne.put(l, disj);
                        nePresent = true;
                    }
                    disj.add(k);
                    ds = ds.union(l.getDifferenceDependency(node), this.strategy.getABox().doExplanation());
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        if (nePresent) {
            String msg;
            try {
                if (!this.strategy.getABox().getDatatypeReasoner().isSatisfiable(nodes, ne)) {
                    for (Literal n : nodes) {
                        for (DependencySet dependencySet : n.getDepends().values()) {
                            ds = ds.union(dependencySet, this.strategy.getABox().doExplanation());
                        }
                    }
                    this.strategy.getABox().setClash(Clash.unexplained(ind, ds));
                }
            }
            catch (InvalidLiteralException e) {
                msg = "Invalid literal encountered during satisfiability check: " + e.getMessage();
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    log.fine(msg);
                    for (Literal literal : nodes) {
                        for (DependencySet typeDep : literal.getDepends().values()) {
                            ds = ds.union(typeDep, this.strategy.getABox().doExplanation());
                        }
                    }
                    this.strategy.getABox().setClash(Clash.invalidLiteral(ind, ds));
                }
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
            catch (DatatypeReasonerException e) {
                msg = "Unexpected datatype reasoner exception: " + e.getMessage();
                log.severe(msg);
                throw new InternalReasonerException(msg, e);
            }
        }
    }
}

