/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class MinRule
extends AbstractTableauRule {
    public MinRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.MIN_NUMBER, AbstractTableauRule.BlockingType.COMPLETE);
    }

    public void apply(Individual x) {
        if (!x.canApply(4)) {
            return;
        }
        List<ATermAppl> types = x.getTypes(4);
        int size = types.size();
        for (int j = x.applyNext[4]; j < size; ++j) {
            ATermAppl mc = types.get(j);
            this.apply(x, mc);
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
        x.applyNext[4] = size;
    }

    protected void apply(Individual x, ATermAppl mc) {
        ATermAppl c;
        int n;
        Role r = this.strategy.getABox().getRole(mc.getArgument(0));
        if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt(), c = (ATermAppl)mc.getArgument(2))) {
            return;
        }
        DependencySet ds = x.getDepends((ATerm)mc);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this.strategy.getABox().getAnonCount() + 1 + " - anon") + (this.strategy.getABox().getAnonCount() + n) + " " + ATermUtils.toString(c) + " " + ds);
        }
        Node[] y = new Node[n];
        for (int c1 = 0; c1 < n; ++c1) {
            this.strategy.checkTimer();
            y[c1] = r.isDatatypeRole() ? this.strategy.getABox().addLiteral(ds) : this.strategy.createFreshIndividual(x, ds);
            Node succ = y[c1];
            DependencySet finalDS = ds;
            this.strategy.addEdge(x, r, succ, ds);
            if (succ.isPruned()) {
                finalDS = finalDS.union(succ.getMergeDependency(true), this.strategy.getABox().doExplanation());
                succ = succ.getMergedTo();
            }
            this.strategy.addType(succ, c, finalDS);
            for (int c2 = 0; c2 < c1; ++c2) {
                succ.setDifferent(y[c2], finalDS);
            }
        }
    }
}

