/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ProfileBasedExpressivityChecker;
import java.util.Collection;
import java.util.Iterator;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class ELExpressivityChecker
extends ProfileBasedExpressivityChecker {
    private Expressivity m_Expressivity;

    public ELExpressivityChecker(KnowledgeBase kb) {
        super(kb);
    }

    public boolean compute(Expressivity expressivity) {
        this.m_Expressivity = expressivity;
        if (!this.processIndividuals()) {
            return false;
        }
        if (!this.processClasses()) {
            return false;
        }
        return this.processRoles();
    }

    private boolean processIndividuals() {
        IndividualIterator i = this.m_KB.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = i.next();
            ATermAppl nominal = ATermUtils.makeValue((ATerm)ind.getName());
            for (ATermAppl term : ind.getTypes()) {
                if (term.equals(nominal) || ELSyntaxUtils.isEL(term)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processClasses() {
        for (ATermAppl axiom : this.m_KB.getTBox().getAssertedAxioms()) {
            AFun fun = axiom.getAFun();
            if (fun.equals(ATermUtils.DISJOINTSFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                ATermList args = (ATermList)axiom.getArgument(0);
                while (!args.isEmpty()) {
                    if (!ELSyntaxUtils.isEL((ATermAppl)args.getFirst())) {
                        return false;
                    }
                    args = args.getNext();
                }
                continue;
            }
            ATermAppl sub = (ATermAppl)axiom.getArgument(0);
            ATermAppl sup = (ATermAppl)axiom.getArgument(1);
            if (!ELSyntaxUtils.isEL(sub) || !ELSyntaxUtils.isEL(sup)) {
                return false;
            }
            if (fun.equals(ATermUtils.SUBFUN)) {
                if (!ATermUtils.isBottom((ATermAppl)ELSyntaxUtils.simplify(sup))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.EQCLASSFUN)) {
                if (!ATermUtils.isBottom((ATermAppl)ELSyntaxUtils.simplify(sub)) && !ATermUtils.isBottom((ATermAppl)ELSyntaxUtils.simplify(sup))) continue;
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            if (fun.equals(ATermUtils.DISJOINTFUN)) {
                this.m_Expressivity.setHasDisjointClasses(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean processRoles() {
        Collection roles = this.m_KB.getRBox().getRoles();
        for (Role r : roles) {
            if (r.isBuiltin()) continue;
            if (r.isDatatypeRole()) {
                return false;
            }
            if (r.isAnon()) {
                for (Role subRole : r.getSubRoles()) {
                    if (subRole.isAnon() || subRole.isBottom()) continue;
                    return false;
                }
            }
            if (r.isAnon() && r.isFunctional()) {
                return false;
            }
            if (r.isFunctional()) {
                return false;
            }
            if (r.isTransitive()) {
                this.m_Expressivity.setHasTransitivity(true);
            }
            if (r.isReflexive()) {
                this.m_Expressivity.setHasReflexivity(true);
            }
            if (r.isIrreflexive()) {
                return false;
            }
            if (r.isAsymmetric()) {
                return false;
            }
            if (!r.getDisjointRoles().isEmpty()) {
                return false;
            }
            if (r.hasComplexSubRole()) {
                this.m_Expressivity.setHasComplexSubRoles(true);
                boolean isInv = r.isAnon();
                for (ATermList chain : r.getSubRoleChains()) {
                    while (!chain.isEmpty()) {
                        if (ATermUtils.isInv((ATermAppl)((ATermAppl)chain.getFirst())) != isInv) {
                            return false;
                        }
                        chain = chain.getNext();
                    }
                }
            }
            if (r.getSubRoles().size() <= 1) continue;
            this.m_Expressivity.setHasRoleHierarchy(true);
        }
        for (Role r : roles) {
            Iterator assertedDomains = this.m_KB.getRBox().getAssertedDomains(r);
            while (assertedDomains.hasNext()) {
                ATermAppl domain = (ATermAppl)assertedDomains.next();
                if (!ELSyntaxUtils.isEL(domain)) {
                    return false;
                }
                this.m_Expressivity.setHasDomain(true);
            }
            Iterator assertedRanges = this.m_KB.getRBox().getAssertedRanges(r);
            while (assertedRanges.hasNext()) {
                ATermAppl range = (ATermAppl)assertedRanges.next();
                if (!ELSyntaxUtils.isEL(range)) {
                    return false;
                }
                this.m_Expressivity.setHasDomain(true);
            }
        }
        return true;
    }

    public boolean updateWith(Expressivity expressivity, ATermAppl term) {
        return false;
    }
}

