/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BuiltinTerm {
    RDF_Property(RDF.Property),
    RDFS_Class(RDFS.Class),
    RDFS_Datatype(RDFS.Datatype),
    OWL_Thing(OWL.Thing, false, true),
    OWL_Nothing(OWL.Nothing, false, true),
    OWL_Class(OWL.Class),
    OWL_ObjectProperty(OWL.ObjectProperty),
    OWL_DatatypeProperty(OWL.DatatypeProperty),
    OWL_FunctionalProperty(OWL.FunctionalProperty),
    OWL_InverseFunctionalProperty(OWL.InverseFunctionalProperty),
    OWL_TransitiveProperty(OWL.TransitiveProperty),
    OWL_SymmetricProperty(OWL.SymmetricProperty),
    OWL_AnnotationProperty(OWL.AnnotationProperty),
    OWL2_ReflexiveProperty(OWL2.ReflexiveProperty),
    OWL2_IrreflexiveProperty(OWL2.IrreflexiveProperty),
    OWL2_AsymmetricProperty(OWL2.AsymmetricProperty),
    OWL_DataRange(OWL.DataRange),
    OWL2_NamedIndividual(OWL2.NamedIndividual),
    OWL2_NegativePropertyAssertion(OWL2.NegativePropertyAssertion),
    OWL_AllDifferent(OWL.AllDifferent),
    OWL2_AllDisjointClasses(OWL2.AllDisjointClasses),
    OWL2_AllDisjointProperties(OWL2.AllDisjointProperties),
    SWRL_Imp(SWRL.Imp),
    SWRL_ClassAtom(SWRL.ClassAtom, true),
    SWRL_IndividualPropertyAtom(SWRL.IndividualPropertyAtom, true),
    SWRL_DatavaluedPropertyAtom(SWRL.DatavaluedPropertyAtom, true),
    SWRL_SameIndividualAtom(SWRL.SameIndividualAtom, true),
    SWRL_DifferentIndividualsAtom(SWRL.DifferentIndividualsAtom, true),
    SWRL_DataRangeAtom(SWRL.DataRangeAtom, true),
    SWRL_BuiltinAtom(SWRL.BuiltinAtom, true),
    SWRL_Builtin(SWRL.Builtin, true),
    SWRL_AtomList(SWRL.AtomList, true),
    SWRL_Variable(SWRL.Variable, true),
    RDFS_subClassOf((Resource)RDFS.subClassOf),
    RDFS_subPropertyOf((Resource)RDFS.subPropertyOf),
    RDFS_domain((Resource)RDFS.domain),
    RDFS_range((Resource)RDFS.range),
    OWL_unionOf((Resource)OWL.unionOf),
    OWL_intersectionOf((Resource)OWL.intersectionOf),
    OWL_complementOf((Resource)OWL.complementOf),
    OWL_oneOf((Resource)OWL.oneOf),
    OWL_inverseOf((Resource)OWL.inverseOf),
    OWL_sameAs((Resource)OWL.sameAs, false, true),
    OWL_equivalentProperty((Resource)OWL.equivalentProperty),
    OWL_equivalentClass((Resource)OWL.equivalentClass),
    OWL_distinctMembers((Resource)OWL.distinctMembers, false, true),
    OWL_disjointWith((Resource)OWL.disjointWith),
    OWL_differentFrom((Resource)OWL.differentFrom, false, true),
    OWL_members((Resource)OWL2.members),
    OWL2_disjointUnionOf((Resource)OWL2.disjointUnionOf),
    OWL2_propertyDisjointWith((Resource)OWL2.propertyDisjointWith),
    OWL2_propertyChain((Resource)OWL2.propertyChain, true),
    OWL2_propertyChainAxiom((Resource)OWL2.propertyChainAxiom),
    OWL2_Axiom(OWL2.Axiom, true),
    OWL2_Annotation(OWL2.Annotation, true),
    OWL2_annotatedSource((Resource)OWL2.annotatedSource, true),
    OWL2_annotatedProperty((Resource)OWL2.annotatedProperty, true),
    OWL2_annotatedTarget((Resource)OWL2.annotatedTarget, true),
    OWL2_object((Resource)OWL2.object, true),
    OWL2_predicate((Resource)OWL2.predicate, true),
    OWL2_subject((Resource)OWL2.subject, true),
    RDF_type((Resource)RDF.type, false, true),
    RDF_first((Resource)RDF.first, true),
    RDF_rest((Resource)RDF.rest, true),
    RDF_subject((Resource)RDF.subject, true),
    RDF_predicate((Resource)RDF.predicate, true),
    RDF_object((Resource)RDF.object, true),
    OWL_imports((Resource)OWL.imports, true),
    OWL_onProperty((Resource)OWL.onProperty, true),
    OWL_hasValue((Resource)OWL.hasValue, true),
    OWL_allValuesFrom((Resource)OWL.allValuesFrom, true),
    OWL_someValuesFrom((Resource)OWL.someValuesFrom, true),
    OWL_minCardinality((Resource)OWL.minCardinality, true),
    OWL_maxCardinality((Resource)OWL.maxCardinality, true),
    OWL_cardinality((Resource)OWL.cardinality, true),
    OWL_versionInfo((Resource)OWL.versionInfo, true),
    OWL_backwardCompatibleWith((Resource)OWL.backwardCompatibleWith, true),
    OWL_incompatibleWith((Resource)OWL.incompatibleWith, true),
    OWL_priorVersion((Resource)OWL.priorVersion, true),
    OWL2_onClass((Resource)OWL2.onClass, true),
    OWL2_onDataRange((Resource)OWL2.onDataRange, true),
    OWL2_qualifiedCardinality((Resource)OWL2.qualifiedCardinality, true),
    OWL2_minQualifiedCardinality((Resource)OWL2.minQualifiedCardinality, true),
    OWL2_maxQualifiedCardinality((Resource)OWL2.maxQualifiedCardinality, true),
    OWL2_onDatatype((Resource)OWL2.onDatatype, true),
    OWL2_withRestrictions((Resource)OWL2.withRestrictions, true),
    OWL2_minInclusive((Resource)OWL2.minInclusive, true),
    OWL2_minExclusive((Resource)OWL2.minExclusive, true),
    OWL2_maxInclusive((Resource)OWL2.maxInclusive, true),
    OWL2_maxExclusive((Resource)OWL2.maxExclusive, true),
    OWL2_minLength((Resource)OWL2.minLength, true),
    OWL2_maxLength((Resource)OWL2.maxLength, true),
    OWL2_length((Resource)OWL2.length, true),
    OWL2_totalDigits((Resource)OWL2.length, true),
    OWL2_fractionDigits((Resource)OWL2.fractionDigits, true),
    OWL2_datatypeComplementOf((Resource)OWL2.datatypeComplementOf, true),
    OWL2_sourceIndividual((Resource)OWL2.sourceIndividual, true),
    OWL2_assertionProperty((Resource)OWL2.assertionProperty, true),
    OWL2_targetIndividual((Resource)OWL2.targetIndividual, true),
    OWL2_targetValue((Resource)OWL2.targetValue, true),
    OWL2_hasKey((Resource)OWL2.hasKey),
    OWL2_hasSelf((Resource)OWL2.hasSelf, true),
    OWL2_topDataProperty((Resource)OWL2.topDataProperty, false, true),
    OWL2_bottomDataProperty((Resource)OWL2.bottomDataProperty, false, true),
    OWL2_topObjectProperty((Resource)OWL2.topObjectProperty, false, true),
    OWL2_bottomObjectProperty((Resource)OWL2.bottomObjectProperty, false, true),
    SWRL_argument1((Resource)SWRL.argument1, true),
    SWRL_argument2((Resource)SWRL.argument2, true),
    SWRL_body((Resource)SWRL.body, true),
    SWRL_head((Resource)SWRL.head, true),
    SWRL_builtin((Resource)SWRL.builtin, true),
    SWRL_arguments((Resource)SWRL.arguments, true),
    SWRL_classPredicate((Resource)SWRL.classPredicate, true),
    SWRL_propertyPredicate((Resource)SWRL.propertyPredicate, true),
    SWRL_dataRange((Resource)SWRL.dataRange, true),
    RDF_List(RDF.List, true),
    RDF_Statement(RDF.Statement, true),
    OWL_Restriction(OWL.Restriction, true),
    OWL_Ontology(OWL.Ontology, true),
    OWL2_SelfRestriction(OWL2.SelfRestriction, true);

    private static final Map<Node, BuiltinTerm> nodeMap;
    public static final EnumSet<BuiltinTerm> EXPRESSION_PREDICATES;
    private Node node;
    private boolean isABox;
    private boolean isPredicate;
    private boolean isSyntax;

    public static BuiltinTerm find(Node node) {
        return nodeMap.get(node);
    }

    public static boolean isExpression(Node node) {
        BuiltinTerm builtin = BuiltinTerm.find(node);
        return builtin != null && EXPRESSION_PREDICATES.contains((Object)builtin);
    }

    public static boolean isExpression(BuiltinTerm builtin) {
        return EXPRESSION_PREDICATES.contains((Object)builtin);
    }

    public static boolean isBuiltin(Node node) {
        return BuiltinTerm.find(node) != null;
    }

    public static boolean isSyntax(Node node) {
        BuiltinTerm builtin = BuiltinTerm.find(node);
        return builtin != null && builtin.isSyntax();
    }

    private BuiltinTerm(Resource resource) {
        this(resource, false);
    }

    private BuiltinTerm(Resource resource, boolean isSyntax) {
        this(resource, isSyntax, false);
    }

    private BuiltinTerm(Resource resource, boolean isSyntax, boolean isABox) {
        this.node = resource.asNode();
        this.isSyntax = isSyntax;
        this.isPredicate = resource instanceof Property;
        this.isABox = isABox;
    }

    public boolean isABox() {
        return this.isABox;
    }

    public boolean isSyntax() {
        return this.isSyntax;
    }

    public boolean isPredicate() {
        return this.isPredicate;
    }

    public Node getNode() {
        return this.node;
    }

    public String getURI() {
        return this.node.getURI();
    }

    static {
        nodeMap = new HashMap<Node, BuiltinTerm>();
        for (BuiltinTerm builtinTerm : BuiltinTerm.values()) {
            nodeMap.put(builtinTerm.getNode(), builtinTerm);
        }
        nodeMap.put(OWL.DeprecatedClass.asNode(), OWL_Class);
        nodeMap.put(OWL.DeprecatedProperty.asNode(), RDF_Property);
        EXPRESSION_PREDICATES = EnumSet.of(OWL_intersectionOf, new BuiltinTerm[]{OWL_unionOf, OWL_complementOf, OWL2_datatypeComplementOf, OWL2_disjointUnionOf, OWL_oneOf, OWL_inverseOf, OWL2_onDatatype, OWL2_onDataRange, OWL2_propertyChain});
    }
}

