/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletGraphListener
implements GraphListener {
    private KnowledgeBase kb;
    private Graph rootGraph;
    private Set<Graph> leafGraphs;
    private Set<Graph> changedGraphs;
    private boolean statementDeleted;

    public PelletGraphListener(Graph rootGraph, KnowledgeBase kb) {
        this.rootGraph = rootGraph;
        this.kb = kb;
        this.leafGraphs = CollectionUtils.makeSet();
        this.changedGraphs = CollectionUtils.makeSet();
        this.statementDeleted = false;
        this.collectLeafGraphs(rootGraph, Collections.<Graph>emptySet());
    }

    private void addABoxTriple(Triple t) {
        ATermAppl s = JenaUtils.makeATerm(t.getSubject());
        ATermAppl o = JenaUtils.makeATerm(t.getObject());
        if (t.getPredicate().equals((Object)RDF.type.asNode())) {
            if (!this.kb.getIndividuals().contains(s)) {
                this.kb.addIndividual(s);
            }
            this.kb.addType(s, o);
        } else {
            if (!this.kb.getIndividuals().contains(s)) {
                this.kb.addIndividual(s);
            }
            if (!t.getObject().isLiteral() && !this.kb.getIndividuals().contains(o)) {
                this.kb.addIndividual(o);
            }
            ATermAppl p = JenaUtils.makeATerm(t.getPredicate());
            this.kb.addPropertyValue(p, s, o);
        }
    }

    private void deleteABoxTriple(Triple t) {
        ATermAppl s = JenaUtils.makeATerm(t.getSubject());
        ATermAppl o = JenaUtils.makeATerm(t.getObject());
        if (t.getPredicate().equals((Object)RDF.type.asNode())) {
            if (this.kb.isIndividual((ATerm)s)) {
                this.kb.removeType(s, o);
            }
        } else if (this.kb.isIndividual((ATerm)s) && this.kb.isIndividual((ATerm)o)) {
            ATermAppl p = JenaUtils.makeATerm(t.getPredicate());
            this.kb.removePropertyValue(p, s, o);
        }
    }

    private void collectLeafGraphs(Graph graph, Set<Graph> prevLeaves) {
        if (graph instanceof MultiUnion) {
            MultiUnion union = (MultiUnion)graph;
            if (union.getBaseGraph() != null) {
                this.collectLeafGraphs(union.getBaseGraph(), prevLeaves);
            }
            Iterator i = union.getSubGraphs().iterator();
            while (i.hasNext()) {
                this.collectLeafGraphs((Graph)i.next(), prevLeaves);
            }
        } else if (graph instanceof InfGraph) {
            this.collectLeafGraphs(((InfGraph)graph).getRawGraph(), prevLeaves);
        } else if (this.leafGraphs.add(graph) && !prevLeaves.contains(graph)) {
            this.changedGraphs.add(graph);
            graph.getEventManager().register((GraphListener)this);
        }
    }

    private boolean canUpdateIncrementally(Graph g) {
        return PelletOptions.PROCESS_JENA_UPDATES_INCREMENTALLY && !this.statementDeleted && !this.changedGraphs.contains(g);
    }

    public void dispose() {
        for (Graph graph : this.leafGraphs) {
            graph.getEventManager().unregister((GraphListener)this);
        }
        this.leafGraphs.clear();
        this.changedGraphs.clear();
        this.statementDeleted = false;
    }

    public boolean isChanged() {
        if (this.statementDeleted || !this.changedGraphs.isEmpty()) {
            return true;
        }
        this.getChangedGraphs();
        return this.statementDeleted || !this.changedGraphs.isEmpty();
    }

    public Set<Graph> getChangedGraphs() {
        Set<Graph> prevLeaves = this.leafGraphs;
        this.leafGraphs = CollectionUtils.makeSet();
        this.collectLeafGraphs(this.rootGraph, prevLeaves);
        for (Graph prevLeaf : prevLeaves) {
            if (this.leafGraphs.contains(prevLeaf)) continue;
            this.statementDeleted = true;
            prevLeaf.getEventManager().unregister((GraphListener)this);
        }
        if (this.statementDeleted) {
            return null;
        }
        return this.changedGraphs;
    }

    public Set<Graph> getLeafGraphs() {
        return this.leafGraphs;
    }

    private boolean isABoxChange(Triple t) {
        Node o = t.getObject();
        Node p = t.getPredicate();
        if (p.equals((Object)RDF.type.asNode())) {
            if (o.isBlank()) {
                return false;
            }
            ATermAppl object = JenaUtils.makeATerm(o);
            if (!this.kb.isClass((ATerm)object)) {
                return false;
            }
        } else {
            ATermAppl prop = JenaUtils.makeATerm(p);
            if (!this.kb.isProperty((ATerm)prop)) {
                return false;
            }
        }
        return true;
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        this.notifyAddIterator(g, IteratorUtils.iterator((Object[])triples));
    }

    public void notifyAddGraph(Graph g, Graph added) {
        this.notifyAddIterator(g, (Iterator<Triple>)added.find((TripleMatch)Triple.ANY));
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        boolean canUpdateIncrementally = this.canUpdateIncrementally(g);
        if (canUpdateIncrementally) {
            while (it.hasNext()) {
                Triple t = it.next();
                if (!this.isABoxChange(t)) {
                    canUpdateIncrementally = false;
                    break;
                }
                this.addABoxTriple(t);
            }
        }
        if (!canUpdateIncrementally) {
            this.changedGraphs.add(g);
        }
    }

    public void notifyAddList(Graph g, List<Triple> triples) {
        this.notifyAddIterator(g, triples.iterator());
    }

    public void notifyAddTriple(Graph g, Triple t) {
        if (this.canUpdateIncrementally(g) && this.isABoxChange(t)) {
            this.addABoxTriple(t);
        } else {
            this.changedGraphs.add(g);
        }
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.notifyDeleteIterator(g, IteratorUtils.iterator((Object[])triples));
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.notifyDeleteIterator(g, (Iterator<Triple>)removed.find((TripleMatch)Triple.ANY));
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        boolean canUpdateIncrementally = this.canUpdateIncrementally(g);
        if (canUpdateIncrementally) {
            while (it.hasNext()) {
                Triple t = it.next();
                if (!this.isABoxChange(t)) {
                    canUpdateIncrementally = false;
                    break;
                }
                this.deleteABoxTriple(t);
            }
        }
        if (!canUpdateIncrementally) {
            this.statementDeleted = true;
            this.changedGraphs.add(g);
        }
    }

    public void notifyDeleteList(Graph g, List<Triple> list) {
        this.notifyDeleteIterator(g, list.iterator());
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        if (this.canUpdateIncrementally(g) && this.isABoxChange(t)) {
            this.deleteABoxTriple(t);
        } else {
            this.statementDeleted = true;
            this.changedGraphs.add(g);
        }
    }

    public void notifyEvent(Graph source, Object value) {
        this.statementDeleted = true;
    }

    public void reset() {
        this.changedGraphs.clear();
        this.statementDeleted = false;
    }
}

