/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ChangeTypeDetector {
    private static final Set<AxiomType> TBOX_AXIOM_TYPES = new HashSet<AxiomType>(Arrays.asList(AxiomType.DISJOINT_CLASSES, AxiomType.DISJOINT_UNION, AxiomType.EQUIVALENT_CLASSES, AxiomType.SUBCLASS_OF));
    private static final Set<AxiomType> RBOX_AXIOM_TYPES = new HashSet<AxiomType>(Arrays.asList(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, AxiomType.DATA_PROPERTY_DOMAIN, AxiomType.DATA_PROPERTY_RANGE, AxiomType.DISJOINT_DATA_PROPERTIES, AxiomType.DISJOINT_OBJECT_PROPERTIES, AxiomType.EQUIVALENT_DATA_PROPERTIES, AxiomType.EQUIVALENT_OBJECT_PROPERTIES, AxiomType.FUNCTIONAL_DATA_PROPERTY, AxiomType.FUNCTIONAL_OBJECT_PROPERTY, AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, AxiomType.INVERSE_OBJECT_PROPERTIES, AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, AxiomType.OBJECT_PROPERTY_DOMAIN, AxiomType.OBJECT_PROPERTY_RANGE, AxiomType.REFLEXIVE_OBJECT_PROPERTY, AxiomType.SUB_DATA_PROPERTY, AxiomType.SUB_OBJECT_PROPERTY, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.SYMMETRIC_OBJECT_PROPERTY, AxiomType.TRANSITIVE_OBJECT_PROPERTY));
    private static final Set<AxiomType> ABOX_AXIOM_TYPES = new HashSet<AxiomType>(Arrays.asList(AxiomType.CLASS_ASSERTION, AxiomType.DATA_PROPERTY_ASSERTION, AxiomType.DIFFERENT_INDIVIDUALS, AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, AxiomType.OBJECT_PROPERTY_ASSERTION, AxiomType.SAME_INDIVIDUAL));

    public static boolean isTBoxAxiom(OWLAxiom axiom) {
        return TBOX_AXIOM_TYPES.contains(axiom.getAxiomType());
    }

    public static boolean isRBoxAxiom(OWLAxiom axiom) {
        return RBOX_AXIOM_TYPES.contains(axiom.getAxiomType());
    }

    public static boolean isABoxAxiom(OWLAxiom axiom) {
        return ABOX_AXIOM_TYPES.contains(axiom.getAxiomType());
    }
}

