/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.owlapiv3.OWL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntailmentChecker
extends OWLAxiomVisitorAdapter
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    private IncrementalClassifier reasoner;
    private Boolean isEntailed;

    public EntailmentChecker(IncrementalClassifier reasoner) {
        this.reasoner = reasoner;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailed(OWLAxiom axiom) {
        this.isEntailed = null;
        axiom.accept((OWLAxiomVisitor)this);
        if (this.isEntailed == null) {
            throw new UnsupportedEntailmentTypeException(axiom);
        }
        return this.isEntailed;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression superClass = axiom.getSuperClass();
        this.isEntailed = !this.reasoner.isClassified() || subClass.isAnonymous() || superClass.isAnonymous() ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(this.reasoner.getTaxonomy().isSubNodeOf((Object)((OWLClass)subClass), (Object)((OWLClass)superClass)).isTrue());
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isEntailed = true;
        Iterator i = axiom.getClassExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this.isEntailed.booleanValue()) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                if (!this.reasoner.isClassified() || first.isAnonymous() || next.isAnonymous()) {
                    this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)first, (OWLClassExpression)next));
                    continue;
                }
                this.isEntailed = this.reasoner.getTaxonomy().isEquivalent((Object)((OWLClass)first), (Object)((OWLClass)next)).isTrue();
            }
        }
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        if (this.reasoner.isRealized()) {
            boolean sameTypes = true;
            Taxonomy<OWLClass> taxonomy = this.reasoner.getTaxonomy();
            Iterator i = axiom.getIndividuals().iterator();
            if (i.hasNext()) {
                OWLIndividual first = (OWLIndividual)i.next();
                Set firstTypes = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, (Object)first, (boolean)true));
                while (i.hasNext() && sameTypes) {
                    OWLIndividual next = (OWLIndividual)i.next();
                    Set nextTypes = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, (Object)next, (boolean)true));
                    sameTypes = ((Object)firstTypes).equals(nextTypes);
                }
                this.isEntailed = sameTypes ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(false);
            }
        } else {
            this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (this.reasoner.isClassified() && !this.containsAnonymousClasses(axiom.getClassExpressions())) {
            OWLClass[] classes = new OWLClass[axiom.getClassExpressions().size()];
            Iterator iter = axiom.getClassExpressions().iterator();
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ((OWLClassExpression)iter.next()).asOWLClass();
            }
            this.isEntailed = this.possiblyDisjoint(classes) ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(false);
        } else {
            this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
        }
    }

    private boolean possiblyDisjoint(OWLClass[] classes) {
        for (int i = 0; i < classes.length - 1; ++i) {
            for (int j = i + 1; j < classes.length; ++j) {
                if (this.possiblyDisjoint(classes[i], classes[j])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean possiblyDisjoint(OWLClass first, OWLClass next) {
        Taxonomy<OWLClass> taxonomy = this.reasoner.getTaxonomy();
        if (taxonomy.getAllEquivalents((Object)first).contains(next)) {
            return false;
        }
        if (taxonomy.getFlattenedSupers((Object)first, false).contains(next)) {
            return false;
        }
        return !taxonomy.getFlattenedSupers((Object)next, false).contains(first);
    }

    private boolean containsAnonymousClasses(Collection<OWLClassExpression> classExpressions) {
        for (OWLClassExpression classExpression : classExpressions) {
            if (!classExpression.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.isRealized() && !axiom.getClassExpression().isAnonymous() ? Boolean.valueOf(EntailmentChecker.contains(TaxonomyUtils.getTypes(this.reasoner.getTaxonomy(), (Object)axiom.getIndividual(), (boolean)false), axiom.getClassExpression().asOWLClass())) : Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom));
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(SWRLRule rule) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)rule);
    }

    private static <T> boolean contains(Set<Set<T>> setOfSets, T element) {
        for (Set<T> set : setOfSets) {
            if (!set.contains(element)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> flatten(Set<Set<T>> setOfSets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : setOfSets) {
            result.addAll(set);
        }
        return result;
    }
}

