/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToAllValuePattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToComplementPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToMaxCardinalityPattern;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToTopPattern;
import com.clarkparsia.pellint.lintpattern.axiom.GCIPattern;
import com.clarkparsia.pellint.lintpattern.axiom.LargeCardinalityPattern;
import com.clarkparsia.pellint.lintpattern.axiom.LargeDisjunctionPattern;
import com.clarkparsia.pellint.lintpattern.ontology.EquivalentAndSubclassAxiomPattern;
import com.clarkparsia.pellint.lintpattern.ontology.ExistentialExplosionPattern;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.lintpattern.ontology.TooManyDifferentIndividualsPattern;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LintPatternLoader {
    private static final Logger LOGGER = Logger.getLogger(LintPatternLoader.class.getName());
    public static final List<AxiomLintPattern> DEFAULT_AXIOM_LINT_PATTERNS = Arrays.asList(new EquivalentToAllValuePattern(), new EquivalentToMaxCardinalityPattern(), new EquivalentToComplementPattern(), new EquivalentToTopPattern(), new GCIPattern(), new LargeCardinalityPattern(), new LargeDisjunctionPattern());
    public static final List<OntologyLintPattern> DEFAULT_ONTOLOGY_LINT_PATTERNS = Arrays.asList(new EquivalentAndSubclassAxiomPattern(), new ExistentialExplosionPattern(), new TooManyDifferentIndividualsPattern());
    private List<AxiomLintPattern> m_AxiomLintPatterns;
    private List<OntologyLintPattern> m_OntologyLintPatterns;

    public LintPatternLoader() {
        this.m_AxiomLintPatterns = DEFAULT_AXIOM_LINT_PATTERNS;
        this.m_OntologyLintPatterns = DEFAULT_ONTOLOGY_LINT_PATTERNS;
    }

    public LintPatternLoader(Properties properties) {
        Collection<LintPattern> patterns = LintPatternLoader.loadPatterns(LintPatternLoader.formatProperties(properties));
        if (patterns.isEmpty()) {
            this.m_AxiomLintPatterns = DEFAULT_AXIOM_LINT_PATTERNS;
            this.m_OntologyLintPatterns = DEFAULT_ONTOLOGY_LINT_PATTERNS;
        } else {
            this.m_AxiomLintPatterns = CollectionUtil.makeList();
            this.m_OntologyLintPatterns = CollectionUtil.makeList();
            for (LintPattern pattern : patterns) {
                if (pattern instanceof AxiomLintPattern) {
                    this.m_AxiomLintPatterns.add((AxiomLintPattern)pattern);
                    continue;
                }
                if (!(pattern instanceof OntologyLintPattern)) continue;
                this.m_OntologyLintPatterns.add((OntologyLintPattern)pattern);
            }
        }
    }

    public List<AxiomLintPattern> getAxiomLintPatterns() {
        return this.m_AxiomLintPatterns;
    }

    public List<OntologyLintPattern> getOntologyLintPatterns() {
        return this.m_OntologyLintPatterns;
    }

    private static Map<String, String> formatProperties(Properties properties) {
        HashMap<String, String> formattedProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyStr = key == null ? "" : key.toString().trim();
            String valueStr = value == null ? "" : value.toString().trim();
            formattedProperties.put(keyStr, valueStr);
        }
        return formattedProperties;
    }

    private static Collection<LintPattern> loadPatterns(Map<String, String> properties) {
        String value;
        String key;
        HashMap<String, LintPattern> patterns = new HashMap<String, LintPattern>();
        HashSet<String> patternNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            LintPattern pattern = LintPatternLoader.parseLintPattern(key);
            if (pattern != null) {
                patternNames.add(key);
                if (!"on".equalsIgnoreCase(value)) continue;
                patterns.put(key, pattern);
                continue;
            }
            if (!"on".equalsIgnoreCase(value) && !"off".equalsIgnoreCase(value)) continue;
            patternNames.add(key);
            LOGGER.severe("Cannot find and construct pattern " + key);
        }
        for (String patternName : patternNames) {
            properties.remove(patternName);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            int lastDot = key.lastIndexOf(46);
            if (lastDot < 0 || lastDot > key.length()) {
                LOGGER.severe("Cannot find field name " + key);
                continue;
            }
            String className = key.substring(0, lastDot);
            String fieldName = key.substring(lastDot + 1);
            if (!patternNames.contains(className)) {
                LOGGER.severe("Cannot find pattern " + className + " to set its parameter " + fieldName);
                continue;
            }
            LintPattern pattern = (LintPattern)patterns.get(className);
            if (pattern == null) continue;
            LintPatternLoader.setParameter(pattern, className, fieldName, value);
        }
        return patterns.values();
    }

    private static LintPattern parseLintPattern(String str) {
        try {
            Class<?> clazz = Class.forName(str);
            Class<LintPattern> lpClazz = clazz.asSubclass(LintPattern.class);
            Constructor<LintPattern> ctor = lpClazz.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void setParameter(LintPattern pattern, String className, String fieldName, String value) {
        Method method;
        String setter = "set" + fieldName;
        Class<?> clazz = pattern.getClass();
        try {
            method = clazz.getMethod(setter, Integer.TYPE);
            try {
                int intValue = Integer.parseInt(value);
                method.invoke((Object)pattern, intValue);
                return;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, value + " is not an integer", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
        }
        catch (SecurityException e) {
            LOGGER.log(Level.FINE, "Error accessing method " + setter + "(int) on lint pattern " + className, e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINE, "Method " + setter + "(int) not found on lint pattern " + className, e);
        }
        try {
            method = clazz.getMethod(setter, String.class);
            try {
                method.invoke((Object)pattern, value);
                return;
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.FINE, "Error invoking method " + method + " with parameter " + value, e);
            }
        }
        catch (SecurityException e) {
            LOGGER.log(Level.FINE, "Error accessing method " + setter + "(String) on lint pattern " + className, e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINE, "Method " + setter + "(String) not found on lint pattern " + className, e);
        }
        LOGGER.severe("Cannot set paramater " + fieldName + "=" + value + " for lint pattern " + className);
    }
}

