/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFModel {
    private List<String> m_Comments = CollectionUtil.makeList();
    private Map<String, String> m_Namespaces = CollectionUtil.makeMap();
    private List<Statement> m_AllStatements = CollectionUtil.makeList();
    private Map<Resource, Map<Property, Set<RDFNode>>> m_Statements = CollectionUtil.makeMap();
    private Map<Property, List<Statement>> m_StatementsByPredicate = CollectionUtil.makeMap();
    private Map<RDFNode, List<Statement>> m_StatementsByObject = CollectionUtil.makeMap();
    private Set<RDFNode> m_BNodes = CollectionUtil.makeSet();

    public void add(RDFModel other) {
        this.m_Comments.addAll(other.m_Comments);
        this.m_Namespaces.putAll(other.m_Namespaces);
        this.addAllStatements(other.getStatements());
        this.m_BNodes.addAll(other.m_BNodes);
    }

    public void add(Model jenaModel) {
        this.addAllStatements((Iterator<Statement>)jenaModel.listStatements());
    }

    public void addComment(String comment) {
        this.m_Comments.add(comment);
    }

    public List<String> getComments() {
        return this.m_Comments;
    }

    public void addNamespace(String prefix, String uri) {
        this.m_Namespaces.put(prefix, uri);
    }

    public Map<String, String> getNamespaces() {
        return this.m_Namespaces;
    }

    public void addAllStatements(Iterator<Statement> stmts) {
        while (stmts.hasNext()) {
            this.addStatement(stmts.next());
        }
    }

    public void addAllStatements(List<Statement> stmts) {
        this.addAllStatements(stmts.iterator());
    }

    public void addAllStatementsWithExistingBNodesOnly(List<Statement> stmts) {
        for (Statement stmt : stmts) {
            RDFNode o;
            Resource s = stmt.getSubject();
            if (s.isAnon() && !this.m_BNodes.contains(s) || (o = stmt.getObject()).isAnon() && !this.m_BNodes.contains(o)) continue;
            this.addStatement(stmt);
        }
    }

    public void addStatement(Statement stmt) {
        this.m_AllStatements.add(stmt);
        this.addToStatements(stmt);
        this.addToStatementsByPredicate(stmt);
        this.addToStatementsByObject(stmt);
        this.addToBNodes((RDFNode)stmt.getSubject());
        this.addToBNodes(stmt.getObject());
    }

    private void addToBNodes(RDFNode v) {
        if (v.isAnon()) {
            this.m_BNodes.add(v);
        }
    }

    public List<Statement> getStatements() {
        return this.m_AllStatements;
    }

    public Collection<Statement> getStatementsByPredicate(Property predicate) {
        List<Statement> list = this.m_StatementsByPredicate.get(predicate);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Collection<Statement> getStatementsByObject(RDFNode object) {
        List<Statement> list = this.m_StatementsByObject.get(object);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Collection<RDFNode> getValues(Resource subject, Property predicate) {
        Map<Property, Set<RDFNode>> pMap = this.m_Statements.get(subject);
        if (pMap == null) {
            return Collections.emptyList();
        }
        Set<RDFNode> list = pMap.get(predicate);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public RDFNode getUniqueObject(Resource subject, Property predicate) {
        Collection<RDFNode> values = this.getValues(subject, predicate);
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public boolean containsStatement(Resource subject, Property predicate, RDFNode object) {
        Collection<RDFNode> values = this.getValues(subject, predicate);
        if (values.isEmpty()) {
            return false;
        }
        return values.contains(object);
    }

    private void addToStatements(Statement stmt) {
        Set<Object> values;
        Resource s = stmt.getSubject();
        Property p = stmt.getPredicate();
        RDFNode v = stmt.getObject();
        Map<Object, Set<Object>> pMap = this.m_Statements.get(s);
        if (pMap == null) {
            pMap = CollectionUtil.makeMap();
            this.m_Statements.put(s, pMap);
        }
        if ((values = pMap.get(p)) == null) {
            values = CollectionUtil.makeSet();
            pMap.put(p, values);
        }
        values.add(v);
    }

    private void addToStatementsByPredicate(Statement stmt) {
        Property p = stmt.getPredicate();
        List<Object> list = this.m_StatementsByPredicate.get(p);
        if (list == null) {
            list = CollectionUtil.makeList();
            this.m_StatementsByPredicate.put(p, list);
        }
        list.add(stmt);
    }

    private void addToStatementsByObject(Statement stmt) {
        RDFNode o = stmt.getObject();
        List<Object> list = this.m_StatementsByObject.get(o);
        if (list == null) {
            list = CollectionUtil.makeList();
            this.m_StatementsByObject.put(o, list);
        }
        list.add(stmt);
    }
}

