/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class OptimizedQueryEngine2
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());
    private QueryResult results;
    private KnowledgeBase kb;

    public boolean supports(Query q) {
        return !q.getDistVars().isEmpty();
    }

    private void exec(Query q, ResultBinding binding, boolean first) {
        HashSet instances;
        if (q.getDistVars().isEmpty()) {
            this.results.add(binding);
            return;
        }
        Iterator<ATermAppl> i = q.getDistVars().iterator();
        ATermAppl var = i.next();
        Set<ATermAppl> empty = Collections.emptySet();
        ATermAppl clazz = q.rollUpTo(var, empty, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Rolling up " + var + " to " + clazz);
        }
        if (first) {
            instances = new HashSet(this.kb.getIndividuals());
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, var, null, null)) {
                instances.retainAll(this.kb.retrieveIndividualsWithProperty(atom.getArguments().get(1)));
            }
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, null, null, var)) {
                instances.retainAll(this.kb.retrieveIndividualsWithProperty(ATermUtils.makeInv((ATermAppl)atom.getArguments().get(1))));
            }
        } else {
            instances = this.kb.getInstances(clazz);
        }
        for (ATermAppl b : instances) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("trying " + var + " --> " + b);
            }
            ResultBinding newBinding = binding.duplicate();
            newBinding.setValue(var, b);
            Query q2 = q.apply(newBinding);
            this.exec(q2, newBinding, false);
        }
    }

    public QueryResult execABoxQuery(Query q) {
        this.results = new QueryResultImpl(q);
        this.kb = q.getKB();
        long satCount = this.kb.getABox().stats.satisfiabilityCount;
        long consCount = this.kb.getABox().stats.consistencyCount;
        this.exec(q, new ResultBindingImpl(), true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Total satisfiability operations: " + (this.kb.getABox().stats.satisfiabilityCount - satCount));
            log.fine("Total consistency operations: " + (this.kb.getABox().stats.consistencyCount - consCount));
            log.fine("Results of ABox query : " + this.results);
        }
        return this.results;
    }
}

