/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import com.clarkparsia.pellet.sparqldl.engine.CostBasedQueryPlanNew;
import com.clarkparsia.pellet.sparqldl.engine.IncrementalQueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.NoReorderingQueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.model.Query;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PelletOptions;

public class QueryOptimizer {
    private static final Logger LOG = Logger.getLogger(QueryOptimizer.class.getName());

    public QueryPlan getExecutionPlan(Query query) {
        if (PelletOptions.SAMPLING_RATIO == 0.0) {
            return new NoReorderingQueryPlan(query);
        }
        if (query.getAtoms().size() > PelletOptions.STATIC_REORDERING_LIMIT) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Using incremental query plan.");
            }
            return new IncrementalQueryPlan(query);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Using full query plan.");
        }
        return new CostBasedQueryPlanNew(query);
    }
}

