/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLResultSet;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import com.hp.hpl.jena.sparql.engine.main.StageGeneratorGeneric;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.utils.ATermUtils;

class SparqlDLStage {
    public static final Logger log = Logger.getLogger(SparqlDLStage.class.getName());
    private ARQParser parser;
    private BasicPattern pattern;
    private Collection<String> vars;

    public SparqlDLStage(BasicPattern pattern) {
        this(pattern, true);
    }

    public SparqlDLStage(BasicPattern pattern, boolean handleVariableSPO) {
        this.pattern = pattern;
        this.parser = new ARQParser(handleVariableSPO);
        this.initVars();
    }

    private void initVars() {
        this.vars = new LinkedHashSet<String>();
        for (int i = 0; i < this.pattern.size(); ++i) {
            Triple t = this.pattern.get(i);
            if (ARQParser.isDistinguishedVariable(t.getSubject())) {
                this.vars.add(t.getSubject().getName());
            }
            if (t.getPredicate().isVariable()) {
                this.vars.add(t.getPredicate().getName());
            }
            if (!ARQParser.isDistinguishedVariable(t.getObject())) continue;
            this.vars.add(t.getObject().getName());
        }
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new UnsupportedOperationException("A Pellet-backed model is required");
        }
        PelletInfGraph pellet = (PelletInfGraph)graph;
        pellet.prepare();
        Query query = this.parsePattern(pellet);
        if (query != null) {
            return new PelletQueryIterator(pellet, query, input, execCxt);
        }
        return new StageGeneratorGeneric().execute(this.pattern, input, execCxt);
    }

    private Query parsePattern(PelletInfGraph pellet) {
        try {
            return this.parser.parse(this.pattern, this.vars, pellet.getKB(), false);
        }
        catch (UnsupportedQueryException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Falling back to Jena stage", e);
            }
            return null;
        }
    }

    private static class PelletQueryIterator
    extends QueryIterRepeatApply {
        private PelletInfGraph pellet;
        private Query query;

        public PelletQueryIterator(PelletInfGraph pellet, Query query, QueryIterator input, ExecutionContext execCxt) {
            super(input, execCxt);
            this.pellet = pellet;
            this.query = query;
        }

        private ResultBinding convertBinding(Binding binding) {
            ResultBindingImpl pelletBinding = new ResultBindingImpl();
            GraphLoader loader = this.pellet.getLoader();
            Iterator vars = binding.vars();
            while (vars.hasNext()) {
                Var var = (Var)vars.next();
                Node value = binding.get(var);
                if (value == null) continue;
                ATermAppl pelletVar = ATermUtils.makeVar((String)var.getVarName());
                ATermAppl pelletValue = loader.node2term(value);
                pelletBinding.setValue(pelletVar, pelletValue);
            }
            return pelletBinding;
        }

        protected QueryIterator nextStage(Binding binding) {
            Query newQuery = this.query.apply(this.convertBinding(binding));
            QueryResult results = QueryEngine.exec(newQuery);
            SparqlDLResultSet resultSet = new SparqlDLResultSet(results, null, binding);
            QueryIteratorResultSet iter = new QueryIteratorResultSet((ResultSet)resultSet);
            return iter;
        }
    }
}

