/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.FunctionApplicationVisitor;
import com.clarkparsia.pellet.rules.builtins.NumberToLiteralVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;

public class NumericAdapter
implements Function {
    private NumericFunction function;

    public NumericAdapter(NumericFunction function) {
        this.function = function;
    }

    public Literal apply(ABox abox, Literal expected, Literal ... args) {
        Number expectedNum = null;
        Number result = null;
        Literal resultLit = null;
        if (expected != null) {
            if (!(expected.getValue() instanceof Number)) {
                ABox.log.info("Testing non-numeric against the result of a numeric function '" + this.function + "': " + expected);
                return null;
            }
            expectedNum = (Number)expected.getValue();
        }
        Number[] numArgs = new Number[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i].getValue() instanceof Number)) {
                ABox.log.info("Non numeric arguments to numeric function '" + this.function + "': " + args[i]);
                return null;
            }
            numArgs[i] = (Number)args[i].getValue();
        }
        NumericPromotion promoter = new NumericPromotion();
        promoter.promote(numArgs);
        FunctionApplicationVisitor visitor = new FunctionApplicationVisitor(this.function, expectedNum);
        promoter.accept(visitor);
        result = visitor.getResult();
        if (result != null) {
            if (expected != null) {
                resultLit = expected;
            } else {
                NumberToLiteralVisitor converter = new NumberToLiteralVisitor(abox);
                promoter.promote(result);
                promoter.accept(converter);
                resultLit = converter.getLiteral();
            }
        }
        return resultLit;
    }
}

