/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermTuple
extends Tuple<ATermAppl> {
    private static String format(ATermAppl term) {
        return ATermUtils.toString((ATermAppl)term);
    }

    public TermTuple(DependencySet ds, List<ATermAppl> terms) {
        super(ds, terms);
    }

    public TermTuple(DependencySet ds, ATermAppl ... terms) {
        super(ds, terms);
    }

    public TermTuple(ATermAppl ... terms) {
        super(DependencySet.INDEPENDENT, terms);
    }

    public boolean equals(Object other) {
        if (other instanceof TermTuple) {
            TermTuple otherFact = (TermTuple)other;
            return ((Object)this.getElements()).equals(otherFact.getElements());
        }
        return false;
    }

    public List<ATermAppl> getVars() {
        ArrayList<ATermAppl> v = new ArrayList<ATermAppl>();
        for (ATermAppl term : this.getElements()) {
            if (!ATermUtils.isVar((ATermAppl)term)) continue;
            v.add(term);
        }
        return v;
    }

    @Override
    public String toString() {
        if (this.getElements().size() == 3) {
            ATermAppl pred = (ATermAppl)this.getElements().get(0);
            ATermAppl subj = (ATermAppl)this.getElements().get(1);
            ATermAppl obj = (ATermAppl)this.getElements().get(2);
            if (pred.equals(Compiler.TYPE)) {
                return TermTuple.format(obj) + "(" + TermTuple.format(subj) + ")";
            }
            if (pred.equals(Compiler.SAME_AS)) {
                return TermTuple.format(subj) + " = " + TermTuple.format(obj);
            }
            if (pred.equals(Compiler.DIFF_FROM)) {
                return TermTuple.format(subj) + " != " + TermTuple.format(obj);
            }
            return TermTuple.format(pred) + "(" + TermTuple.format(subj) + "," + TermTuple.format(obj) + ")";
        }
        Iterator i = this.getElements().iterator();
        StringBuilder sb = new StringBuilder();
        if (i.hasNext()) {
            sb.append(TermTuple.format((ATermAppl)i.next()));
        }
        sb.append("(");
        while (i.hasNext()) {
            sb.append(TermTuple.format((ATermAppl)i.next()));
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

