/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.sesamejena.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.XSD;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openjena.sesamejena.SesameJena;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;

public class SesameJenaTest {
    private ValueFactory testValueFactory;
    private Model testModelEmpty;
    private Model testModelSingleURIURITypedLiteral;
    private Model testModelSingleURIURIPlainLiteral;
    private Model testModelSingleURIURILanguageLiteral;
    private Model testModelSingleURIURIBlankNode;
    private Model testModelSingleURIURIURI;
    private com.hp.hpl.jena.rdf.model.Resource testSubjectUri1;
    private Property testPredicateUri1;
    private com.hp.hpl.jena.rdf.model.Literal testTypedLiteral1;
    private com.hp.hpl.jena.rdf.model.Literal testPlainLiteral1;
    private com.hp.hpl.jena.rdf.model.Literal testLanguageLiteral1;
    private com.hp.hpl.jena.rdf.model.Resource testBlankNode1;
    private com.hp.hpl.jena.rdf.model.Resource testObjectUri1;
    private Object testStatementURIURIBlankNode1;
    private URI testSesameSubjectUri1;
    private URI testSesamePredicateUri1;
    private URI testSesameObjectUri1;
    private BNode testSesameObjectBlankNode1;
    private Statement testStatementURIURIURI1;
    private Literal testSesameObjectPlainLiteral1;
    private Literal testSesameObjectTypedLiteral1;
    private Statement testStatementURIURIPlainLiteral1;
    private Statement testStatementURIURITypedLiteral1;
    private Object testStatementURIURILanguageLiteral1;
    private Literal testSesameObjectLanguageLiteral1;

    @Before
    public void setUp() throws Exception {
        this.testValueFactory = new ValueFactoryImpl();
        this.testSubjectUri1 = ResourceFactory.createResource((String)"http://test.example.org/test/subject/uri/1");
        this.testPredicateUri1 = ResourceFactory.createProperty((String)"http://test.example.org/test/property/uri/aValidJenaXMLUri1");
        this.testObjectUri1 = ResourceFactory.createResource((String)"http://test.example.org/test/object/uri/1");
        this.testPlainLiteral1 = ResourceFactory.createPlainLiteral((String)"My Test Plain Literal!");
        this.testTypedLiteral1 = ResourceFactory.createTypedLiteral((String)"123678", (RDFDatatype)TypeMapper.getInstance().getSafeTypeByName(XSD.integer.getURI()));
        this.testModelEmpty = ModelFactory.createDefaultModel();
        this.testModelSingleURIURITypedLiteral = ModelFactory.createDefaultModel();
        this.testModelSingleURIURITypedLiteral.add(this.testSubjectUri1, this.testPredicateUri1, (RDFNode)this.testTypedLiteral1);
        this.testModelSingleURIURIPlainLiteral = ModelFactory.createDefaultModel();
        this.testModelSingleURIURIPlainLiteral.add(this.testSubjectUri1, this.testPredicateUri1, (RDFNode)this.testPlainLiteral1);
        this.testModelSingleURIURILanguageLiteral = ModelFactory.createDefaultModel();
        this.testLanguageLiteral1 = this.testModelSingleURIURILanguageLiteral.createLiteral("Just a test language string in some random language", "en_AU");
        this.testModelSingleURIURILanguageLiteral.add(this.testSubjectUri1, this.testPredicateUri1, (RDFNode)this.testLanguageLiteral1);
        this.testModelSingleURIURIBlankNode = ModelFactory.createDefaultModel();
        this.testBlankNode1 = this.testModelSingleURIURIBlankNode.createResource(new AnonId("myTestBlankNodeId987654"));
        this.testModelSingleURIURIBlankNode.add(this.testSubjectUri1, this.testPredicateUri1, (RDFNode)this.testBlankNode1);
        this.testModelSingleURIURIURI = ModelFactory.createDefaultModel();
        this.testModelSingleURIURIURI.add(this.testSubjectUri1, this.testPredicateUri1, (RDFNode)this.testObjectUri1);
        this.testSesameSubjectUri1 = this.testValueFactory.createURI("http://test.example.org/test/subject/uri/1");
        this.testSesamePredicateUri1 = this.testValueFactory.createURI("http://test.example.org/test/property/uri/aValidJenaXMLUri1");
        this.testSesameObjectUri1 = this.testValueFactory.createURI("http://test.example.org/test/object/uri/1");
        this.testSesameObjectBlankNode1 = this.testValueFactory.createBNode("myTestBlankNodeId987654");
        this.testSesameObjectPlainLiteral1 = this.testValueFactory.createLiteral("My Test Plain Literal!");
        this.testSesameObjectTypedLiteral1 = this.testValueFactory.createLiteral("123678", this.testValueFactory.createURI(XSD.integer.getURI()));
        this.testSesameObjectLanguageLiteral1 = this.testValueFactory.createLiteral("Just a test language string in some random language", "en_AU");
        this.testStatementURIURIBlankNode1 = this.testValueFactory.createStatement((Resource)this.testSesameSubjectUri1, this.testSesamePredicateUri1, (Value)this.testSesameObjectBlankNode1);
        this.testStatementURIURIURI1 = this.testValueFactory.createStatement((Resource)this.testSesameSubjectUri1, this.testSesamePredicateUri1, (Value)this.testSesameObjectUri1);
        this.testStatementURIURIPlainLiteral1 = this.testValueFactory.createStatement((Resource)this.testSesameSubjectUri1, this.testSesamePredicateUri1, (Value)this.testSesameObjectPlainLiteral1);
        this.testStatementURIURITypedLiteral1 = this.testValueFactory.createStatement((Resource)this.testSesameSubjectUri1, this.testSesamePredicateUri1, (Value)this.testSesameObjectTypedLiteral1);
        this.testStatementURIURILanguageLiteral1 = this.testValueFactory.createStatement((Resource)this.testSesameSubjectUri1, this.testSesamePredicateUri1, (Value)this.testSesameObjectLanguageLiteral1);
    }

    @After
    public void tearDown() throws Exception {
        this.testValueFactory = null;
        this.testSubjectUri1 = null;
        this.testPredicateUri1 = null;
        this.testObjectUri1 = null;
        this.testPlainLiteral1 = null;
        this.testTypedLiteral1 = null;
        this.testLanguageLiteral1 = null;
        this.testBlankNode1 = null;
        this.testModelEmpty = null;
        this.testModelSingleURIURITypedLiteral = null;
        this.testModelSingleURIURIPlainLiteral = null;
        this.testModelSingleURIURILanguageLiteral = null;
        this.testModelSingleURIURIBlankNode = null;
        this.testModelSingleURIURIURI = null;
        this.testStatementURIURIBlankNode1 = null;
        this.testStatementURIURIURI1 = null;
        this.testStatementURIURIPlainLiteral1 = null;
        this.testStatementURIURITypedLiteral1 = null;
        this.testStatementURIURILanguageLiteral1 = null;
        this.testSesameSubjectUri1 = null;
        this.testSesamePredicateUri1 = null;
        this.testSesameObjectUri1 = null;
        this.testSesameObjectBlankNode1 = null;
        this.testSesameObjectPlainLiteral1 = null;
        this.testSesameObjectTypedLiteral1 = null;
        this.testSesameObjectLanguageLiteral1 = null;
    }

    @Test
    public void testGraphBlankNode() {
        Assert.assertEquals((long)1L, (long)this.testModelSingleURIURIBlankNode.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelSingleURIURIBlankNode);
        Assert.assertEquals((long)1L, (long)nextGraph.size());
        Assert.assertTrue((boolean)nextGraph.contains(this.testStatementURIURIBlankNode1));
    }

    @Test
    public void testGraphEmpty() {
        Assert.assertEquals((long)0L, (long)this.testModelEmpty.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelEmpty);
        Assert.assertEquals((long)0L, (long)nextGraph.size());
    }

    @Test
    public void testGraphLanguageLiteral() {
        Assert.assertEquals((long)1L, (long)this.testModelSingleURIURILanguageLiteral.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelSingleURIURILanguageLiteral);
        Assert.assertEquals((long)1L, (long)nextGraph.size());
    }

    @Test
    public void testGraphPlainLiteral() {
        Assert.assertEquals((long)1L, (long)this.testModelSingleURIURIPlainLiteral.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelSingleURIURIPlainLiteral);
        Assert.assertEquals((long)1L, (long)nextGraph.size());
    }

    @Test
    public void testGraphTypedLiteral() {
        Assert.assertEquals((long)1L, (long)this.testModelSingleURIURITypedLiteral.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelSingleURIURITypedLiteral);
        Assert.assertEquals((long)1L, (long)nextGraph.size());
    }

    @Test
    public void testGraphURI() {
        Assert.assertEquals((long)1L, (long)this.testModelSingleURIURIURI.size());
        Graph nextGraph = SesameJena.createGraph((ValueFactory)this.testValueFactory, (Model)this.testModelSingleURIURIURI);
        Assert.assertEquals((long)1L, (long)nextGraph.size());
    }
}

