/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.sesamejena.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Collection;
import java.util.Iterator;
import org.openjena.jenasesame.util.Convert;
import org.openjena.jenasesame.util.JenaStatementToSesameStatementIterator;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;

public class GraphModel
extends GraphImpl
implements Graph,
Collection<Statement> {
    private static final long serialVersionUID = -1803550586980209750L;
    private Model jenaModel;

    public GraphModel(ValueFactory factory, Model nextJenaModel) {
        super(factory);
        this.jenaModel = nextJenaModel;
    }

    @Override
    public boolean add(Statement stmt) {
        this.jenaModel.add((com.hp.hpl.jena.rdf.model.Resource)Convert.resourceToNode((Resource)stmt.getSubject()), (Property)Convert.uriToNode((URI)stmt.getPredicate()), (RDFNode)Convert.valueToNode((Value)stmt.getObject()));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Statement> collection) {
        for (Statement statement : collection) {
            this.add(statement);
        }
        return true;
    }

    @Override
    public void clear() {
        this.jenaModel = this.jenaModel.removeAll();
    }

    @Override
    public boolean contains(Object nextObject) {
        if (!(nextObject instanceof Statement)) {
            return false;
        }
        Statement stmt = (Statement)nextObject;
        return this.jenaModel.contains(Convert.statementToJenaStatement((Model)this.jenaModel, (Statement)stmt));
    }

    @Override
    public boolean containsAll(Collection<? extends Object> arg0) {
        for (Object object : arg0) {
            if (object instanceof Statement) {
                if (this.contains(object)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof Graph)) {
            return false;
        }
        Graph graph = (Graph)arg0;
        return this.containsAll((Collection<? extends Object>)graph);
    }

    @Override
    public int hashCode() {
        return this.jenaModel.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.jenaModel.isEmpty();
    }

    @Override
    public Iterator<Statement> iterator() {
        return new JenaStatementToSesameStatementIterator(this.getValueFactory(), this.jenaModel.listStatements());
    }

    @Override
    public boolean remove(Object arg0) {
        Statement stmt;
        if (arg0 instanceof Statement && this.contains(stmt = (Statement)arg0)) {
            this.jenaModel = this.jenaModel.remove(Convert.statementToJenaStatement((Model)this.jenaModel, (Statement)stmt));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean change = false;
        for (Object nextStmt : arg0) {
            Statement stmt;
            if (!(nextStmt instanceof Statement) || !this.contains(stmt = (Statement)nextStmt)) continue;
            if (!this.remove(stmt)) {
                return false;
            }
            change = true;
        }
        return change;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("Retain all is not supported by this collection.");
    }

    @Override
    public int size() {
        return (int)this.jenaModel.size();
    }

    @Override
    public Object[] toArray() {
        return this.jenaModel.listStatements().toList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.jenaModel.listStatements().toList().toArray(new Object[this.size()]);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public boolean add(Resource subj, URI pred, Value obj, Resource ... contexts) {
        this.jenaModel = this.jenaModel.add((com.hp.hpl.jena.rdf.model.Resource)Convert.resourceToNode((Resource)subj), (Property)Convert.uriToNode((URI)pred), (RDFNode)Convert.valueToNode((Value)obj));
        return true;
    }

    public Iterator<Statement> match(Resource subj, URI pred, Value obj, Resource ... contexts) {
        com.hp.hpl.jena.rdf.model.Resource subject = null;
        Property property = null;
        RDFNode object = null;
        if (subj != null) {
            subject = (com.hp.hpl.jena.rdf.model.Resource)Convert.resourceToNode((Resource)subj);
        }
        if (pred != null) {
            property = (Property)Convert.uriToNode((URI)pred);
        }
        if (obj != null) {
            object = (RDFNode)Convert.valueToNode((Value)obj);
        }
        return new JenaStatementToSesameStatementIterator(this.getValueFactory(), this.jenaModel.listStatements(subject, property, object));
    }
}

