/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object;

import java.io.Serializable;
import java.util.Locale;

public class LangString
implements CharSequence,
Serializable,
Comparable<LangString> {
    private static final long serialVersionUID = 8175463447271413979L;
    private final String label;
    private final String lang;
    private Locale locale;

    public static LangString valueOf(String label) {
        return new LangString(label);
    }

    public static LangString valueOf(String label, String language) {
        return new LangString(label, language);
    }

    private static String toLang(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        boolean l = language.length() != 0;
        boolean c = country.length() != 0;
        boolean v = variant.length() != 0;
        StringBuilder result = new StringBuilder(language);
        if (c || l && v) {
            result.append('-').append(country.toLowerCase());
        }
        if (v && (l || c)) {
            result.append('-').append(variant);
        }
        return result.toString();
    }

    public LangString(String label) {
        this(label, Locale.getDefault());
    }

    public LangString(String label, String lang) {
        assert (label != null);
        if (lang != null && lang.length() < 1) {
            throw new IllegalArgumentException("language cannot be the empty string");
        }
        this.label = label;
        this.lang = lang == null ? LangString.toLang(Locale.getDefault()) : lang;
    }

    public LangString(String label, Locale locale) {
        this(label, LangString.toLang(locale));
        this.locale = locale;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public String toString() {
        return this.label;
    }

    public synchronized Locale getLocale() {
        if (this.locale == null) {
            String[] split = this.getLang().split("-", 3);
            this.locale = split.length == 1 ? new Locale(this.getLang()) : (split.length == 2 ? new Locale(split[0], split[1]) : new Locale(split[0], split[1], split[2]));
        }
        return this.locale;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LangString) {
            LangString other = (LangString)o;
            if (!this.toString().equals(other.toString())) {
                return false;
            }
            return this.getLang().equalsIgnoreCase(other.getLang());
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LangString) {
            LangString other = (LangString)o;
            if (!this.toString().equalsIgnoreCase(other.toString())) {
                return false;
            }
            return this.getLang().equalsIgnoreCase(other.getLang());
        }
        return false;
    }

    @Override
    public int compareTo(LangString o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int result = this.getLang().compareToIgnoreCase(o.getLang());
        if (result == 0) {
            return this.toString().compareTo(o.toString());
        }
        return result;
    }

    public int compareToIgnoreCase(LangString o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int result = this.getLang().compareToIgnoreCase(o.getLang());
        if (result == 0) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
        return result;
    }

    public boolean matchesLang(String range) {
        String[] subranges;
        String[] subtags = this.getLang().split("-");
        if (!subtags[0].equalsIgnoreCase((subranges = range.split("-"))[0])) {
            return false;
        }
        int r = 1;
        int t = 1;
        while (r < subranges.length) {
            if ("*".equals(subranges[r])) {
                ++r;
                continue;
            }
            if (t >= subtags.length) {
                return false;
            }
            if (subranges[r].equalsIgnoreCase(subtags[t])) {
                ++r;
                ++t;
                continue;
            }
            if (subtags[t].length() == 1) {
                return false;
            }
            ++t;
        }
        return true;
    }

    public LangString concat(LangString str) {
        String substring;
        String l2;
        String concat = this.toString().concat(str.toString());
        String l1 = this.getLang();
        if (l1.equalsIgnoreCase(l2 = str.getLang())) {
            return new LangString(concat, l1);
        }
        if (str.matchesLang(l1)) {
            return new LangString(concat, l1);
        }
        if (this.matchesLang(l2)) {
            return new LangString(concat, l2);
        }
        String prefix = l1.length() < l2.length() ? l1 : l2;
        String other = l1.length() < l2.length() ? l2 : l1;
        String common = "";
        int i = prefix.indexOf(45);
        while (i >= 0 && (substring = prefix.substring(0, i + 1)).equalsIgnoreCase(other.substring(0, i + 1))) {
            common = substring;
            i = prefix.indexOf(45, i + 1);
        }
        if (common.length() < 1) {
            throw new IllegalArgumentException("Different languages cannot be concatenated: " + l1 + " and " + l2);
        }
        return new LangString(concat, common);
    }

    public LangString concat(String str) {
        return new LangString(this.toString().concat(str), this.getLang());
    }

    @Override
    public LangString subSequence(int start, int end) {
        return new LangString(this.toString().substring(start, end), this.getLang());
    }

    public LangString substring(int beginIndex) {
        return new LangString(this.toString().substring(beginIndex), this.getLang());
    }

    public LangString substring(int beginIndex, int endIndex) {
        return new LangString(this.toString().substring(beginIndex, endIndex), this.getLang());
    }

    public LangString replace(char oldChar, char newChar) {
        return new LangString(this.toString().replace(oldChar, newChar), this.getLang());
    }

    public LangString replaceFirst(String regex, String replacement) {
        return new LangString(this.toString().replaceFirst(regex, replacement), this.getLang());
    }

    public LangString replaceAll(String regex, String replacement) {
        return new LangString(this.toString().replaceAll(regex, replacement), this.getLang());
    }

    public LangString replace(CharSequence target, CharSequence replacement) {
        return new LangString(this.toString().replace(target, replacement), this.getLang());
    }

    public LangString[] split(String regex, int limit) {
        String[] split = this.toString().split(regex, limit);
        LangString[] result = new LangString[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = new LangString(split[i], this.getLang());
        }
        return result;
    }

    public LangString[] split(String regex) {
        return this.split(regex, 0);
    }

    public LangString toLowerCase() {
        return new LangString(this.toString().toLowerCase(this.getLocale()), this.getLang());
    }

    public LangString toUpperCase() {
        return new LangString(this.toString().toUpperCase(this.getLocale()), this.getLang());
    }

    public LangString trim() {
        return new LangString(this.toString().trim(), this.getLang());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final boolean isEmpty() {
        return this.toString().isEmpty();
    }

    public final boolean contentEquals(CharSequence cs) {
        return this.toString().contentEquals(cs);
    }

    public final boolean regionMatches(int toffset, CharSequence other, int ooffset, int len) {
        return this.toString().regionMatches(toffset, other.toString(), ooffset, len);
    }

    public final boolean regionMatches(boolean ignoreCase, int toffset, CharSequence other, int ooffset, int len) {
        return this.toString().regionMatches(ignoreCase, toffset, other.toString(), ooffset, len);
    }

    public final boolean startsWith(CharSequence prefix, int toffset) {
        return this.toString().startsWith(prefix.toString(), toffset);
    }

    public final boolean startsWith(CharSequence prefix) {
        return this.toString().startsWith(prefix.toString());
    }

    public final boolean endsWith(CharSequence suffix) {
        return this.toString().endsWith(suffix.toString());
    }

    public final int indexOf(int ch) {
        return this.toString().indexOf(ch);
    }

    public final int indexOf(int ch, int fromIndex) {
        return this.toString().indexOf(ch, fromIndex);
    }

    public final int lastIndexOf(int ch) {
        return this.toString().lastIndexOf(ch);
    }

    public final int lastIndexOf(int ch, int fromIndex) {
        return this.toString().lastIndexOf(ch, fromIndex);
    }

    public final int indexOf(CharSequence str) {
        return this.toString().indexOf(str.toString());
    }

    public final int indexOf(CharSequence str, int fromIndex) {
        return this.toString().indexOf(str.toString(), fromIndex);
    }

    public final int lastIndexOf(CharSequence str) {
        return this.toString().lastIndexOf(str.toString());
    }

    public final int lastIndexOf(CharSequence str, int fromIndex) {
        return this.toString().lastIndexOf(str.toString(), fromIndex);
    }

    public final boolean matches(String regex) {
        return this.toString().matches(regex);
    }

    public final boolean contains(CharSequence s) {
        return this.toString().contains(s);
    }
}

