/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advice;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.openrdf.repository.object.advice.AdviceFactory;
import org.openrdf.repository.object.advice.AdviceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdviceService {
    private static final ServiceLoader<AdviceProvider> installed = ServiceLoader.load(AdviceProvider.class, AdviceService.class.getClassLoader());
    private final Logger logger = LoggerFactory.getLogger(AdviceService.class);
    private final ServiceLoader<AdviceProvider> loader;
    private final Map<Class<?>, AdviceFactory> factories = new HashMap();

    public static AdviceService newInstance() {
        return AdviceService.newInstance(Thread.currentThread().getContextClassLoader());
    }

    public static AdviceService newInstance(ClassLoader cl) {
        return new AdviceService(cl == null ? AdviceService.class.getClassLoader() : cl);
    }

    public AdviceService(ClassLoader cl) {
        this.loader = ServiceLoader.load(AdviceProvider.class, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AdviceFactory getAdviserFactory(Class<?> annotationType) {
        if (this.factories.containsKey(annotationType)) {
            return this.factories.get(annotationType);
        }
        AdviceFactory factory = this.getAdviceFactory(annotationType, this.loader);
        if (factory != null) {
            this.factories.put(annotationType, factory);
            return factory;
        }
        ServiceLoader<AdviceProvider> serviceLoader = installed;
        synchronized (serviceLoader) {
            factory = this.getAdviceFactory(annotationType, installed);
        }
        if (factory != null) {
            this.factories.put(annotationType, factory);
            return factory;
        }
        this.factories.put(annotationType, null);
        return null;
    }

    private AdviceFactory getAdviceFactory(Class<?> type, ServiceLoader<AdviceProvider> loader) {
        Iterator<AdviceProvider> iter = loader.iterator();
        while (iter.hasNext()) {
            try {
                AdviceFactory f = iter.next().getAdviserFactory(type);
                if (f == null) continue;
                this.factories.put(type, f);
                return f;
            }
            catch (ServiceConfigurationError e) {
                this.logger.warn(e.getMessage());
            }
        }
        return null;
    }
}

