/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advice.behaviour;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.composition.BehaviourFactory;

public class AdviceBehaviourFactory
implements BehaviourFactory {
    private static final Method intercept = Advice.class.getMethods()[0];
    private final Advice advice;
    private final Method intercepting;
    private final Class<?>[] parameterTypes;
    private final Class<?> annotationType;

    public AdviceBehaviourFactory(Advice advice, Method intercepting, Class<?> annotationType) {
        assert (advice != null);
        assert (intercepting != null);
        assert (annotationType != null);
        this.advice = advice;
        this.intercepting = intercepting;
        this.annotationType = annotationType;
        this.parameterTypes = intercepting.isAnnotationPresent(ParameterTypes.class) ? intercepting.getAnnotation(ParameterTypes.class).value() : intercepting.getParameterTypes();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getBehaviourType().getSimpleName();
    }

    @Override
    public Class<?> getBehaviourType() {
        return Advice.class;
    }

    @Override
    public Class<?>[] getInterfaces() {
        return new Class[0];
    }

    @Override
    public Method[] getMethods() {
        return new Method[]{this.intercepting};
    }

    @Override
    public synchronized Method getInvocation(Method method) {
        if (this.intercepting.equals(method)) {
            return intercept;
        }
        if (this.intercepting.getName().equals(method.getName())) {
            Object[] aptypes;
            Object[] ptypes = method.getParameterTypes();
            if (Arrays.equals(ptypes, this.parameterTypes)) {
                return intercept;
            }
            if (method.isAnnotationPresent(ParameterTypes.class) && Arrays.equals(aptypes = method.getAnnotation(ParameterTypes.class).value(), this.parameterTypes)) {
                return intercept;
            }
        }
        return null;
    }

    @Override
    public boolean precedes(Method invocation, BehaviourFactory factory, Method to) {
        if (factory instanceof AdviceBehaviourFactory) {
            Class<?> ocls;
            AdviceBehaviourFactory o = (AdviceBehaviourFactory)factory;
            Class<?> cls = this.intercepting.getDeclaringClass();
            if (cls.isAssignableFrom(ocls = o.intercepting.getDeclaringClass())) {
                return false;
            }
            if (ocls.isAssignableFrom(cls)) {
                return true;
            }
            if (this.intercepting.equals(o.intercepting)) {
                for (Annotation ann : this.intercepting.getAnnotations()) {
                    if (ann.annotationType().equals(o.annotationType)) {
                        return false;
                    }
                    if (!ann.annotationType().equals(this.annotationType)) continue;
                    return true;
                }
            }
            return false;
        }
        return !to.isAnnotationPresent(ParameterTypes.class);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Object getSingleton() {
        return this.advice;
    }

    @Override
    public Object newInstance(Object proxy) throws Throwable {
        return this.advice;
    }
}

