/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.advice.behaviour;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.advice.AdviceFactory;
import org.openrdf.repository.object.advice.AdviceService;
import org.openrdf.repository.object.advice.behaviour.AdviceBehaviourFactory;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.composition.BehaviourProvider;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.managers.PropertyMapper;

public class AdviceBehaviourProvider
implements BehaviourProvider {
    private final AdviceService service = AdviceService.newInstance();

    @Override
    public void setClassDefiner(ClassFactory definer) {
    }

    @Override
    public void setBaseClasses(Set<Class<?>> bases) {
    }

    @Override
    public void setPropertyMapper(PropertyMapper mapper) {
    }

    @Override
    public Collection<? extends BehaviourFactory> getBehaviourFactories(Collection<Class<?>> classes) throws ObjectCompositionException {
        ArrayList<AdviceBehaviourFactory> list = new ArrayList<AdviceBehaviourFactory>();
        for (Class<?> cls : classes) {
            this.addAdvisers(cls, list);
        }
        return list;
    }

    private void addAdvisers(Class<?> cls, List<AdviceBehaviourFactory> list) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!this.isPublicOrProtected(method)) continue;
            this.addAdvisers(method, list);
        }
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            this.addAdvisers((Class<?>)genericDeclaration, list);
        }
        if (cls.getSuperclass() != null) {
            this.addAdvisers(cls.getSuperclass(), list);
        }
    }

    private boolean isPublicOrProtected(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    private void addAdvisers(Method method, List<AdviceBehaviourFactory> list) {
        for (Annotation ann : method.getAnnotations()) {
            Advice a;
            Class<? extends Annotation> t = ann.annotationType();
            AdviceFactory f = this.service.getAdviserFactory(t);
            if (f == null || (a = f.createAdvice(method)) == null) continue;
            list.add(new AdviceBehaviourFactory(a, method, t));
        }
    }
}

