/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class JarPacker {
    private File dir;

    public JarPacker(File dir) {
        this.dir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageJar(File output) throws IOException {
        FileOutputStream stream = new FileOutputStream(output);
        JarOutputStream jar = new JarOutputStream(stream);
        try {
            this.packaFiles(this.dir, this.dir, jar, 256);
        }
        finally {
            jar.close();
            stream.close();
        }
    }

    private void packaFiles(File base, File dir, JarOutputStream jar, int max) throws IOException, FileNotFoundException {
        if (max < 0) {
            throw new AssertionError((Object)("Recursive Path: " + dir));
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.packaFiles(base, file, jar, max - 1);
                continue;
            }
            if (!file.exists()) continue;
            String path = file.getAbsolutePath();
            path = path.substring(base.getAbsolutePath().length() + 1);
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            jar.putNextEntry(new JarEntry(path));
            this.copyInto(file.toURI().toURL(), jar);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyInto(URL source, OutputStream out) throws FileNotFoundException, IOException {
        InputStream in = source.openStream();
        try {
            int read;
            byte[] buf = new byte[512];
            while ((read = in.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            in.close();
        }
    }
}

