/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Prefix;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.LiteralManager;
import org.openrdf.repository.object.managers.RoleMapper;

public class JavaNameResolver {
    private static final Set<String> KEYWORDS_SENSITIVE = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private static final Set<String> KEYWORDS_INSENSITIVE = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private Map<String, String> packages = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<URI, URI> aliases = new HashMap<URI, URI>();
    private Map<String, String> implNames = new HashMap<String, String>();
    private Set<URI> ignore = new HashSet<URI>();
    private Model model;
    private RoleMapper roles;
    private LiteralManager literals;
    private ClassLoaderPackages cl;
    private Set<String> nouns;

    public JavaNameResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JavaNameResolver(ClassLoader cl) {
        this.cl = new ClassLoaderPackages(cl);
        for (Package pkg : this.cl.getNamespacePackages()) {
            if (!pkg.isAnnotationPresent(Prefix.class)) continue;
            String prefix = pkg.getAnnotation(Prefix.class).value();
            String ns = pkg.getAnnotation(Iri.class).value();
            this.bindPrefixToNamespace(prefix, ns);
        }
    }

    public boolean isPluralForms() {
        return this.nouns != null;
    }

    public void setPluralForms(boolean enabled) {
        if (enabled && this.nouns == null) {
            this.nouns = new HashSet<String>();
        } else if (!enabled) {
            this.nouns = null;
        }
    }

    public void setLiteralManager(LiteralManager literals) {
        this.literals = literals;
    }

    public void setRoleMapper(RoleMapper roles) {
        this.roles = roles;
    }

    public void setModel(Model model) {
        this.model = model;
        if (this.nouns != null) {
            HashSet<String> localNames = new HashSet<String>();
            for (Resource subj : model.filter(null, RDF.TYPE, null, new Resource[0]).subjects()) {
                if (!(subj instanceof URI)) continue;
                localNames.add(((URI)subj).getLocalName());
            }
            for (String name : localNames) {
                if (!name.matches("^[a-zA-Z][a-z]+$")) continue;
                this.nouns.add(name.toLowerCase());
            }
        }
    }

    public void setImplNames(Map<String, String> implNames) {
        this.implNames.putAll(implNames);
    }

    public void assignAlias(URI name, URI alias) {
        this.aliases.put(name, alias);
    }

    public void assignAnonymous(URI name) {
        this.aliases.put(name, null);
    }

    public void ignoreExistingClass(URI name) {
        this.ignore.add(name);
    }

    public void bindPackageToNamespace(String packageName, String namespace) {
        this.packages.put(namespace, this.packageName(packageName));
    }

    public void bindPrefixToNamespace(String prefix, String namespace) {
        if (prefix == null || prefix.length() == 0) {
            this.prefixes.remove(namespace);
        } else {
            this.prefixes.put(namespace, prefix);
        }
    }

    public Collection<String> getRootPackages() {
        HashSet<String> set = new HashSet<String>();
        for (String pkg : this.packages.values()) {
            if (pkg.contains(".")) {
                set.add(pkg.substring(0, pkg.indexOf(46)));
                continue;
            }
            set.add(pkg);
        }
        return set;
    }

    public URI getType(URI name) {
        if (this.aliases.containsKey(name)) {
            return this.aliases.get(name);
        }
        return name;
    }

    public boolean isAnonymous(URI name) {
        return this.getType(name) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaClass(String className) {
        try {
            ClassLoaderPackages classLoaderPackages = this.cl;
            synchronized (classLoaderPackages) {
                return Class.forName(className, true, this.cl) != null;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getClassName(URI name) throws ObjectStoreConfigException {
        Class javaClass;
        if (name == null) {
            return Object.class.getName();
        }
        if (!this.ignore.contains(name) && (javaClass = this.findJavaClass(name)) != null) {
            if (javaClass.isArray()) {
                return javaClass.getComponentType().getName() + "[]";
            }
            if (javaClass.getPackage() != null) {
                return javaClass.getName();
            }
        }
        if (!this.packages.containsKey(name.getNamespace())) {
            throw new ObjectStoreConfigException("Unknown type: " + name);
        }
        String pkg = this.getPackageName(name);
        String simple = this.word(name.getLocalName());
        if (pkg == null) {
            return simple;
        }
        return pkg + '.' + simple;
    }

    public String getAnnotationAttributeName(URI uri) throws ObjectStoreConfigException {
        Method m;
        if (!this.ignore.contains(uri) && (m = this.roles.findAnnotationMethod(uri)) != null) {
            return m.getName();
        }
        return "value";
    }

    public boolean isCompiledAnnotation(URI name) {
        return this.roles.isRecordedAnnotation(name);
    }

    public boolean isCompiledAnnotationFunctional(URI name) {
        Method ann = this.roles.findAnnotationMethod(name);
        if (ann == null) {
            return false;
        }
        return !ann.getReturnType().isArray();
    }

    public boolean isAnnotationOfClasses(URI name) {
        Method m = this.roles.findAnnotationMethod(name);
        if (m == null) {
            return false;
        }
        Class<?> type = m.getReturnType();
        return type.equals(Class.class) || type.getComponentType() != null && type.getComponentType().equals(Class.class);
    }

    public String getMethodName(URI name) {
        String ns = name.getNamespace();
        String localPart = name.getLocalName();
        if (this.prefixes.containsKey(ns)) {
            return this.word(this.getMemberPrefix(ns) + this.initcap(localPart));
        }
        return this.word(localPart);
    }

    public String getBoundPackageName(String namespace) {
        return this.packages.get(namespace);
    }

    public String getPackageName(URI uri) {
        if (this.packages.containsKey(uri.getNamespace())) {
            return this.packages.get(uri.getNamespace());
        }
        Class javaClass = this.findJavaClass(uri);
        if (javaClass == null || javaClass.getPackage() == null) {
            return null;
        }
        return javaClass.getPackage().getName();
    }

    public String getSinglePropertyName(URI name) {
        return this.getMemberName(name);
    }

    public String getSingleParameterName(URI name) {
        return this.word(name.getLocalName());
    }

    public String getPluralParameterName(URI name) {
        String ns = name.getNamespace();
        String localPart = name.getLocalName();
        String plural = this.plural(localPart);
        if (this.model.contains((Resource)new URIImpl(ns + plural), null, null, new Resource[0])) {
            plural = localPart;
        }
        return this.word(plural);
    }

    public String getMemberPrefix(String ns) {
        if (this.prefixes.containsKey(ns)) {
            return this.enc(this.prefixes.get(ns));
        }
        return "";
    }

    public String getPluralPropertyName(URI name) {
        String ns = name.getNamespace();
        String localPart = name.getLocalName();
        String plural = this.plural(localPart);
        if (this.model.contains((Resource)new URIImpl(ns + plural), null, null, new Resource[0])) {
            plural = localPart;
        }
        if (this.prefixes.containsKey(ns)) {
            return this.getMemberPrefix(ns) + this.initcap(plural);
        }
        return this.enc(plural);
    }

    public String getSimpleName(URI name) {
        if ("".equals(name.getLocalName())) {
            String ns = name.getNamespace();
            if (ns.indexOf(58) == ns.length() - 1) {
                return this.word(ns.substring(0, ns.length() - 1));
            }
            return this.getSimpleName((URI)new URIImpl(ns.substring(0, ns.length() - 1)));
        }
        return this.word(name.getLocalName());
    }

    private String getMemberName(URI name) {
        String ns = name.getNamespace();
        String localPart = name.getLocalName();
        if (this.prefixes.containsKey(ns)) {
            return this.getMemberPrefix(ns) + this.initcap(localPart);
        }
        return this.enc(localPart);
    }

    private String packageName(String pkgName) {
        StringBuilder sb = new StringBuilder();
        String[] dots = pkgName.split("\\.");
        for (int i = 0; i < dots.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.word(dots[i]));
        }
        return sb.toString();
    }

    private String word(String str) {
        String enc = this.enc(str);
        if (KEYWORDS_SENSITIVE.contains(enc)) {
            return "_" + enc;
        }
        if (KEYWORDS_INSENSITIVE.contains(enc.toUpperCase())) {
            return "_" + enc;
        }
        char first = enc.charAt(0);
        if (!Character.isLetter(first) && '_' != first && '$' != first) {
            return "_" + enc;
        }
        return enc;
    }

    private String enc(String str) {
        if (str.length() == 0) {
            return "_";
        }
        char[] name = str.toCharArray();
        StringBuffer sb = new StringBuffer(name.length);
        for (int i = 0; i < name.length; ++i) {
            if ('A' <= name[i] && name[i] <= 'Z') {
                sb.append(name[i]);
                continue;
            }
            if ('a' <= name[i] && name[i] <= 'z') {
                sb.append(name[i]);
                continue;
            }
            if ('0' <= name[i] && name[i] <= '9') {
                sb.append(name[i]);
                continue;
            }
            if ('$' == name[i]) {
                sb.append(name[i]);
                continue;
            }
            if ('*' == name[i]) {
                sb.append("Star");
                continue;
            }
            if ('#' == name[i]) {
                sb.append("Hash");
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private Class findJavaClass(URI uri) {
        if (uri.equals((Object)RDF.XMLLITERAL)) {
            return this.literals.findClass(uri);
        }
        Class klass = this.roles.findConcept(uri, this.cl);
        if (klass != null) {
            return klass;
        }
        klass = this.findLoadedMethod(uri);
        if (klass != null) {
            return klass;
        }
        Method m = this.roles.findAnnotationMethod(uri);
        if (m != null) {
            return m.getDeclaringClass();
        }
        return this.literals.findClass(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findLoadedMethod(URI URI2) {
        if (this.cl == null) {
            return null;
        }
        String sn = this.getSimpleName(URI2);
        for (Package pkg : this.cl.getNamespacePackages()) {
            String namespace = pkg.getAnnotation(Iri.class).value();
            if (!URI2.getNamespace().equals(namespace)) continue;
            try {
                ClassLoaderPackages classLoaderPackages = this.cl;
                synchronized (classLoaderPackages) {
                    return Class.forName(pkg.getName() + '.' + sn, true, this.cl);
                }
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    private String plural(String singular) {
        if (this.nouns == null) {
            return singular;
        }
        if (singular.matches(".+[A-Z_-].*") && !this.isNoun(singular.replaceAll(".*(?=[A-Z])|.*[_-]", ""))) {
            return singular;
        }
        if (singular.endsWith("s") && !singular.endsWith("ss")) {
            return singular;
        }
        if (singular.endsWith("ed")) {
            return singular;
        }
        if (singular.endsWith("y") && singular.length() > 1) {
            char c = singular.charAt(singular.length() - 2);
            if (c == 'a' || c == 'o' || c == 'e' || c == 'u' || c == 'i') {
                return singular + "s";
            }
            return singular.substring(0, singular.length() - 1) + "ies";
        }
        if (singular.endsWith("s") || singular.endsWith("x")) {
            return singular + "es";
        }
        return singular + "s";
    }

    private boolean isNoun(String word) {
        if (this.nouns == null) {
            return false;
        }
        return this.nouns.contains(word.toLowerCase());
    }

    private String initcap(String str) {
        if (str.length() == 0) {
            return "";
        }
        char[] name = str.toCharArray();
        StringBuffer sb = new StringBuffer(name.length);
        for (int i = 0; i < name.length; ++i) {
            if (i == 0) {
                sb.append(Character.toUpperCase(name[i]));
                continue;
            }
            if (name[i] == '-' || name[i] == '.') {
                if (i == name.length - 1) {
                    sb.append('_');
                    continue;
                }
                name[i + 1] = Character.toUpperCase(name[i + 1]);
                continue;
            }
            sb.append(name[i]);
        }
        return this.enc(sb.toString());
    }

    private static class ClassLoaderPackages
    extends ClassLoader {
        private Set<Package> namespacePackages = new HashSet<Package>();

        public ClassLoaderPackages(ClassLoader parent) {
            super(parent);
            for (Package pkg : this.getPackages()) {
                if (!pkg.isAnnotationPresent(Iri.class)) continue;
                this.namespacePackages.add(pkg);
            }
        }

        public Set<Package> getNamespacePackages() {
            return this.namespacePackages;
        }
    }
}

