/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespacePrefixService {
    private static NamespacePrefixService instance = new NamespacePrefixService();
    private static final String PREFIX_LOOKUP = "http://prefix.cc/reverse?format=ttl&uri=";
    private final Logger logger = LoggerFactory.getLogger(NamespacePrefixService.class);
    private final Map<String, String> prefixes = new HashMap<String, String>();

    public static synchronized NamespacePrefixService getInstance() {
        return instance;
    }

    public static synchronized void setInstance(NamespacePrefixService service) {
        instance = service;
    }

    private NamespacePrefixService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String prefix(final String ns) {
        try {
            if (this.prefixes.containsKey(ns)) {
                return this.prefixes.get(ns);
            }
            URL url = new URL(PREFIX_LOOKUP + URLEncoder.encode(ns, "UTF-8"));
            this.logger.info("Requesting {}", (Object)url);
            URLConnection con = url.openConnection();
            con.addRequestProperty("Accept", "text/turtle");
            InputStream in = con.getInputStream();
            try {
                RDFParser parser = ((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)RDFFormat.TURTLE)).getParser();
                final ArrayList match = new ArrayList();
                parser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

                    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                        if (uri.equals(ns)) {
                            match.add(prefix);
                        }
                    }
                });
                parser.parse(in, PREFIX_LOOKUP + URLEncoder.encode(ns, "UTF-8"));
                if (match.size() > 0) {
                    String prefix = (String)match.get(0);
                    this.prefixes.put(ns, prefix);
                    String string = prefix;
                    return string;
                }
                this.prefixes.put(ns, null);
                return null;
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            this.prefixes.put(ns, null);
            this.logger.trace("Unknown namespace {}", (Object)ns);
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        return null;
    }
}

