/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import info.aduna.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.object.compiler.JarPacker;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.NamespacePrefixService;
import org.openrdf.repository.object.compiler.OwlNormalizer;
import org.openrdf.repository.object.compiler.RDFDataSource;
import org.openrdf.repository.object.compiler.model.RDFClass;
import org.openrdf.repository.object.compiler.model.RDFEntity;
import org.openrdf.repository.object.compiler.model.RDFOntology;
import org.openrdf.repository.object.compiler.model.RDFProperty;
import org.openrdf.repository.object.compiler.source.ClassPathBuilder;
import org.openrdf.repository.object.compiler.source.JavaCompiler;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.LiteralManager;
import org.openrdf.repository.object.managers.RoleMapper;
import org.openrdf.repository.object.managers.helpers.RoleClassLoader;
import org.openrdf.repository.object.vocabulary.MSG;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLCompiler {
    private static final String META_INF_ANNOTATIONS = "META-INF/org.openrdf.annotations";
    private static final String META_INF_BEHAVIOURS = "META-INF/org.openrdf.behaviours";
    private static final String META_INF_CONCEPTS = "META-INF/org.openrdf.concepts";
    private static final String META_INF_DATATYPES = "META-INF/org.openrdf.datatypes";
    private static final String META_INF_ONTOLOGIES = "META-INF/org.openrdf.ontologies";
    private static final String JAVA_NS = "java:";
    Runnable helper = new Runnable(){

        @Override
        public void run() {
            try {
                Runnable r = OWLCompiler.this.queue.take();
                while (r != OWLCompiler.this.helper) {
                    r.run();
                    r = OWLCompiler.this.queue.take();
                }
            }
            catch (InterruptedException e) {
                OWLCompiler.this.logger.error(e.toString(), (Throwable)e);
            }
        }
    };
    final Logger logger = LoggerFactory.getLogger(OWLCompiler.class);
    BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private String[] baseClasses = new String[0];
    Set<String> annotations = new TreeSet<String>();
    Set<String> concepts = new TreeSet<String>();
    Map<String, List<URI>> datatypes = new HashMap<String, List<URI>>();
    Exception exception;
    LiteralManager literals;
    private RoleMapper mapper;
    private String memPrefix;
    private Model model;
    private Collection<Map<String, String>> ns = Collections.emptySet();
    private String pkgPrefix = "";
    JavaNameResolver resolver;
    private Map<URL, RDFFormat> ontologies;
    private JavaCompiler compiler = new JavaCompiler();
    private final ClassLoader cl;
    private OwlNormalizer normalizer;
    private boolean pluralForms = false;
    private boolean resolvingPrefix = false;

    private static ClassLoader findClassLoader() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == null) {
            return OWLCompiler.class.getClassLoader();
        }
        return ccl;
    }

    public OWLCompiler() throws ObjectStoreConfigException {
        this(OWLCompiler.findClassLoader());
    }

    public OWLCompiler(ClassLoader cl) throws ObjectStoreConfigException {
        assert (cl != null);
        this.cl = cl;
        this.mapper = new RoleMapper();
        new RoleClassLoader(this.mapper).loadRoles(cl);
        this.literals = new LiteralManager(cl);
    }

    public OWLCompiler(RoleMapper mapper, LiteralManager literals, ClassLoader cl) {
        assert (mapper != null && literals != null && cl != null);
        this.cl = cl;
        this.mapper = mapper;
        this.literals = literals;
    }

    public boolean isPluralForms() {
        return this.pluralForms;
    }

    public void setPluralForms(boolean enabled) {
        this.pluralForms = enabled;
    }

    public boolean isResolvingPrefix() {
        return this.resolvingPrefix;
    }

    public void setResolvingPrefix(boolean resolvingPrefix) {
        this.resolvingPrefix = resolvingPrefix;
    }

    public void setModel(Model model) {
        assert (model != null);
        this.model = model;
        this.normalizer = new OwlNormalizer(new RDFDataSource(model));
        this.normalizer.normalize();
    }

    public void setPackagePrefix(String prefix) {
        this.pkgPrefix = prefix == null ? "" : prefix;
    }

    public void setMemberPrefix(String prefix) {
        this.memPrefix = prefix;
    }

    public void setPrefixNamespaces(Map<URI, Map<String, String>> namespaces) {
        this.ns = namespaces.values();
    }

    public void setPrefixNamespaces(Collection<Map<String, String>> namespaces) {
        this.ns = namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.ns = Collections.singleton(namespaces);
    }

    public void setBaseClasses(String[] baseClasses) {
        assert (baseClasses != null);
        this.baseClasses = baseClasses;
    }

    public void setOntologies(Map<URL, RDFFormat> ontologies) {
        this.ontologies = ontologies;
    }

    public ClassLoader createJar(File jar) throws IOException, ObjectStoreConfigException {
        File target = this.createTempDir(this.getClass().getSimpleName());
        this.compile(target);
        JarPacker packer = new JarPacker(target);
        packer.packageJar(jar);
        FileUtil.deleteDir((File)target);
        return new URLClassLoader(new URL[]{jar.toURI().toURL()}, this.cl);
    }

    public List<String> compile(File dir) throws ObjectStoreConfigException, IOException {
        if (this.resolver == null) {
            this.resolver = this.buildJavaNameResolver(this.pkgPrefix, this.memPrefix, this.ns, this.model, this.normalizer, this.cl);
        }
        List<String> classes = this.buildJavaFiles(dir);
        this.saveConceptResources(dir);
        if (!classes.isEmpty()) {
            ClassPathBuilder cb = new ClassPathBuilder();
            cb.append(this.getClass().getClassLoader()).append(this.cl);
            List<File> classpath = cb.toFileList();
            this.compiler.compile(classes, dir, classpath);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> buildJavaFiles(File dir) throws ObjectStoreConfigException, IOException {
        String namespace;
        RDFEntity bean;
        if (this.resolver == null) {
            this.resolver = this.buildJavaNameResolver(this.pkgPrefix, this.memPrefix, this.ns, this.model, this.normalizer, this.cl);
        }
        if (this.baseClasses.length > 0) {
            Set classes = this.model.filter(null, RDF.TYPE, (Value)OWL.CLASS, new Resource[0]).subjects();
            for (Resource o : new ArrayList(classes)) {
                RDFClass bean2 = new RDFClass(this.model, o);
                if (bean2.getURI() == null || bean2.isDatatype() || this.mapper.isRecordedConcept(bean2.getURI(), this.cl)) continue;
                this.addBaseClass(bean2);
            }
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 3; ++i) {
            threads.add(new Thread(this.helper));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        HashSet<String> usedNamespaces = new HashSet<String>();
        ArrayList<String> content = new ArrayList<String>();
        for (Resource o : this.model.filter(null, RDF.TYPE, (Value)RDFS.DATATYPE, new Resource[0]).subjects()) {
            bean = new RDFClass(this.model, o);
            if (bean.getURI() == null || this.literals.isRecordedeType(bean.getURI())) continue;
            namespace = bean.getURI().getNamespace();
            usedNamespaces.add(namespace);
            new DatatypeBuilder(content, (RDFClass)bean, dir).run();
        }
        for (Resource o : this.model.filter(null, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY, new Resource[0]).subjects()) {
            bean = new RDFProperty(this.model, o);
            if (bean.getURI() == null || this.mapper.isRecordedAnnotation(bean.getURI())) continue;
            namespace = bean.getURI().getNamespace();
            usedNamespaces.add(namespace);
            this.queue.add(new AnnotationBuilder(dir, content, (RDFProperty)bean));
        }
        for (Resource o : this.model.filter(null, RDF.TYPE, (Value)OWL.CLASS, new Resource[0]).subjects()) {
            if (this.model.contains(o, RDFS.SUBCLASSOF, (Value)MSG.MESSAGE, new Resource[0]) || (bean = new RDFClass(this.model, o)).getURI() == null || ((RDFClass)bean).isDatatype() || this.mapper.isRecordedConcept(bean.getURI(), this.cl) && (JAVA_NS.equals(bean.getURI().getNamespace()) || this.isComplete((RDFClass)bean, this.mapper.findRoles(bean.getURI()), this.resolver))) continue;
            namespace = bean.getURI().getNamespace();
            usedNamespaces.add(namespace);
            this.queue.add(new ConceptBuilder(dir, content, (RDFClass)bean));
        }
        HashSet<String> methods = new HashSet<String>();
        int n = threads.size();
        for (int i = 0; i < n; ++i) {
            this.queue.add(this.helper);
        }
        for (String namespace2 : usedNamespaces) {
            if (JAVA_NS.equals(namespace2)) continue;
            RDFOntology ont = this.findOntology(namespace2);
            ont.generatePackageInfo(dir, namespace2, this.resolver);
            String pkg = this.resolver.getBoundPackageName(namespace2);
            if (pkg == null) continue;
            String className = pkg + ".package-info";
            ArrayList<String> arrayList = content;
            synchronized (arrayList) {
                this.logger.debug("Saving {}", (Object)className);
                content.add(className);
            }
        }
        for (Thread thread1 : threads) {
            try {
                thread1.join();
            }
            catch (InterruptedException cause) {
                InterruptedIOException e = new InterruptedIOException(cause.getMessage());
                e.initCause(cause);
                throw e;
            }
        }
        if (this.exception != null) {
            try {
                throw this.exception;
            }
            catch (ObjectStoreConfigException e) {
                throw new ObjectStoreConfigException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (IOException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        if (!methods.isEmpty()) {
            this.printClasses(methods, dir, META_INF_BEHAVIOURS);
            content.addAll(methods);
        }
        return content;
    }

    public void saveConceptResources(File dir) throws IOException {
        if (!this.annotations.isEmpty()) {
            this.printClasses(this.annotations, dir, META_INF_ANNOTATIONS);
        }
        if (!this.concepts.isEmpty()) {
            this.printClasses(this.concepts, dir, META_INF_CONCEPTS);
        }
        if (!this.datatypes.isEmpty()) {
            this.printDatatypes(this.datatypes, dir, META_INF_DATATYPES);
        }
        if (this.ontologies != null) {
            this.packOntologies(this.ontologies, dir, META_INF_ONTOLOGIES);
        }
    }

    private void addBaseClass(RDFClass klass) {
        if (klass.getRDFClasses(RDFS.SUBCLASSOF).isEmpty()) {
            for (String b : this.baseClasses) {
                URIImpl name = new URIImpl(JAVA_NS + b);
                this.model.add((Resource)klass.getURI(), RDFS.SUBCLASSOF, (Value)name, new Resource[0]);
            }
        }
    }

    private boolean isComplete(RDFClass bean, Collection<Class<?>> roles, JavaNameResolver resolver) {
        String iri;
        block0: for (RDFProperty prop : bean.getDeclaredProperties()) {
            if (prop.getURI() == null) continue;
            iri = prop.getURI().stringValue();
            for (Class<?> role : roles) {
                for (Method method : role.getMethods()) {
                    if (method.isAnnotationPresent(Iri.class) && iri.equals(method.getAnnotation(Iri.class).value())) continue block0;
                }
            }
            return false;
        }
        block3: for (RDFClass type : bean.getDeclaredMessages()) {
            if (type.getURI() == null || resolver.isAnonymous(type.getURI())) continue;
            iri = type.getURI().stringValue();
            for (Class<?> role : roles) {
                for (GenericDeclaration genericDeclaration : role.getMethods()) {
                    if (((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Iri.class) && iri.equals(((Method)genericDeclaration).getAnnotation(Iri.class).value())) continue block3;
                }
            }
            return false;
        }
        block6: for (RDFClass sups : bean.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (sups.getURI() == null) continue;
            iri = sups.getURI().stringValue();
            for (Class<?> role : roles) {
                for (GenericDeclaration genericDeclaration : role.getInterfaces()) {
                    if (((Class)genericDeclaration).isAnnotationPresent(Iri.class) && iri.equals(((Class)genericDeclaration).getAnnotation(Iri.class).value())) continue block6;
                }
                Class<?> parent = role.getSuperclass();
                if (parent == null || !parent.isAnnotationPresent(Iri.class) || !iri.equals(parent.getAnnotation(Iri.class).value())) continue;
                continue block6;
            }
            return false;
        }
        return true;
    }

    private File createTempDir(String name) throws IOException {
        File tmpDir;
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr != null && !(tmpDir = new File(tmpDirStr)).exists()) {
            tmpDir.mkdirs();
        }
        File tmp = File.createTempFile(name, "");
        tmp.delete();
        tmp.mkdir();
        return tmp;
    }

    private JavaNameResolver buildJavaNameResolver(String pkgPrefix, String memberPrefix, Collection<Map<String, String>> namespaces, Model model, OwlNormalizer normalizer, ClassLoader cl) {
        if (model == null) {
            throw new IllegalStateException("setModel not called");
        }
        HashMap<String, String> packages = new HashMap<String, String>();
        for (String ns : this.findUndefinedNamespaces(model, cl)) {
            String string = this.findPrefix(ns, model);
            packages.put(ns, pkgPrefix + string);
        }
        JavaNameResolver resolver = this.createJavaNameResolver(packages, memberPrefix, namespaces, cl);
        for (URI uRI : normalizer.getAnonymousClasses()) {
            resolver.assignAnonymous(uRI);
        }
        for (Map.Entry entry : normalizer.getAliases().entrySet()) {
            resolver.assignAlias((URI)entry.getKey(), (URI)entry.getValue());
        }
        resolver.setImplNames(normalizer.getImplNames());
        for (Resource resource : model.filter(null, RDF.TYPE, (Value)OWL.CLASS, new Resource[0]).subjects()) {
            RDFClass bean = new RDFClass(model, resource);
            URI uri = bean.getURI();
            if (uri == null || bean.isDatatype() || JAVA_NS.equals(uri.getNamespace()) || !this.mapper.isRecordedConcept(uri, cl) || this.isComplete(bean, this.mapper.findRoles(uri), resolver)) continue;
            resolver.ignoreExistingClass(uri);
            String ns = uri.getNamespace();
            if (packages.containsKey(ns)) continue;
            String prefix = this.findPrefix(ns, model);
            packages.put(ns, pkgPrefix + prefix);
        }
        for (Map.Entry entry : packages.entrySet()) {
            resolver.bindPackageToNamespace((String)entry.getValue(), (String)entry.getKey());
        }
        return resolver;
    }

    private JavaNameResolver createJavaNameResolver(Map<String, String> packages, String memberPrefix, Collection<Map<String, String>> namespaces, ClassLoader cl) {
        JavaNameResolver resolver = new JavaNameResolver(cl);
        resolver.setPluralForms(this.pluralForms);
        resolver.setModel(this.model);
        for (Map.Entry<String, String> entry : packages.entrySet()) {
            resolver.bindPackageToNamespace(entry.getValue(), entry.getKey());
        }
        for (Namespace namespace : this.model.getNamespaces()) {
            resolver.bindPrefixToNamespace(namespace.getPrefix(), namespace.getName());
        }
        if (memberPrefix == null) {
            for (Map map : namespaces) {
                for (Map.Entry e : map.entrySet()) {
                    resolver.bindPrefixToNamespace((String)e.getKey(), (String)e.getValue());
                }
            }
        } else {
            for (Map.Entry entry : packages.entrySet()) {
                resolver.bindPrefixToNamespace(memberPrefix, (String)entry.getKey());
            }
        }
        resolver.setRoleMapper(this.mapper);
        resolver.setLiteralManager(this.literals);
        return resolver;
    }

    private RDFOntology findOntology(String namespace) {
        if (namespace.endsWith("#")) {
            return new RDFOntology(this.model, (Resource)new URIImpl(namespace.substring(0, namespace.length() - 1)));
        }
        return new RDFOntology(this.model, (Resource)new URIImpl(namespace));
    }

    private String findPrefix(String ns, Model model) {
        String prefix;
        for (Namespace e : model.getNamespaces()) {
            if (!ns.equals(e.getName()) || e.getPrefix().length() <= 0) continue;
            return e.getPrefix();
        }
        if (this.resolvingPrefix && (prefix = NamespacePrefixService.getInstance().prefix(ns)) != null && model.getNamespace(prefix) == null) {
            model.setNamespace(prefix, ns);
            return prefix;
        }
        return "ns" + Integer.toHexString(ns.hashCode());
    }

    private Set<String> findUndefinedNamespaces(Model model, ClassLoader cl) {
        HashSet<String> unknown = new HashSet<String>();
        for (Resource subj : model.filter(null, RDF.TYPE, null, new Resource[0]).subjects()) {
            if (!(subj instanceof URI)) continue;
            URI uri = (URI)subj;
            String ns = uri.getNamespace();
            if (this.mapper.isRecordedConcept(uri, cl) || this.literals.isRecordedeType(uri) || this.mapper.isRecordedAnnotation(uri)) continue;
            unknown.add(ns);
        }
        return unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printClasses(Collection<String> roles, File dir, String entry) throws IOException {
        File f = new File(dir, entry);
        f.getParentFile().mkdirs();
        PrintStream out = new PrintStream(new FileOutputStream(f));
        try {
            for (String name : roles) {
                out.println(name);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDatatypes(Map<String, List<URI>> datatypes, File dir, String META_INF_DATATYPES) throws FileNotFoundException {
        File f = new File(dir, META_INF_DATATYPES);
        f.getParentFile().mkdirs();
        PrintStream out = new PrintStream(new FileOutputStream(f));
        try {
            for (Map.Entry<String, List<URI>> entry : datatypes.entrySet()) {
                StringBuilder sb = new StringBuilder(entry.getKey());
                if (entry.getValue() != null) {
                    StringBuilder temp = new StringBuilder();
                    for (URI uri : entry.getValue()) {
                        if (temp.length() > 0) {
                            temp.append(' ');
                        }
                        temp.append(uri.stringValue());
                    }
                    if (temp.length() > 0) {
                        sb.append('=').append((CharSequence)temp);
                    }
                }
                out.println(sb);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void packOntologies(Map<URL, RDFFormat> rdfSources, File dir, String META_INF_ONTOLOGIES) throws IOException {
        File list = new File(dir, META_INF_ONTOLOGIES);
        list.getParentFile().mkdirs();
        PrintStream inf = new PrintStream(new FileOutputStream(list));
        try {
            for (URL rdf : rdfSources.keySet()) {
                try {
                    RDFFormat format = rdfSources.get(rdf);
                    String path = "META-INF/ontologies/";
                    URLConnection conn = rdf.openConnection();
                    if (format != null) {
                        for (String type : format.getMIMETypes()) {
                            conn.addRequestProperty("Accept", type);
                        }
                    }
                    InputStream in = conn.getInputStream();
                    try {
                        String name = this.getLocalName(rdf.toExternalForm());
                        if (format != null && !format.equals((Object)RDFFormat.forFileName((String)name))) {
                            name = name + "." + format.getDefaultFileExtension();
                        }
                        File file = new File(dir, path + name);
                        file.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(file);
                        try {
                            int read;
                            byte[] buf = new byte[1024];
                            while ((read = in.read(buf)) >= 0) {
                                ((OutputStream)out).write(buf, 0, read);
                            }
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                        inf.println(path + name);
                    }
                    finally {
                        in.close();
                    }
                }
                catch (ConnectException exc) {
                    throw new IOException("Cannot connect to " + rdf, exc);
                    return;
                }
            }
        }
        finally {
            inf.close();
        }
    }

    private String getLocalName(String uri) {
        int idx;
        int start = uri.indexOf(35);
        int end = uri.length();
        if (start >= 0 && start < end - 1) {
            return uri.substring(start + 1, end);
        }
        if (start >= 0 && start < end) {
            end = start;
        }
        if ((idx = uri.lastIndexOf(63)) >= 0) {
            end = idx;
        }
        if ((start = uri.lastIndexOf(47)) >= 0 && start < end - 1) {
            return uri.substring(start + 1, end);
        }
        if (start >= 0 && start < end) {
            end = start;
        }
        if ((start = uri.lastIndexOf(58)) >= 0 && start < end - 1) {
            return uri.substring(start + 1, end);
        }
        if (start >= 0 && start < end) {
            end = start;
        }
        return uri;
    }

    private final class DatatypeBuilder
    implements Runnable {
        private final RDFClass bean;
        private final List<String> content;
        private final File target;

        DatatypeBuilder(List<String> content, RDFClass bean, File target) {
            this.content = content;
            this.bean = bean;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    for (RDFClass equivalentRdfClass : this.bean.getRDFClasses(OWL.EQUIVALENTCLASS)) {
                        Class<?> equivalentJavaClass = OWLCompiler.this.literals.findClass(equivalentRdfClass.getURI());
                        if (equivalentJavaClass == null) continue;
                        String equivalentJavaClassname = equivalentJavaClass.getName();
                        List<URI> uris = OWLCompiler.this.datatypes.get(equivalentJavaClassname);
                        if (uris == null) {
                            uris = new ArrayList<URI>();
                            uris.add(equivalentRdfClass.getURI());
                            OWLCompiler.this.datatypes.put(equivalentJavaClassname, uris);
                        }
                        uris.add(this.bean.getURI());
                        OWLCompiler.this.literals.addDatatype(equivalentJavaClass, this.bean.getURI());
                        return;
                    }
                    this.bean.generateSourceCode(this.target, OWLCompiler.this.resolver);
                    String pkg = OWLCompiler.this.resolver.getPackageName(this.bean.getURI());
                    String className = OWLCompiler.this.resolver.getSimpleName(this.bean.getURI());
                    if (pkg != null) {
                        className = pkg + '.' + className;
                    }
                    List<String> list = this.content;
                    synchronized (list) {
                        OWLCompiler.this.logger.debug("Saving {}", (Object)className);
                        this.content.add(className);
                        OWLCompiler.this.datatypes.put(className, null);
                    }
                }
                catch (Exception exc) {
                    OWLCompiler.this.logger.error("Error processing {}", (Object)this.bean);
                    if (OWLCompiler.this.exception != null) break block8;
                    OWLCompiler.this.exception = exc;
                }
            }
        }
    }

    private class ConceptBuilder
    implements Runnable {
        private final RDFClass bean;
        private final List<String> content;
        private final File target;

        ConceptBuilder(File target, List<String> content, RDFClass bean) {
            this.target = target;
            this.content = content;
            this.bean = bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    this.bean.generateSourceCode(this.target, OWLCompiler.this.resolver);
                    URI uri = this.bean.getURI();
                    String pkg = OWLCompiler.this.resolver.getPackageName(uri);
                    String className = OWLCompiler.this.resolver.getSimpleName(uri);
                    if (pkg != null) {
                        className = pkg + '.' + className;
                    }
                    boolean anon = OWLCompiler.this.resolver.isAnonymous(uri) && this.bean.isEmpty(OWLCompiler.this.resolver);
                    List<String> list = this.content;
                    synchronized (list) {
                        OWLCompiler.this.logger.debug("Saving {}", (Object)className);
                        this.content.add(className);
                        if (!anon) {
                            OWLCompiler.this.concepts.add(className);
                        }
                    }
                }
                catch (Exception exc) {
                    OWLCompiler.this.logger.error("Error processing {}", (Object)this.bean);
                    if (OWLCompiler.this.exception != null) break block7;
                    OWLCompiler.this.exception = exc;
                }
            }
        }
    }

    private class AnnotationBuilder
    implements Runnable {
        private final RDFProperty bean;
        private final List<String> content;
        private final File target;

        AnnotationBuilder(File target, List<String> content, RDFProperty bean) {
            this.target = target;
            this.content = content;
            this.bean = bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    this.bean.generateAnnotationCode(this.target, OWLCompiler.this.resolver);
                    URI uri = this.bean.getURI();
                    String pkg = OWLCompiler.this.resolver.getPackageName(uri);
                    String className = OWLCompiler.this.resolver.getSimpleName(uri);
                    if (pkg != null) {
                        className = pkg + '.' + className;
                    }
                    List<String> list = this.content;
                    synchronized (list) {
                        OWLCompiler.this.logger.debug("Saving {}", (Object)className);
                        this.content.add(className);
                        OWLCompiler.this.annotations.add(className);
                    }
                }
                catch (Exception exc) {
                    OWLCompiler.this.logger.error("Error processing {}", (Object)this.bean);
                    if (OWLCompiler.this.exception != null) break block6;
                    OWLCompiler.this.exception = exc;
                }
            }
        }
    }
}

