/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private Logger logger = LoggerFactory.getLogger(OntologyLoader.class);
    Model model;
    Map<org.openrdf.model.URI, Map<String, String>> namespaces = new HashMap<org.openrdf.model.URI, Map<String, String>>();
    private Map<URL, RDFFormat> imported = new LinkedHashMap<URL, RDFFormat>();
    private ValueFactory vf = ValueFactoryImpl.getInstance();

    public OntologyLoader() {
        this((Model)new LinkedHashModel());
    }

    public OntologyLoader(Model model) {
        this.model = model;
    }

    public Collection<URL> getImported() {
        return this.imported.keySet();
    }

    public Map<URL, RDFFormat> getImportedFormats() {
        return this.imported;
    }

    public Model getModel() {
        return this.model;
    }

    public Map<org.openrdf.model.URI, Map<String, String>> getNamespaces() {
        return this.namespaces;
    }

    public void loadOntologies(Iterable<URL> urls) throws RDFParseException, IOException {
        for (URL url : urls) {
            this.loadOntology(url);
        }
    }

    public void loadOntology(URL url) throws RDFParseException, IOException {
        org.openrdf.model.URI graph = this.vf.createURI(url.toExternalForm());
        RDFFormat format = this.loadOntology(url, null, graph);
        this.imported.put(url, format);
    }

    public void followImports() throws RDFParseException, IOException {
        Object uri;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Value obj : this.model.filter(null, OWL.IMPORTS, null, new Resource[0]).objects()) {
            URL url;
            if (!(obj instanceof org.openrdf.model.URI) || this.model.contains(null, null, null, new Resource[]{uri = (org.openrdf.model.URI)obj}) || this.model.contains((Resource)uri, RDF.TYPE, (Value)OWL.ONTOLOGY, new Resource[0]) || this.imported.containsKey(url = new URL(uri.stringValue()))) continue;
            urls.add(url);
        }
        if (!urls.isEmpty()) {
            for (URL url : urls) {
                uri = url.toExternalForm();
                RDFFormat format = this.loadOntology(url, null, this.vf.createURI((String)uri));
                this.imported.put(url, format);
            }
            this.followImports();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RDFFormat loadOntology(URL url, RDFFormat override, final org.openrdf.model.URI uri) throws IOException, RDFParseException {
        try {
            URLConnection conn = url.openConnection();
            if (override == null) {
                conn.setRequestProperty("Accept", this.getAcceptHeader());
            } else {
                conn.setRequestProperty("Accept", override.getDefaultMIMEType());
            }
            RDFFormat format = override;
            if (format == null) {
                String path = conn.getURL().toExternalForm();
                String contentType = conn.getContentType();
                format = this.forFileName(path, RDFFormat.RDFXML);
                String scheme = URI.create(conn.getURL().toExternalForm()).getScheme();
                if (contentType != null && !"file".equals(scheme)) {
                    format = this.forMIMEType(contentType, format);
                }
            }
            RDFParserRegistry registry = RDFParserRegistry.getInstance();
            RDFParser parser = ((RDFParserFactory)registry.get((Object)format)).getParser();
            parser.setRDFHandler((RDFHandler)new StatementCollector((Collection)this.model){

                public void handleStatement(Statement st) {
                    Resource s = st.getSubject();
                    org.openrdf.model.URI p = st.getPredicate();
                    Value o = st.getObject();
                    super.handleStatement((Statement)new ContextStatementImpl(s, p, o, (Resource)uri));
                }

                public void handleNamespace(String prefix, String ns) throws RDFHandlerException {
                    Map<String, String> map = OntologyLoader.this.namespaces.get(uri);
                    if (map == null) {
                        map = new HashMap<String, String>();
                        OntologyLoader.this.namespaces.put(uri, map);
                    }
                    map.put(prefix, ns);
                    if (OntologyLoader.this.model.getNamespace(prefix) == null) {
                        OntologyLoader.this.model.setNamespace(prefix, ns);
                    }
                }
            });
            InputStream in = conn.getInputStream();
            try {
                parser.parse(in, url.toExternalForm());
                RDFFormat rDFFormat = format;
                return rDFFormat;
            }
            catch (RDFHandlerException e) {
                throw new AssertionError((Object)e);
            }
            catch (RDFParseException e) {
                if (override != null) throw e;
                if (!format.equals((Object)RDFFormat.NTRIPLES)) throw e;
                RDFFormat rDFFormat = this.loadOntology(url, RDFFormat.RDFXML, uri);
                return rDFFormat;
            }
            finally {
                in.close();
            }
        }
        catch (RDFParseException e) {
            this.logger.warn("Could not load {} {}", (Object)url, (Object)e.getMessage());
            String msg = e.getMessage() + " in " + url;
            throw new RDFParseException(msg, e.getLineNumber(), e.getColumnNumber());
        }
        catch (IOException e) {
            this.logger.warn("Could not load {} {}", (Object)url, (Object)e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            this.logger.warn("Could not load {} {}", (Object)url, (Object)e.getMessage());
            return null;
        }
    }

    private RDFFormat forFileName(String path, RDFFormat fallback) {
        RDFFormat format = RDFFormat.forFileName((String)path);
        RDFParserRegistry registry = RDFParserRegistry.getInstance();
        if (format != null && registry.has((Object)format)) {
            return format;
        }
        return fallback;
    }

    private RDFFormat forMIMEType(String contentType, RDFFormat fallback) {
        RDFFormat format = RDFFormat.forMIMEType((String)contentType);
        RDFParserRegistry registry = RDFParserRegistry.getInstance();
        if (format != null && registry.has((Object)format)) {
            return format;
        }
        return fallback;
    }

    private String getAcceptHeader() {
        StringBuilder sb = new StringBuilder();
        String preferred = RDFFormat.RDFXML.getDefaultMIMEType();
        sb.append(preferred).append(";q=0.2");
        Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
        for (RDFFormat format : rdfFormats) {
            for (String type : format.getMIMETypes()) {
                if (preferred.equals(type)) continue;
                sb.append(", ").append(type);
            }
        }
        return sb.toString();
    }
}

