/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import info.aduna.net.ParsedURI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.compiler.RDFDataSource;
import org.openrdf.repository.object.compiler.RDFList;
import org.openrdf.repository.object.vocabulary.MSG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwlNormalizer {
    private final Logger logger = LoggerFactory.getLogger(OwlNormalizer.class);
    private RDFDataSource ds;
    private Set<URI> anonymousClasses = new HashSet<URI>();
    private Map<URI, URI> aliases = new HashMap<URI, URI>();
    private Map<String, String> implNames = new HashMap<String, String>();
    private Set<String> commonNS = new HashSet<String>(Arrays.asList("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/2000/01/rdf-schema#", "http://www.w3.org/2002/07/owl#"));

    public OwlNormalizer(RDFDataSource ds) {
        this.ds = ds;
    }

    public URI getOriginal(URI alias) {
        if (this.anonymousClasses.contains(alias)) {
            return null;
        }
        if (this.aliases.containsKey(alias)) {
            return this.aliases.get(alias);
        }
        return alias;
    }

    public Map<URI, URI> getAliases() {
        return this.aliases;
    }

    public Set<URI> getAnonymousClasses() {
        return this.anonymousClasses;
    }

    public Map<String, String> getImplNames() {
        return this.implNames;
    }

    public void normalize() {
        this.infer();
        this.createJavaAnnotations();
        this.checkPropertyDomains();
        this.checkPropertyRanges();
        this.subClassIntersectionOf();
        this.hasValueFromList();
        this.subClassOneOf();
        this.distributeEquivalentClasses();
        this.renameAnonymousClasses();
        this.mergeUnionClasses();
        this.distributeSubMessage();
        this.checkMessageTargets();
    }

    private void createJavaAnnotations() {
        if (this.ds.contains((Value)RDFS.LITERAL, null, null)) {
            this.ds.add((Resource)RDFS.LITERAL, RDF.TYPE, (Value)RDFS.DATATYPE);
        }
        if (this.ds.contains(null, RDFS.SUBCLASSOF, null)) {
            this.ds.add((Resource)RDFS.SUBCLASSOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, RDFS.SUBPROPERTYOF, null)) {
            this.ds.add((Resource)RDFS.SUBPROPERTYOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, OWL.EQUIVALENTCLASS, null)) {
            this.ds.add((Resource)OWL.EQUIVALENTCLASS, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, OWL.COMPLEMENTOF, null)) {
            this.ds.add((Resource)OWL.COMPLEMENTOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.COMPLEMENTOF, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.COMPLEMENTOF, RDFS.RANGE, (Value)OWL.CLASS);
        }
        if (this.ds.contains(null, OWL.INTERSECTIONOF, null)) {
            this.ds.add((Resource)OWL.INTERSECTIONOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, OWL.UNIONOF, null)) {
            this.ds.add((Resource)OWL.UNIONOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, OWL.HASVALUE, null)) {
            this.ds.add((Resource)OWL.HASVALUE, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.HASVALUE, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.ONEOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        } else if (this.ds.contains(null, OWL.ONEOF, null)) {
            this.ds.add((Resource)OWL.ONEOF, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
        }
        if (this.ds.contains(null, OWL.SOMEVALUESFROM, null)) {
            this.ds.add((Resource)OWL.SOMEVALUESFROM, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.SOMEVALUESFROM, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.SOMEVALUESFROM, RDFS.RANGE, (Value)OWL.CLASS);
        }
        if (this.ds.contains(null, OWL.MAXCARDINALITY, null)) {
            this.ds.add((Resource)OWL.MAXCARDINALITY, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.MAXCARDINALITY, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.MAXCARDINALITY, RDFS.RANGE, (Value)XMLSchema.NON_NEGATIVE_INTEGER);
        }
        if (this.ds.contains(null, OWL.MINCARDINALITY, null)) {
            this.ds.add((Resource)OWL.MINCARDINALITY, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.MINCARDINALITY, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.MINCARDINALITY, RDFS.RANGE, (Value)XMLSchema.NON_NEGATIVE_INTEGER);
        }
        if (this.ds.contains(null, OWL.CARDINALITY, null)) {
            this.ds.add((Resource)OWL.CARDINALITY, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            this.ds.add((Resource)OWL.CARDINALITY, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY);
            this.ds.add((Resource)OWL.CARDINALITY, RDFS.RANGE, (Value)XMLSchema.NON_NEGATIVE_INTEGER);
        }
    }

    private void infer() {
        this.logger.debug("inferring");
        ValueFactory vf = this.getValueFactory();
        this.propagateSubClassType((Resource)RDFS.CLASS);
        this.symmetric(OWL.INVERSEOF);
        this.symmetric(OWL.EQUIVALENTCLASS);
        this.symmetric(OWL.EQUIVALENTPROPERTY);
        this.symmetric(OWL.DISJOINTWITH);
        this.setSubjectType(RDF.FIRST, null, RDF.LIST);
        this.setSubjectType(RDF.REST, null, RDF.LIST);
        this.setSubjectType(RDFS.SUBCLASSOF, null, OWL.CLASS);
        this.setSubjectType(OWL.ONEOF, null, OWL.CLASS);
        this.setSubjectType(OWL.UNIONOF, null, OWL.CLASS);
        this.setSubjectType(OWL.DISJOINTWITH, null, OWL.CLASS);
        this.setSubjectType(OWL.COMPLEMENTOF, null, OWL.CLASS);
        this.setSubjectType(OWL.EQUIVALENTCLASS, null, OWL.CLASS);
        this.setSubjectType(OWL.INTERSECTIONOF, null, OWL.CLASS);
        this.setSubjectType(OWL.ONPROPERTY, null, OWL.RESTRICTION);
        this.setSubjectType(RDF.TYPE, (Value)RDFS.CLASS, OWL.CLASS);
        this.setSubjectType(RDF.TYPE, (Value)OWL.DEPRECATEDCLASS, OWL.CLASS);
        this.setSubjectType(RDF.TYPE, (Value)OWL.RESTRICTION, OWL.CLASS);
        this.setSubjectType(RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY, RDF.PROPERTY);
        this.setSubjectType(RDF.TYPE, (Value)OWL.DEPRECATEDPROPERTY, RDF.PROPERTY);
        this.setSubjectType(RDF.TYPE, (Value)OWL.OBJECTPROPERTY, RDF.PROPERTY);
        this.setSubjectType(RDF.TYPE, (Value)OWL.DATATYPEPROPERTY, RDF.PROPERTY);
        this.setSubjectType(RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY, RDF.PROPERTY);
        this.setObjectType(RDFS.SUBCLASSOF, OWL.CLASS);
        this.setObjectType(OWL.ALLVALUESFROM, OWL.CLASS);
        this.setObjectType(OWL.ONEOF, RDF.LIST);
        this.setObjectType(OWL.UNIONOF, RDF.LIST);
        this.setObjectType(OWL.INTERSECTIONOF, RDF.LIST);
        this.setObjectType(RDFS.ISDEFINEDBY, OWL.ONTOLOGY);
        this.setSubjectType(OWL.INVERSEOF, null, OWL.OBJECTPROPERTY);
        this.setObjectType(OWL.INVERSEOF, OWL.OBJECTPROPERTY);
        this.setObjectType(RDFS.RANGE, OWL.CLASS);
        this.setObjectType(RDFS.DOMAIN, OWL.CLASS);
        this.setSubjectType(RDFS.RANGE, null, RDF.PROPERTY);
        this.setSubjectType(RDFS.DOMAIN, null, RDF.PROPERTY);
        this.setSubjectType(RDFS.SUBPROPERTYOF, null, RDF.PROPERTY);
        this.setObjectType(RDFS.SUBPROPERTYOF, RDF.PROPERTY);
        this.setDatatype(vf, OWL.CARDINALITY, XMLSchema.NON_NEGATIVE_INTEGER);
        this.setDatatype(vf, OWL.MINCARDINALITY, XMLSchema.NON_NEGATIVE_INTEGER);
        this.setDatatype(vf, OWL.MAXCARDINALITY, XMLSchema.NON_NEGATIVE_INTEGER);
        this.setMemberType(OWL.UNIONOF, OWL.CLASS);
        this.setMemberType(OWL.INTERSECTIONOF, OWL.CLASS);
    }

    private void setMemberType(URI pred, URI type) {
        for (Value list : this.ds.match(null, pred, null).objects()) {
            if (!(list instanceof Resource)) continue;
            RDFList members = new RDFList(this.ds, (Value)((Resource)list));
            for (Value value : members.asList()) {
                if (!(value instanceof Resource)) continue;
                this.ds.add((Resource)value, RDF.TYPE, (Value)type);
            }
        }
    }

    private void propagateSubClassType(Resource classDef) {
        for (Resource c : this.findClasses(Collections.singleton(classDef))) {
            if (c.equals(RDFS.DATATYPE)) continue;
            for (Statement stmt : this.ds.match(null, RDF.TYPE, (Value)c)) {
                Resource subj = stmt.getSubject();
                this.ds.add(subj, RDF.TYPE, (Value)classDef);
            }
        }
    }

    private Set<Resource> findClasses(Collection<Resource> classes) {
        HashSet<Resource> set = new HashSet<Resource>(classes);
        for (Resource c : classes) {
            for (Statement stmt : this.ds.match(null, RDFS.SUBCLASSOF, (Value)c)) {
                Resource subj = stmt.getSubject();
                set.add(subj);
            }
        }
        if (set.size() > classes.size()) {
            return this.findClasses(set);
        }
        return set;
    }

    private void symmetric(URI pred) {
        for (Statement stmt : this.ds.match(null, pred, null)) {
            if (stmt.getObject() instanceof Resource) {
                Resource subj = (Resource)stmt.getObject();
                this.ds.add(subj, pred, (Value)stmt.getSubject());
                continue;
            }
            this.logger.warn("Invalid statement {}", (Object)stmt);
        }
    }

    private void setSubjectType(URI pred, Value obj, URI type) {
        for (Statement stmt : this.ds.match(null, pred, obj)) {
            this.ds.add(stmt.getSubject(), RDF.TYPE, (Value)type);
        }
    }

    private void setObjectType(URI pred, URI type) {
        for (Statement st : this.ds.match(null, pred, null)) {
            if (st.getObject() instanceof Resource) {
                Resource subj = (Resource)st.getObject();
                this.ds.add(subj, RDF.TYPE, (Value)type);
                continue;
            }
            this.logger.warn("Invalid statement {}", (Object)st);
        }
    }

    private void setDatatype(ValueFactory vf, URI pred, URI datatype) {
        for (Statement stmt : this.ds.match(null, pred, null)) {
            String label = ((Literal)stmt.getObject()).getLabel();
            Literal literal = vf.createLiteral(label, datatype);
            this.ds.remove((Value)stmt.getSubject(), pred, stmt.getObject());
            this.ds.add(stmt.getSubject(), pred, (Value)literal);
        }
    }

    private void checkPropertyDomains() {
        block0: for (Statement st : this.ds.match(null, RDF.TYPE, (Value)RDF.PROPERTY)) {
            Resource p = st.getSubject();
            if (this.ds.contains((Value)p, RDFS.DOMAIN, null)) continue;
            for (Value sup : this.ds.match((Value)p, RDFS.SUBPROPERTYOF, null).objects()) {
                Iterator iterator = this.ds.match(sup, RDFS.DOMAIN, null).objects().iterator();
                if (!iterator.hasNext()) continue;
                Value obj = (Value)iterator.next();
                this.ds.add(p, RDFS.DOMAIN, obj);
                continue block0;
            }
            this.ds.add(p, RDFS.DOMAIN, (Value)RDFS.RESOURCE);
            if (this.ds.contains((Value)RDFS.RESOURCE, RDF.TYPE, (Value)OWL.CLASS)) continue;
            this.ds.add((Resource)RDFS.RESOURCE, RDF.TYPE, (Value)OWL.CLASS);
        }
    }

    private void checkPropertyRanges() {
        block0: for (Statement st : this.ds.match(null, RDF.TYPE, (Value)RDF.PROPERTY)) {
            Resource p = st.getSubject();
            if (this.ds.contains((Value)p, RDFS.RANGE, null)) continue;
            for (Value sup : this.ds.match((Value)p, RDFS.SUBPROPERTYOF, null).objects()) {
                Iterator iterator = this.ds.match(sup, RDFS.RANGE, null).objects().iterator();
                if (!iterator.hasNext()) continue;
                Value obj = (Value)iterator.next();
                this.ds.add(p, RDFS.RANGE, obj);
                continue block0;
            }
            this.ds.add(p, RDFS.RANGE, (Value)RDFS.RESOURCE);
        }
    }

    private void distributeSubMessage() {
        boolean changed = false;
        for (Resource msg : this.ds.match(null, RDFS.SUBCLASSOF, (Value)MSG.MESSAGE).subjects()) {
            for (Resource sub : this.ds.match(null, RDFS.SUBCLASSOF, (Value)msg).subjects()) {
                if (this.ds.contains((Value)sub, RDFS.SUBCLASSOF, (Value)MSG.MESSAGE)) continue;
                this.ds.add(sub, RDFS.SUBCLASSOF, (Value)MSG.MESSAGE);
                changed = true;
            }
        }
        if (changed) {
            this.distributeSubMessage();
        }
    }

    private void checkMessageTargets() {
        for (Resource msg : this.ds.match(null, RDFS.SUBCLASSOF, (Value)MSG.MESSAGE).subjects()) {
            this.getOrAddTargetRestriction(msg);
        }
    }

    private Value getOrAddTargetRestriction(Resource msg) {
        Object res;
        for (Object res2 : this.ds.match((Value)msg, RDFS.SUBCLASSOF, null).objects()) {
            if (!this.ds.contains((Value)res2, OWL.ONPROPERTY, (Value)MSG.TARGET)) continue;
            return res2;
        }
        LinkedHashMap<Value, Value> restrictions = new LinkedHashMap<Value, Value>();
        for (Value sup : this.ds.match((Value)msg, RDFS.SUBCLASSOF, null).objects()) {
            if (!(sup instanceof URI) || (res = this.getOrAddTargetRestriction((Resource)((URI)sup))) == null) continue;
            restrictions.put(sup, (Value)res);
        }
        if (!restrictions.isEmpty()) {
            block2: for (Value sup1 : restrictions.keySet()) {
                for (Value sup2 : restrictions.keySet()) {
                    if (sup1 == sup2 || !this.ds.contains(sup2, RDFS.SUBCLASSOF, sup1)) continue;
                    continue block2;
                }
                res = (Value)restrictions.get(sup1);
                this.ds.add(msg, RDFS.SUBCLASSOF, (Value)res);
                return res;
            }
        }
        ValueFactory vf = this.getValueFactory();
        BNode res3 = vf.createBNode();
        this.ds.add(msg, RDFS.SUBCLASSOF, (Value)res3);
        this.ds.add((Resource)res3, RDF.TYPE, (Value)OWL.RESTRICTION);
        this.ds.add((Resource)res3, OWL.ONPROPERTY, (Value)MSG.TARGET);
        this.ds.add((Resource)res3, OWL.ALLVALUESFROM, (Value)RDFS.RESOURCE);
        this.ds.add((Resource)RDFS.RESOURCE, RDF.TYPE, (Value)OWL.CLASS);
        return res3;
    }

    private ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    private void hasValueFromList() {
        ValueFactory vf = this.getValueFactory();
        for (Statement st : this.ds.match(null, OWL.HASVALUE, null)) {
            Resource res = st.getSubject();
            Value obj = st.getObject();
            if (!(obj instanceof Resource)) continue;
            BNode node = vf.createBNode();
            this.ds.add(res, OWL.ALLVALUESFROM, (Value)node);
            this.ds.add((Resource)node, RDF.TYPE, (Value)OWL.CLASS);
            BNode list = vf.createBNode();
            this.ds.add((Resource)node, OWL.ONEOF, (Value)list);
            this.ds.add((Resource)list, RDF.TYPE, (Value)RDF.LIST);
            this.ds.add((Resource)list, RDF.FIRST, obj);
            this.ds.add((Resource)list, RDF.REST, (Value)RDF.NIL);
            for (Value type : this.ds.match(obj, RDF.TYPE, null).objects()) {
                this.ds.add((Resource)node, RDFS.SUBCLASSOF, type);
            }
            for (Value prop : this.ds.match((Value)res, OWL.ONPROPERTY, null).objects()) {
                for (Value range : this.ds.match(prop, RDFS.RANGE, null).objects()) {
                    this.ds.add((Resource)node, RDFS.SUBCLASSOF, range);
                }
                for (Resource cls : this.ds.match(null, RDFS.SUBCLASSOF, (Value)res).subjects()) {
                    for (Value sup : this.findSuperClasses(cls)) {
                        if (sup.equals(res) || this.ds.match(sup, OWL.ONPROPERTY, prop).isEmpty()) continue;
                        for (Value from : this.ds.match(sup, OWL.ALLVALUESFROM, null).objects()) {
                            this.ds.add((Resource)node, RDFS.SUBCLASSOF, from);
                        }
                    }
                }
            }
        }
    }

    private void subClassOneOf() {
        for (Statement st : this.ds.match(null, OWL.ONEOF, null)) {
            Set<Value> common = null;
            for (Value value : new RDFList(this.ds, st.getObject()).asList()) {
                Set types = this.ds.match(value, RDF.TYPE, null).objects();
                if (types.isEmpty()) {
                    common = Collections.emptySet();
                    continue;
                }
                HashSet<Value> supers = new HashSet<Value>();
                for (Value type : types) {
                    if (!(type instanceof Resource)) continue;
                    supers.addAll(this.findSuperClasses((Resource)type));
                }
                if (common == null) {
                    common = new HashSet<Value>(supers);
                    continue;
                }
                common.retainAll(supers);
            }
            if (common == null) continue;
            for (Value value : common) {
                this.ds.add(st.getSubject(), RDFS.SUBCLASSOF, value);
                if (!OWL.CLASS.equals((Object)value)) continue;
                this.ds.add((Resource)OWL.CLASS, RDF.TYPE, (Value)OWL.CLASS);
            }
        }
    }

    private void subClassIntersectionOf() {
        for (Statement st : this.ds.match(null, OWL.INTERSECTIONOF, null)) {
            if (!(st.getObject() instanceof Resource)) continue;
            RDFList list = new RDFList(this.ds, (Value)((Resource)st.getObject()));
            for (Value value : list.asList()) {
                this.ds.add(st.getSubject(), RDFS.SUBCLASSOF, value);
            }
        }
    }

    private void renameAnonymousClasses() {
        for (Resource res : this.ds.match(null, RDF.TYPE, (Value)OWL.CLASS).subjects()) {
            if (res instanceof URI) continue;
            this.nameAnonymous(res);
        }
    }

    private URI nameAnonymous(Resource clazz) {
        for (Value eq : this.ds.match((Value)clazz, OWL.EQUIVALENTCLASS, null).objects()) {
            if (!(eq instanceof URI)) continue;
            this.nameClass(clazz, (URI)eq);
            return (URI)eq;
        }
        Resource unionOf = this.ds.match((Value)clazz, OWL.UNIONOF, null).objectResource();
        if (unionOf != null) {
            return this.renameClass("", clazz, "Or", new RDFList(this.ds, (Value)unionOf).asList());
        }
        Resource intersectionOf = this.ds.match((Value)clazz, OWL.INTERSECTIONOF, null).objectResource();
        if (intersectionOf != null) {
            return this.renameClass("", clazz, "And", new RDFList(this.ds, (Value)intersectionOf).asList());
        }
        Resource oneOf = this.ds.match((Value)clazz, OWL.ONEOF, null).objectResource();
        if (oneOf != null) {
            return this.renameClass("Is", clazz, "Or", new RDFList(this.ds, (Value)oneOf).asList());
        }
        Resource complement = this.ds.match((Value)clazz, OWL.COMPLEMENTOF, null).objectResource();
        if (complement != null) {
            URI comp;
            URI uRI = comp = complement instanceof URI ? (URI)complement : null;
            if (comp == null && (comp = this.nameAnonymous(complement)) == null) {
                return null;
            }
            String name = "Not" + comp.getLocalName();
            URIImpl uri = new URIImpl(comp.getNamespace() + name);
            this.nameClass(clazz, (URI)uri);
            return uri;
        }
        if (this.ds.contains((Value)clazz, MSG.MATCHING, null)) {
            return this.renameClass("", clazz, "Or", this.ds.match((Value)clazz, MSG.MATCHING, null).objects());
        }
        return null;
    }

    private void distributeEquivalentClasses() {
        Resource subj;
        for (Statement st : this.ds.match(null, OWL.EQUIVALENTCLASS, null)) {
            subj = st.getSubject();
            Value equiv = st.getObject();
            for (Value v : this.ds.match(equiv, OWL.EQUIVALENTCLASS, null).objects()) {
                this.ds.add(subj, OWL.EQUIVALENTCLASS, v);
            }
            this.ds.remove((Value)subj, OWL.EQUIVALENTCLASS, (Value)subj);
        }
        for (Statement st : this.ds.match(null, OWL.EQUIVALENTCLASS, null)) {
            subj = st.getSubject();
            Value e = st.getObject();
            if (!(subj instanceof URI)) continue;
            for (Value d : this.ds.match(e, OWL.DISJOINTWITH, null).objects()) {
                this.ds.add(subj, OWL.DISJOINTWITH, d);
            }
            if (this.ds.contains(e, OWL.INTERSECTIONOF, null)) {
                Resource cinter = this.ds.match((Value)subj, OWL.INTERSECTIONOF, null).objectResource();
                Resource inter = this.ds.match(e, OWL.INTERSECTIONOF, null).objectResource();
                if (cinter == null) {
                    this.ds.add(subj, OWL.INTERSECTIONOF, (Value)inter);
                } else if (!inter.equals(cinter)) {
                    new RDFList(this.ds, (Value)cinter).addAllOthers(new RDFList(this.ds, (Value)inter));
                }
            }
            if (this.ds.contains(e, OWL.ONEOF, null)) {
                Resource co = this.ds.match((Value)subj, OWL.ONEOF, null).objectResource();
                Resource eo = this.ds.match(e, OWL.ONEOF, null).objectResource();
                if (co == null) {
                    this.ds.add(subj, OWL.ONEOF, (Value)this.ds.match(e, OWL.ONEOF, null).objectResource());
                } else if (!eo.equals(co)) {
                    new RDFList(this.ds, (Value)co).addAllOthers(new RDFList(this.ds, (Value)eo));
                }
            }
            if (this.ds.contains(e, OWL.UNIONOF, null)) {
                for (Value elist : this.ds.match(e, OWL.UNIONOF, null).objects()) {
                    if (!this.ds.contains((Value)subj, OWL.UNIONOF, null)) {
                        this.ds.add(subj, OWL.UNIONOF, elist);
                        continue;
                    }
                    if (this.ds.contains((Value)subj, OWL.UNIONOF, elist)) continue;
                    for (Value clist : this.ds.match((Value)subj, OWL.UNIONOF, null).objects()) {
                        new RDFList(this.ds, (Value)((Resource)clist)).addAllOthers(new RDFList(this.ds, (Value)((Resource)elist)));
                    }
                }
            }
            if (this.ds.contains(e, OWL.COMPLEMENTOF, null) && !this.ds.contains((Value)subj, OWL.COMPLEMENTOF, null)) {
                Resource comp = this.ds.match(e, OWL.COMPLEMENTOF, null).objectResource();
                this.ds.add(subj, OWL.COMPLEMENTOF, (Value)comp);
            }
            if (this.ds.contains(e, OWL.DISJOINTWITH, null)) {
                for (Value d : this.ds.match(e, OWL.DISJOINTWITH, null).objects()) {
                    this.ds.add(subj, OWL.DISJOINTWITH, d);
                }
            }
            if (this.ds.contains(e, RDFS.SUBCLASSOF, null)) {
                for (Value d : this.ds.match(e, RDFS.SUBCLASSOF, null).objects()) {
                    this.ds.add(subj, RDFS.SUBCLASSOF, d);
                }
            }
            if (!this.ds.contains(e, RDF.TYPE, (Value)OWL.RESTRICTION)) continue;
            this.ds.add(subj, RDFS.SUBCLASSOF, e);
        }
    }

    private void mergeUnionClasses() {
        for (Resource subj : this.ds.match(null, RDF.TYPE, (Value)OWL.CLASS).subjects()) {
            ArrayList<? extends Value> unionOf = new ArrayList<Value>();
            for (Value obj : this.ds.match((Value)subj, OWL.UNIONOF, null).objects()) {
                if (!(obj instanceof Resource)) continue;
                List<? extends Value> list = new RDFList(this.ds, (Value)((Resource)obj)).asList();
                list.removeAll(unionOf);
                unionOf.addAll(list);
            }
            if (unionOf.isEmpty()) continue;
            Set<URI> common = this.findCommonSupers(unionOf);
            if (common.contains(subj)) {
                this.ds.remove((Value)subj, OWL.UNIONOF, null);
                continue;
            }
            if (this.findCommon(common, unionOf) != null) {
                URI sup = this.findCommon(common, unionOf);
                this.ds.remove((Value)subj, OWL.UNIONOF, null);
                this.nameClass(subj, sup);
                continue;
            }
            for (URI uRI : common) {
                this.ds.add(subj, RDFS.SUBCLASSOF, (Value)uRI);
            }
            for (Value value : unionOf) {
                if (this.ds.contains(value, RDF.TYPE, (Value)RDFS.DATATYPE) && value instanceof URI) {
                    this.nameClass(subj, (URI)value);
                    continue;
                }
                this.ds.add((Resource)value, RDFS.SUBCLASSOF, (Value)subj);
            }
        }
    }

    private URI findCommon(Set<URI> common, Collection<? extends Value> unionOf) {
        URI result = null;
        for (Value value : unionOf) {
            if (!common.contains(value)) continue;
            result = (URI)value;
        }
        return result;
    }

    private Set<URI> findCommonSupers(List<? extends Value> unionOf) {
        HashSet<Value> common = null;
        for (Value value : unionOf) {
            if (!(value instanceof Resource)) continue;
            Set<Value> supers = this.findSuperClasses((Resource)value);
            if (common == null) {
                common = new HashSet<Value>(supers);
                continue;
            }
            common.retainAll(supers);
        }
        if (common == null) {
            return Collections.emptySet();
        }
        Iterator iter = common.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof URI) continue;
            iter.remove();
        }
        return common;
    }

    private Set<Value> findSuperClasses(Resource of) {
        HashSet<Value> set = new HashSet<Value>();
        set.add((Value)of);
        return this.findSuperClasses(of, set);
    }

    private Set<Value> findSuperClasses(Resource of, Set<Value> supers) {
        Set parent = this.ds.match((Value)of, RDFS.SUBCLASSOF, null).objects();
        if (supers.addAll(parent)) {
            for (Value s : parent) {
                if (!(s instanceof Resource)) continue;
                this.findSuperClasses((Resource)s, supers);
            }
        }
        return supers;
    }

    private URI renameClass(String prefix, Resource clazz, String and, Collection<? extends Value> list) {
        String namespace = null;
        TreeSet<String> names = new TreeSet<String>();
        TreeSet<String> others = new TreeSet<String>();
        for (Value value : list) {
            URI uri = null;
            if (value instanceof URI) {
                uri = (URI)value;
            } else if (value instanceof Literal) {
                String label = value.stringValue();
                StringBuilder sb = new StringBuilder();
                if (!label.contains(":")) {
                    sb.append(this.getMatchNamespace(clazz));
                }
                if (label.startsWith("*")) {
                    sb.append(label.replace("*", "Star"));
                } else if (label.endsWith("*")) {
                    sb.append(label, 0, label.length() - 1);
                } else {
                    sb.append(label);
                }
                if (label.startsWith("/")) {
                    sb.append("Path");
                }
                if (label.endsWith("*")) {
                    sb.append("Prefix");
                } else if (label.startsWith("*")) {
                    sb.append("Suffix");
                }
                uri = new URIImpl(sb.toString());
            } else if (this.ds.contains(value, RDF.TYPE, (Value)OWL.CLASS)) {
                uri = this.nameAnonymous((Resource)value);
            }
            if (uri != null && (namespace == null || this.commonNS.contains(namespace))) {
                namespace = uri.getNamespace();
            }
            if (uri == null) {
                others.add(value.stringValue());
                continue;
            }
            if (uri.getLocalName().length() > 0) {
                names.add(uri.getLocalName());
                continue;
            }
            String str = uri.stringValue();
            Matcher m = Pattern.compile("\\b[a-zA-Z]\\w*\\b").matcher(str);
            while (m.find()) {
                str = m.group();
            }
            names.add(str);
        }
        if (names.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (String localPart : names) {
            sb.append(this.initcap(localPart));
            sb.append(and);
        }
        for (String localPart : others) {
            sb.append(this.initcap(localPart));
            sb.append(and);
        }
        sb.setLength(sb.length() - and.length());
        URIImpl uRIImpl = new URIImpl(namespace + sb.toString());
        this.nameClass(clazz, (URI)uRIImpl);
        return uRIImpl;
    }

    private CharSequence getMatchNamespace(Resource clazz) {
        for (Resource graph : this.ds.match((Value)clazz, null, null).contexts()) {
            if (!(graph instanceof URI)) continue;
            return this.getMatchNamespace(graph);
        }
        return "urn:matches:";
    }

    private CharSequence getMatchNamespace(URI ontology) {
        StringBuilder sb = new StringBuilder();
        ParsedURI parsed = new ParsedURI(ontology.stringValue());
        if (parsed.getScheme() != null) {
            sb.append(parsed.getScheme());
            sb.append(':');
        }
        if (parsed.isOpaque()) {
            if (parsed.getSchemeSpecificPart() != null) {
                sb.append(parsed.getSchemeSpecificPart());
            }
        } else {
            if (parsed.getAuthority() != null) {
                sb.append("//");
                sb.append(parsed.getAuthority());
            }
            sb.append(parsed.getPath());
            sb.append("#");
        }
        return sb;
    }

    private void nameClass(Resource orig, URI dest) {
        if (this.ds.contains((Value)dest, RDF.TYPE, (Value)OWL.CLASS)) {
            this.logger.debug("merging {} {}", (Object)orig, (Object)dest);
        } else {
            this.logger.debug("renaming {} {}", (Object)orig, (Object)dest);
            this.ds.add((Resource)dest, RDF.TYPE, (Value)OWL.CLASS);
            this.anonymousClasses.add(dest);
        }
        this.rename(orig, (Resource)dest);
    }

    private void rename(Resource orig, Resource dest) {
        for (Statement stmt : this.ds.match((Value)orig, null, null)) {
            this.ds.add(dest, stmt.getPredicate(), stmt.getObject());
        }
        this.ds.remove((Value)orig, null, null);
        for (Statement stmt : this.ds.match(null, null, (Value)orig)) {
            this.ds.add(stmt.getSubject(), stmt.getPredicate(), (Value)dest);
        }
        this.ds.remove((Value)((Resource)null), null, (Value)orig);
    }

    private String initcap(String str) {
        if (str.length() < 2) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

