/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;

public class RDFDataSource {
    private Model model;

    public RDFDataSource(Model model) {
        this.model = model;
    }

    public boolean contains(Value subj, URI pred, Value obj) {
        if (subj == null || subj instanceof Resource) {
            return this.model.contains((Resource)subj, pred, obj, new Resource[0]);
        }
        return false;
    }

    public Model match(Value subj, URI pred, Value obj) {
        if (subj == null || subj instanceof Resource) {
            return new LinkedHashModel(this.model.filter((Resource)subj, pred, obj, new Resource[0]));
        }
        return new LinkedHashModel();
    }

    public Model match(Value subj, URI pred, Value obj, URI graph) {
        if (subj == null || subj instanceof Resource) {
            return new LinkedHashModel(this.model.filter((Resource)subj, pred, obj, new Resource[]{graph}));
        }
        return new LinkedHashModel();
    }

    public void add(Resource subj, URI pred, Value obj) {
        this.model.add(subj, pred, obj, new Resource[0]);
    }

    public boolean remove(Value subj, URI pred, Value obj) {
        if (subj == null || subj instanceof Resource) {
            return this.model.remove((Resource)subj, pred, obj, new Resource[0]);
        }
        return false;
    }
}

