/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.object.compiler.RDFDataSource;

public class RDFList {
    private ValueFactory vf = ValueFactoryImpl.getInstance();
    private RDFDataSource triples;
    private Value start;

    public RDFList(Model model, Value start) {
        this(new RDFDataSource(model), start);
    }

    public RDFList(RDFDataSource triples, Value start) {
        this.triples = triples;
        this.start = start;
    }

    public List<? extends Value> asList() {
        if (this.start == null) {
            return Collections.emptyList();
        }
        ArrayList<Value> list = new ArrayList<Value>();
        return this.copyTo(this.start, list);
    }

    public void addAllOthers(RDFList list) {
        List<? extends Value> l = list.asList();
        l.removeAll(this.asList());
        this.addAll(l);
    }

    private void addAll(List<? extends Value> list) {
        if (this.start == null) {
            this.start = this.vf.createBNode();
        }
        for (Value value : list) {
            this.addTo((Resource)this.start, value);
        }
    }

    private List<Value> copyTo(Value node, List<Value> list) {
        Value first = this.triples.match(node, RDF.FIRST, null).objectValue();
        Resource rest = this.triples.match(node, RDF.REST, null).objectResource();
        if (first == null) {
            return list;
        }
        list.add(first);
        return this.copyTo((Value)rest, list);
    }

    private void addTo(Resource node, Value element) {
        if (this.triples.contains((Value)node, RDF.FIRST, null)) {
            Resource rest = this.triples.match((Value)node, RDF.REST, null).objectResource();
            if (rest == null || rest.equals(RDF.NIL)) {
                rest = this.vf.createBNode();
                this.triples.remove((Value)node, RDF.REST, null);
                this.triples.add(node, RDF.REST, (Value)rest);
            }
            this.addTo(rest, element);
        } else {
            this.triples.add(node, RDF.FIRST, element);
            this.triples.add(node, RDF.REST, (Value)RDF.NIL);
        }
    }
}

