/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.model;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.RDFList;
import org.openrdf.repository.object.compiler.model.RDFEntity;
import org.openrdf.repository.object.compiler.model.RDFProperty;
import org.openrdf.repository.object.compiler.source.JavaMessageBuilder;
import org.openrdf.repository.object.compiler.source.JavaMethodBuilder;
import org.openrdf.repository.object.compiler.source.JavaPropertyBuilder;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;
import org.openrdf.repository.object.vocabulary.MSG;

public class RDFClass
extends RDFEntity {
    private static final URI NOTHING = new URIImpl("http://www.w3.org/2002/07/owl#Nothing");

    public RDFClass(Model model, Resource self) {
        super(model, self);
    }

    public boolean isDatatype() {
        URI uri;
        if (this.self instanceof URI && XMLDatatypeUtil.isBuiltInDatatype((URI)((URI)this.self))) {
            return true;
        }
        if (this.self.equals(RDFS.LITERAL)) {
            return true;
        }
        if (this.self instanceof URI && (uri = (URI)this.self).getNamespace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && uri.getLocalName().equals("PlainLiteral")) {
            return true;
        }
        return this.isA(RDFS.DATATYPE);
    }

    public RDFClass getRange(URI pred) {
        return this.getRange(new RDFProperty(this.model, (Resource)pred));
    }

    public RDFClass getRange(RDFProperty property) {
        return this.getRange(property, true);
    }

    public RDFClass getRange(RDFProperty property, boolean convariant) {
        RDFClass type = this.getRangeOrNull(property, convariant);
        if (type == null) {
            return new RDFClass(this.getModel(), (Resource)RDFS.RESOURCE);
        }
        return type;
    }

    private RDFClass getRangeOrNull(RDFProperty property, boolean convariant) {
        RDFClass type;
        if (convariant) {
            for (RDFClass c : this.getRDFClasses(RDFS.SUBCLASSOF)) {
                if (!c.isA(OWL.RESTRICTION) || !property.equals(c.getRDFProperty(OWL.ONPROPERTY)) || (type = c.getRDFClass(OWL.ALLVALUESFROM)) == null) continue;
                return type;
            }
        }
        for (RDFClass c : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (c.isA(OWL.RESTRICTION) || c.equals(this) || MSG.MESSAGE.equals((Object)c.getURI()) || (type = c.getRangeOrNull(property, convariant)) == null) continue;
            return type;
        }
        Iterator<RDFEntity> iterator = property.getRDFClasses(RDFS.RANGE).iterator();
        if (iterator.hasNext()) {
            RDFClass r = iterator.next();
            return r;
        }
        for (RDFProperty p : property.getRDFProperties(RDFS.SUBPROPERTYOF)) {
            RDFClass superRange = this.getRangeOrNull(p, convariant);
            if (superRange == null) continue;
            return superRange;
        }
        return null;
    }

    public boolean isFunctional(RDFProperty property) {
        return this.isFunctionalProperty(property);
    }

    public List<? extends Value> getList(URI pred) {
        List<? extends Value> list = null;
        for (Value obj : this.model.filter(this.self, pred, null, new Resource[0]).objects()) {
            if (list == null && obj instanceof Resource) {
                list = new RDFList(this.model, (Value)((Resource)obj)).asList();
                continue;
            }
            List<? extends Value> other = new RDFList(this.model, (Value)((Resource)obj)).asList();
            if (list.equals(other)) continue;
            other.removeAll(list);
            list.addAll(other);
        }
        return list;
    }

    public List<RDFProperty> getParameters() {
        TreeSet<String> set = new TreeSet<String>();
        this.addParameters(set, new HashSet<Value>());
        ArrayList<RDFProperty> list = new ArrayList<RDFProperty>();
        for (String uri : set) {
            list.add(new RDFProperty(this.model, (Resource)new URIImpl(uri)));
        }
        return list;
    }

    public RDFProperty getResponseProperty() {
        String valuesFrom;
        RDFProperty property;
        HashSet<RDFProperty> set = new HashSet<RDFProperty>();
        set.add(new RDFProperty(this.model, (Resource)MSG.OBJECT_SET));
        set.add(new RDFProperty(this.model, (Resource)MSG.LITERAL_SET));
        set.add(new RDFProperty(this.model, (Resource)MSG.OBJECT));
        set.add(new RDFProperty(this.model, (Resource)MSG.LITERAL));
        for (RDFClass c : this.getRestrictions()) {
            BigInteger max;
            BigInteger card;
            property = c.getRDFProperty(OWL.ONPROPERTY);
            valuesFrom = c.getString(OWL.ALLVALUESFROM);
            if (RDFS.RESOURCE.stringValue().equals(valuesFrom) || NOTHING.stringValue().equals(valuesFrom) || (card = c.getBigInteger(OWL.CARDINALITY)) != null && 0 == card.intValue() || (max = c.getBigInteger(OWL.MAXCARDINALITY)) != null && 0 == max.intValue() || !set.contains(property)) continue;
            return property;
        }
        for (RDFClass c : this.getRestrictions()) {
            property = c.getRDFProperty(OWL.ONPROPERTY);
            valuesFrom = c.getString(OWL.ALLVALUESFROM);
            if (RDFS.RESOURCE.stringValue().equals(valuesFrom) || !set.contains(property)) continue;
            return property;
        }
        for (RDFClass c : this.getRestrictions()) {
            property = c.getRDFProperty(OWL.ONPROPERTY);
            if (!set.contains(property)) continue;
            return property;
        }
        return new RDFProperty(this.model, (Resource)MSG.OBJECT_SET);
    }

    public boolean isMinCardinality(RDFProperty property) {
        BigInteger one = BigInteger.valueOf(1L);
        for (RDFClass c : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (!(c.isA(OWL.RESTRICTION) ? property.equals(c.getRDFProperty(OWL.ONPROPERTY)) && (one.equals(c.getBigInteger(OWL.MAXCARDINALITY)) && one.equals(c.getBigInteger(OWL.MINCARDINALITY)) || one.equals(c.getBigInteger(OWL.CARDINALITY))) : !this.equals(c) && c.isMinCardinality(property))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty(JavaNameResolver resolver) {
        URI uri;
        Collection<RDFProperty> properties = this.getDeclaredProperties();
        if (properties.size() > 1) {
            return false;
        }
        if (!properties.isEmpty() && !MSG.TARGET.equals((Object)(uri = properties.iterator().next().getURI()))) {
            return false;
        }
        if (!this.getDeclaredMessages().isEmpty()) {
            return false;
        }
        return false;
    }

    public File generateSourceCode(File dir, JavaNameResolver resolver) throws IOException, ObjectStoreConfigException {
        File source = this.createSourceFile(dir, resolver);
        if (this.isDatatype()) {
            JavaMessageBuilder builder = new JavaMessageBuilder(source, resolver);
            String pkg = resolver.getPackageName(this.getURI());
            String simple = resolver.getSimpleName(this.getURI());
            if (pkg == null) {
                builder.imports(simple);
            } else {
                builder.pkg(pkg);
                builder.imports(pkg + '.' + simple);
            }
            this.classHeader(simple, builder);
            this.stringConstructor(builder);
            builder.close();
        } else {
            JavaMessageBuilder builder = new JavaMessageBuilder(source, resolver);
            this.interfaceHeader(builder);
            this.constants(builder);
            for (RDFProperty prop : this.getDeclaredProperties()) {
                this.property(builder, prop);
            }
            for (RDFClass type : this.getDeclaredMessages()) {
                builder.message(type);
            }
            builder.close();
        }
        return source;
    }

    public List<RDFProperty> getFunctionalDatatypeProperties() {
        ArrayList<RDFProperty> list = new ArrayList<RDFProperty>();
        for (RDFProperty property : this.getProperties()) {
            if (!this.isFunctional(property) || !this.getRange(property).isDatatype()) continue;
            list.add(property);
        }
        return list;
    }

    public Collection<RDFClass> getDeclaredMessages() {
        TreeSet<RDFClass> set = new TreeSet<RDFClass>();
        for (Resource res : this.model.filter(null, OWL.ALLVALUESFROM, (Value)this.self, new Resource[0]).subjects()) {
            if (!this.model.contains(res, OWL.ONPROPERTY, (Value)MSG.TARGET, new Resource[0])) continue;
            for (Resource msg : this.model.filter(null, RDFS.SUBCLASSOF, (Value)res, new Resource[0]).subjects()) {
                RDFClass rc;
                if (MSG.MESSAGE.equals((Object)msg) || !(rc = new RDFClass(this.model, msg)).isMessageClass()) continue;
                set.add(rc);
            }
        }
        return set;
    }

    public Collection<RDFProperty> getDeclaredProperties() {
        TreeSet<String> set = new TreeSet<String>();
        for (Resource prop : this.model.filter(null, RDFS.DOMAIN, (Value)this.self, new Resource[0]).subjects()) {
            if (!(prop instanceof URI)) continue;
            set.add(prop.stringValue());
        }
        for (RDFClass res : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            RDFProperty prop;
            if (!res.isA(OWL.RESTRICTION) || this.isFunctional(prop = res.getRDFProperty(OWL.ONPROPERTY)) != this.isFunctionalProperty(prop)) continue;
            set.add(prop.getURI().stringValue());
        }
        ArrayList<RDFProperty> list = new ArrayList<RDFProperty>(set.size());
        for (String uri : set) {
            list.add(new RDFProperty(this.model, (Resource)new URIImpl(uri)));
        }
        return list;
    }

    public Collection<RDFClass> getRestrictions() {
        LinkedHashSet<RDFClass> restrictions = new LinkedHashSet<RDFClass>();
        for (RDFClass c : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (c.isA(OWL.RESTRICTION)) {
                restrictions.add(c);
                continue;
            }
            if (this.equals(c)) continue;
            restrictions.addAll(c.getRestrictions());
        }
        return restrictions;
    }

    public RDFProperty getRDFProperty(URI pred) {
        Resource subj = this.model.filter(this.self, pred, null, new Resource[0]).objectResource();
        if (subj == null) {
            return null;
        }
        return new RDFProperty(this.model, subj);
    }

    public boolean isMessageClass() {
        return this.isMessage(this, new HashSet<RDFEntity>());
    }

    protected boolean isFunctionalProperty(RDFProperty property) {
        if (property.isA(OWL.FUNCTIONALPROPERTY)) {
            return true;
        }
        URI uri = property.getURI();
        return uri.equals((Object)MSG.TARGET) || uri.equals((Object)MSG.LITERAL) || uri.equals((Object)MSG.OBJECT);
    }

    private void interfaceHeader(JavaMessageBuilder builder) throws ObjectStoreConfigException {
        String pkg = builder.getPackageName(this.getURI());
        String simple = builder.getSimpleName(this.getURI());
        if (pkg == null) {
            builder.imports(simple);
        } else {
            builder.pkg(pkg);
            builder.imports(pkg + '.' + simple);
        }
        builder.comment(this);
        if (this.isA(OWL.DEPRECATEDCLASS)) {
            builder.annotate(Deprecated.class);
        }
        builder.annotationProperties(this);
        if (!builder.isAnonymous(this.getURI())) {
            builder.annotateURI(Iri.class, "value", builder.getType(this.getURI()));
        }
        builder.interfaceName(simple);
        for (RDFClass sups : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (sups.getURI() == null || sups.equals(this)) continue;
            builder.extend(builder.getClassName(sups.getURI()));
        }
    }

    private void constants(JavaMessageBuilder builder) {
        List<? extends Value> oneOf = this.getList(OWL.ONEOF);
        if (oneOf != null) {
            Map<String, URI> names = new LinkedHashMap<String, URI>();
            for (Value value : oneOf) {
                String name;
                if (!(value instanceof URI)) continue;
                URI uri = (URI)value;
                String localPart = uri.getLocalName();
                if (localPart.length() < 1) {
                    localPart = uri.stringValue();
                }
                if (names.containsKey(name = localPart.replaceAll("^[^a-zA-Z]", "_").replaceAll("\\W+", "_"))) {
                    int count = 1;
                    while (names.containsKey(name + '_' + count)) {
                        ++count;
                    }
                    name = name + '_' + count;
                }
                names.put(name, uri);
            }
            if (!names.isEmpty()) {
                names = this.toUpperCase(names);
                for (Map.Entry entry : names.entrySet()) {
                    builder.staticURIField((String)entry.getKey(), (URI)entry.getValue());
                }
                if (!names.containsKey("ONEOF")) {
                    builder.staticURIArrayField("ONEOF", names.keySet());
                }
            }
        }
    }

    private Map<String, URI> toUpperCase(Map<String, URI> words) {
        LinkedHashMap<String, URI> insensitive = new LinkedHashMap<String, URI>();
        for (String local : words.keySet()) {
            String upper = local.toUpperCase();
            if (insensitive.containsKey(upper)) {
                return words;
            }
            insensitive.put(upper, words.get(local));
        }
        return insensitive;
    }

    private void stringConstructor(JavaMessageBuilder builder) throws ObjectStoreConfigException {
        JavaMethodBuilder code;
        String cn = builder.getClassName(this.getURI());
        String simple = builder.getSimpleName(this.getURI());
        JavaMethodBuilder method = builder.staticMethod("valueOf");
        method.returnType(cn);
        method.param(String.class.getName(), "value");
        method.code("return new ").code(simple).code("(value);").end();
        boolean child = false;
        for (RDFClass sups : this.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (sups.getURI() == null || sups.equals(this) || !sups.isDatatype()) continue;
            child = true;
        }
        if (child) {
            code = builder.constructor();
            code.param(String.class.getName(), "value");
            code.code("super(value);");
            code.end();
        } else {
            builder.field(String.class.getName(), "value");
            code = builder.constructor();
            code.param(String.class.getName(), "value");
            code.code("this.value = value;");
            code.end();
            code = builder.method("toString", false).returnType(String.class.getName());
            code.code("return value;").end();
            code = builder.method("hashCode", false).returnType("int");
            code.code("return value.hashCode();").end();
            code = builder.method("equals", false).returnType("boolean");
            code.param(Object.class.getName(), "o");
            String equals = "return getClass().equals(o.getClass()) && toString().equals(o.toString());";
            code.code(equals).end();
        }
    }

    private void property(JavaMessageBuilder builder, RDFProperty prop) throws ObjectStoreConfigException {
        JavaPropertyBuilder prop1 = builder.property(builder.getPropertyName(this, prop));
        builder.comment(prop1, prop);
        if (prop.isA(OWL.DEPRECATEDPROPERTY)) {
            prop1.annotate(Deprecated.class);
        }
        builder.annotationProperties(prop1, prop);
        for (RDFClass c : this.getRestrictions()) {
            RDFProperty property = c.getRDFProperty(OWL.ONPROPERTY);
            if (!prop.equals(property)) continue;
            builder.annotationProperties(prop1, c);
        }
        URI type = builder.getType(prop.getURI());
        prop1.annotateURI(Iri.class, "value", type);
        String className = builder.getPropertyClassName(this, prop);
        if (this.isFunctional(prop)) {
            prop1.type(className);
        } else {
            prop1.setOf(className);
        }
        prop1.getter();
        builder.comment(prop1, prop);
        if (prop.isA(OWL.DEPRECATEDPROPERTY)) {
            prop1.annotate(Deprecated.class);
        }
        builder.annotationProperties(prop1, prop);
        prop1.annotateURI(Iri.class, "value", type);
        prop1.openSetter();
        prop1.closeSetter();
        prop1.end();
    }

    private void addParameters(Set<String> parameters, Set<Value> skip) {
        for (Resource prop : this.model.filter(null, RDFS.DOMAIN, (Value)this.self, new Resource[0]).subjects()) {
            if (!this.isParameter(prop)) continue;
            parameters.add(prop.stringValue());
        }
        for (Value sup : this.model.filter(this.self, RDFS.SUBCLASSOF, null, new Resource[0]).objects()) {
            if (this.isRDFSOrOWL(sup) || !skip.add(sup)) continue;
            new RDFClass(this.model, (Resource)sup).addParameters(parameters, skip);
        }
    }

    private boolean isRDFSOrOWL(Value sup) {
        if (this.self instanceof URI && sup instanceof URI) {
            String ns = ((URI)this.self).getNamespace();
            return ns.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || ns.equals("http://www.w3.org/2000/01/rdf-schema#") || ns.equals("http://www.w3.org/2002/07/owl#");
        }
        return false;
    }

    private boolean isParameter(Resource prop) {
        return !this.model.contains(prop, RDF.TYPE, (Value)OWL.ANNOTATIONPROPERTY, new Resource[0]) && prop instanceof URI && !prop.stringValue().startsWith("http://www.openrdf.org/rdf/2011/messaging#");
    }

    private boolean isMessage(RDFEntity message, Set<RDFEntity> set) {
        if (MSG.MESSAGE.equals((Object)message.getURI())) {
            return true;
        }
        set.add(message);
        for (RDFClass sup : message.getRDFClasses(RDFS.SUBCLASSOF)) {
            if (set.contains(sup) || !this.isMessage(sup, set)) continue;
            return true;
        }
        return false;
    }

    private BigInteger getBigInteger(URI pred) {
        Value value = this.model.filter(this.self, pred, null, new Resource[0]).objectValue();
        if (value == null) {
            return null;
        }
        return new BigInteger(value.stringValue());
    }

    private Collection<RDFProperty> getProperties() {
        return this.getProperties(new HashSet<Resource>(), new ArrayList<RDFProperty>());
    }

    private Collection<RDFProperty> getProperties(Set<Resource> exclude, Collection<RDFProperty> list) {
        if (exclude.add(this.getResource())) {
            list.addAll(this.getDeclaredProperties());
            for (RDFClass sup : this.getRDFClasses(RDFS.SUBCLASSOF)) {
                list = sup.getProperties(exclude, list);
            }
        }
        return list;
    }

    private void classHeader(String simple, JavaMessageBuilder builder) throws ObjectStoreConfigException {
        builder.comment(this);
        if (this.isDatatype()) {
            builder.annotationProperties(this);
            URI type = builder.getType(this.getURI());
            builder.annotateURI(Iri.class, "value", type);
            builder.className(simple);
        } else {
            builder.annotationProperties(this);
            builder.abstractName(simple);
        }
        if (this.isDatatype()) {
            ArrayList<URI> supers = new ArrayList<URI>();
            for (RDFClass sups : this.getRDFClasses(RDFS.SUBCLASSOF)) {
                if (sups.getURI() == null || sups.equals(this) || !sups.isDatatype()) continue;
                supers.add(sups.getURI());
            }
            if (supers.size() == 1) {
                builder.extend(builder.getClassName((URI)supers.get(0)));
            }
        }
        if (!this.isDatatype()) {
            URI range = this.getRange(MSG.TARGET).getURI();
            if (range != null) {
                builder.implement(builder.getClassName(range));
            }
            builder.implement("org.openrdf.repository.object.RDFObject");
            builder.implement(RDFObjectBehaviour.class.getName());
        }
    }
}

