/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.RDFList;
import org.openrdf.repository.object.compiler.model.RDFClass;
import org.openrdf.repository.object.compiler.model.RDFProperty;

public class RDFEntity
implements Comparable<RDFEntity> {
    protected Model model;
    protected Resource self;

    public RDFEntity(Model model, Resource self) {
        this.model = model;
        this.self = self;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.self == null ? 0 : this.self.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFEntity other = (RDFEntity)obj;
        return !(this.self == null ? other.self != null : !this.self.equals(other.self));
    }

    public String toString() {
        return this.self.toString();
    }

    @Override
    public int compareTo(RDFEntity o) {
        return this.self.stringValue().compareTo(o.self.stringValue());
    }

    public Model getModel() {
        return this.model;
    }

    public Resource getResource() {
        return this.self;
    }

    public URI getURI() {
        if (this.self instanceof URI) {
            return (URI)this.self;
        }
        return null;
    }

    public boolean isA(URI type) {
        return this.model.contains(this.self, RDF.TYPE, (Value)type, new Resource[0]);
    }

    public Set<? extends Statement> getStatements(Collection<URI> preds) {
        HashSet result = new HashSet();
        for (URI pred : preds) {
            result.addAll(this.model.filter(this.self, pred, null, new Resource[0]));
        }
        return result;
    }

    public Set<? extends Value> getValues(URI pred) {
        return this.model.filter(this.self, pred, null, new Resource[0]).objects();
    }

    public Collection<String> getStrings(URI pred) {
        ArrayList<String> set = new ArrayList<String>();
        for (Value value : this.getValues(pred)) {
            if (value instanceof BNode) {
                for (Value value2 : new RDFList(this.model, (Value)((BNode)value)).asList()) {
                    if (value2 instanceof BNode) {
                        return Collections.EMPTY_SET;
                    }
                    set.add(value2.stringValue());
                }
                continue;
            }
            set.add(value.stringValue());
        }
        return set;
    }

    public String getString(URI pred) {
        return this.model.filter(this.self, pred, null, new Resource[0]).objectString();
    }

    public RDFClass getRDFClass(URI pred) {
        Resource subj = this.model.filter(this.self, pred, null, new Resource[0]).objectResource();
        if (subj == null) {
            return null;
        }
        return new RDFClass(this.model, subj);
    }

    public Collection<RDFClass> getRDFClasses(URI pred) {
        ArrayList<RDFClass> set = new ArrayList<RDFClass>();
        for (Value value : this.getValues(pred)) {
            if (!(value instanceof Resource)) continue;
            Resource subj = (Resource)value;
            if (this.model.contains(subj, RDF.TYPE, (Value)RDF.LIST, new Resource[0])) {
                for (Value value2 : new RDFList(this.model, (Value)subj).asList()) {
                    if (!(value2 instanceof Resource)) continue;
                    set.add(new RDFClass(this.model, (Resource)value2));
                }
                continue;
            }
            set.add(new RDFClass(this.model, subj));
        }
        return set;
    }

    public Set<RDFProperty> getRDFProperties(URI pred) {
        HashSet<RDFProperty> set = new HashSet<RDFProperty>();
        for (Value value : this.model.filter(this.self, pred, null, new Resource[0]).objects()) {
            if (!(value instanceof Resource)) continue;
            Resource subj = (Resource)value;
            set.add(new RDFProperty(this.model, subj));
        }
        return set;
    }

    public Set<RDFProperty> getRDFProperties() {
        HashSet<RDFProperty> set = new HashSet<RDFProperty>();
        for (URI pred : this.model.filter(this.self, null, null, new Resource[0]).predicates()) {
            set.add(new RDFProperty(this.model, (Resource)pred));
        }
        return set;
    }

    protected File createSourceFile(File dir, JavaNameResolver resolver) {
        String pkg = resolver.getPackageName(this.getURI());
        String simple = resolver.getSimpleName(this.getURI());
        File folder = dir;
        if (pkg != null) {
            folder = new File(dir, pkg.replace('.', '/'));
        }
        folder.mkdirs();
        return new File(folder, simple + ".java");
    }
}

