/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.model;

import java.io.File;
import java.io.IOException;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Prefix;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.model.RDFEntity;
import org.openrdf.repository.object.compiler.source.JavaMessageBuilder;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;

public class RDFOntology
extends RDFEntity {
    public RDFOntology(Model model, Resource self) {
        super(model, self);
    }

    public File generatePackageInfo(File dir, String namespace, JavaNameResolver resolver) throws IOException, ObjectStoreConfigException {
        String pkg = resolver.getPackageName((URI)new URIImpl(namespace));
        File source = this.createSourceFile(dir, pkg, resolver);
        JavaMessageBuilder builder = new JavaMessageBuilder(source, resolver);
        this.packageInfo(namespace, builder);
        builder.close();
        return source;
    }

    private void packageInfo(String namespace, JavaMessageBuilder builder) throws ObjectStoreConfigException {
        builder.comment(this);
        builder.annotationProperties(this);
        builder.annotateString(Prefix.class.getName(), "value", builder.getMemberPrefix(namespace));
        builder.annotateString(Iri.class.getName(), "value", namespace);
        builder.pkg(builder.getPackageName((URI)new URIImpl(namespace)));
    }

    private File createSourceFile(File dir, String pkg, JavaNameResolver resolver) {
        String simple = "package-info";
        File folder = dir;
        if (pkg != null) {
            folder = new File(dir, pkg.replace('.', '/'));
        }
        folder.mkdirs();
        File source = new File(folder, simple + ".java");
        return source;
    }
}

