/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.model;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.model.RDFEntity;
import org.openrdf.repository.object.compiler.source.JavaMessageBuilder;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;

public class RDFProperty
extends RDFEntity {
    public RDFProperty(Model model, Resource self) {
        super(model, self);
    }

    public File generateAnnotationCode(File dir, JavaNameResolver resolver) throws IOException, ObjectStoreConfigException {
        File source = this.createSourceFile(dir, resolver);
        JavaMessageBuilder builder = new JavaMessageBuilder(source, resolver);
        this.annotationHeader(builder);
        builder.close();
        return source;
    }

    private void annotationHeader(JavaMessageBuilder builder) throws ObjectStoreConfigException {
        String pkg = builder.getPackageName(this.getURI());
        String simple = builder.getSimpleName(this.getURI());
        if (pkg == null) {
            builder.imports(simple);
        } else {
            builder.pkg(pkg);
            builder.imports(pkg + '.' + simple);
        }
        builder.comment(this);
        if (this.isA(OWL.DEPRECATEDPROPERTY)) {
            builder.annotate(Deprecated.class);
        }
        builder.annotateEnum(Retention.class, "value", RetentionPolicy.class, "RUNTIME");
        builder.annotateEnums(Target.class, "value", ElementType.class, "TYPE", "METHOD", "PARAMETER", "ANNOTATION_TYPE", "PACKAGE");
        builder.annotationName(simple);
        builder.annotationProperties(this);
        builder.annotateURI(Iri.class, "value", builder.getType(this.getURI()));
        if (this.isA(OWL.FUNCTIONALPROPERTY)) {
            builder.method("value", true).returnType(builder.imports(String.class)).end();
        } else {
            builder.method("value", true).returnType(builder.imports(String.class) + "[]").end();
        }
    }
}

