/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.model.RDFClass;
import org.openrdf.repository.object.compiler.model.RDFEntity;
import org.openrdf.repository.object.compiler.model.RDFProperty;
import org.openrdf.repository.object.compiler.source.JavaClassBuilder;
import org.openrdf.repository.object.compiler.source.JavaCommentBuilder;
import org.openrdf.repository.object.compiler.source.JavaSourceBuilder;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.vocabulary.MSG;

public class JavaAnnotationBuilder
extends JavaClassBuilder {
    private static final URI NOTHING = new URIImpl("http://www.w3.org/2002/07/owl#Nothing");
    private static final URI DATARANGE = new URIImpl("http://www.w3.org/2002/07/owl#DataRange");
    private static final URI RESOURCE = RDFS.RESOURCE;
    private static final URI LITERAL = RDFS.LITERAL;
    private static final String JAVA_NS = "java:";
    protected JavaNameResolver resolver;
    private final Set<String> properties = new HashSet<String>();

    public JavaAnnotationBuilder(File source, JavaNameResolver resolver) throws FileNotFoundException {
        super(source);
        assert (resolver != null);
        this.resolver = resolver;
        for (String root : resolver.getRootPackages()) {
            this.imports.put(root, null);
        }
    }

    public String getMemberPrefix(String ns) {
        return this.resolver.getMemberPrefix(ns);
    }

    public String getPackageName(URI uri) {
        return this.resolver.getPackageName(uri);
    }

    public String getSimpleName(URI name) {
        return this.resolver.getSimpleName(name);
    }

    public URI getType(URI name) {
        return this.resolver.getType(name);
    }

    public boolean isAnonymous(URI name) {
        return this.resolver.isAnonymous(name);
    }

    public String getClassName(URI name) throws ObjectStoreConfigException {
        if (JAVA_NS.equals(name.getNamespace())) {
            return name.getLocalName();
        }
        return this.resolver.getClassName(name);
    }

    public void comment(RDFEntity concept) throws ObjectStoreConfigException {
        this.comment(this, concept);
    }

    public void comment(JavaSourceBuilder out, RDFEntity concept) throws ObjectStoreConfigException {
        StringBuilder sb = new StringBuilder();
        for (Value value : concept.getValues(RDFS.COMMENT)) {
            sb.append(value.stringValue()).append("\n");
        }
        JavaCommentBuilder comment = out.comment(sb.toString().trim());
        for (Value value : concept.getValues(RDFS.SEEALSO)) {
            Model model = concept.getModel();
            if (value instanceof URI && model.contains((Resource)((URI)value), RDF.TYPE, (Value)OWL.CLASS, new Resource[0])) {
                comment.seeAlso(this.resolver.getClassName((URI)value));
                continue;
            }
            if (value instanceof URI && model.contains((Resource)((URI)value), RDF.TYPE, (Value)RDF.PROPERTY, new Resource[0])) {
                RDFProperty property = new RDFProperty(model, (Resource)((URI)value));
                Iterator<RDFClass> iterator = property.getRDFClasses(RDFS.DOMAIN).iterator();
                while (iterator.hasNext()) {
                    RDFClass domain;
                    RDFClass cc = domain = iterator.next();
                    String cn = this.resolver.getClassName(domain.getURI());
                    String name = this.getPropertyName(cc, property);
                    String range = this.getPropertyClassName(cc, property);
                    if ("boolean".equals(range)) {
                        comment.seeBooleanProperty(cn, name);
                        continue;
                    }
                    comment.seeProperty(cn, name);
                }
                continue;
            }
            comment.seeAlso(value.stringValue());
        }
        if (concept instanceof RDFEntity) {
            for (String string : concept.getStrings(OWL.VERSIONINFO)) {
                comment.version(string.toString());
            }
        }
        comment.end();
    }

    public void annotationProperties(RDFEntity entity) throws ObjectStoreConfigException {
        this.annotationProperties(this, entity);
    }

    public void annotationProperties(JavaSourceBuilder out, RDFEntity entity) throws ObjectStoreConfigException {
        block0: for (RDFProperty property : entity.getRDFProperties()) {
            Object value;
            URI iri = property.getURI();
            boolean isSubClass = RDFS.SUBCLASSOF.equals((Object)iri);
            boolean compiled = this.resolver.isCompiledAnnotation(iri);
            if (!property.isA(OWL.ANNOTATIONPROPERTY) && !compiled) continue;
            URI uri = this.resolver.getType(iri);
            String ann = this.resolver.getClassName(uri);
            String attr = this.resolver.getAnnotationAttributeName(uri);
            boolean valueOfClass = this.resolver.isAnnotationOfClasses(uri);
            boolean functional = property.isA(OWL.FUNCTIONALPROPERTY);
            if (compiled && !functional) {
                functional = this.resolver.isCompiledAnnotationFunctional(iri);
            }
            if (valueOfClass && functional) {
                value = entity.getRDFClass(uri);
                if (isSubClass && MSG.MESSAGE.equals((Object)((RDFEntity)value).getResource())) continue;
                String className = this.resolver.getClassName(((RDFEntity)value).getURI());
                out.annotateClass(ann, attr, className);
                continue;
            }
            if (valueOfClass) {
                ArrayList<String> classNames = new ArrayList<String>();
                for (RDFClass value2 : entity.getRDFClasses(uri)) {
                    if (value2.getURI() == null) continue block0;
                    if (isSubClass && MSG.MESSAGE.equals((Object)value2.getResource())) continue;
                    classNames.add(this.resolver.getClassName(value2.getURI()));
                }
                if (classNames.isEmpty()) continue;
                out.annotateClasses(ann, attr, classNames);
                continue;
            }
            if (functional) {
                value = entity.getString(uri);
                if (isSubClass && MSG.MESSAGE.stringValue().equals(value)) continue;
                out.annotateString(ann, attr, (String)value);
                continue;
            }
            Collection<String> values = entity.getStrings(uri);
            if (isSubClass) {
                values.remove(MSG.MESSAGE.stringValue());
            }
            out.annotateStrings(ann, attr, values);
        }
    }

    public String getPropertyName(RDFClass code, RDFProperty param) {
        String name = this.getSuggestedPropertyName(code, param);
        if (this.properties.add(name)) {
            return name;
        }
        int count = 1;
        while (this.properties.contains(name + '_' + count)) {
            ++count;
        }
        return name + '_' + count;
    }

    public String getPropertyClassName(RDFClass code, RDFProperty property) throws ObjectStoreConfigException {
        RDFClass range = code.getRange(property, code.isFunctional(property));
        String type = this.getObjectClassName(range);
        if (code.isMinCardinality(property)) {
            type = this.unwrap(type);
        }
        return type;
    }

    public String getParameterClassName(RDFClass code, RDFProperty property) throws ObjectStoreConfigException {
        RDFClass range = code.getRange(property);
        String type = this.getObjectClassName(range);
        if (code.isMinCardinality(property)) {
            type = this.unwrap(type);
        }
        return type;
    }

    public String getResponseClassName(RDFClass code, RDFProperty property) throws ObjectStoreConfigException {
        RDFClass range = code.getRange(property);
        String type = this.getObjectClassName(range);
        if (code.isMinCardinality(property)) {
            type = this.unwrap(type);
        }
        return type;
    }

    protected String getRangeObjectClassName(RDFClass code, RDFProperty property) throws ObjectStoreConfigException {
        return this.getObjectClassName(code.getRange(property, true));
    }

    protected boolean isPrimitiveType(String type) {
        return type.equals("char") || type.equals("byte") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double") || type.equals("boolean") || type.equals("void");
    }

    private String getSuggestedPropertyName(RDFClass code, RDFProperty param) {
        if (code.isFunctional(param)) {
            return this.resolver.getSinglePropertyName(param.getURI());
        }
        return this.resolver.getPluralPropertyName(param.getURI());
    }

    private String getObjectClassName(RDFClass rdfClass) throws ObjectStoreConfigException {
        if (rdfClass == null) {
            return Object.class.getName();
        }
        String type = null;
        if (rdfClass.isA(DATARANGE)) {
            for (Value value : rdfClass.getList(OWL.ONEOF)) {
                URI datatype = ((Literal)value).getDatatype();
                if (datatype == null) {
                    type = String.class.getName();
                    continue;
                }
                type = this.resolver.getClassName(datatype);
            }
        } else {
            if (NOTHING.equals((Object)rdfClass.getURI())) {
                return Void.class.getName();
            }
            if (LITERAL.equals((Object)rdfClass.getURI())) {
                return Object.class.getName();
            }
            if (RESOURCE.equals((Object)rdfClass.getURI())) {
                return Object.class.getName();
            }
            if (rdfClass.getURI() != null) {
                type = this.resolver.getClassName(rdfClass.getURI());
            } else {
                return Object.class.getName();
            }
        }
        return type;
    }

    private String unwrap(String type) {
        if (type.equals("java.lang.Character")) {
            return "char";
        }
        if (type.equals("java.lang.Byte")) {
            return "byte";
        }
        if (type.equals("java.lang.Short")) {
            return "short";
        }
        if (type.equals("java.lang.Integer")) {
            return "int";
        }
        if (type.equals("java.lang.Long")) {
            return "long";
        }
        if (type.equals("java.lang.Float")) {
            return "float";
        }
        if (type.equals("java.lang.Double")) {
            return "double";
        }
        if (type.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (type.equals("java.lang.Void")) {
            return "void";
        }
        return type;
    }
}

