/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.object.compiler.source.JavaMethodBuilder;
import org.openrdf.repository.object.compiler.source.JavaPropertyBuilder;
import org.openrdf.repository.object.compiler.source.JavaSourceBuilder;

public class JavaClassBuilder
extends JavaSourceBuilder {
    private PrintWriter out;
    private String pkg;
    private String name;
    private boolean isInterface;
    private boolean extendsPrinted;
    private boolean implementsPrinted;
    private boolean headerPrinted;
    private boolean headerStarted;
    private boolean ended;
    private boolean closeHeader;
    private final Set<String> extended = new HashSet<String>();

    public JavaClassBuilder(PrintWriter out) {
        assert (out != null);
        HashMap<String, String> imports = new HashMap<String, String>();
        imports.put("char", null);
        imports.put("byte", null);
        imports.put("short", null);
        imports.put("int", null);
        imports.put("long", null);
        imports.put("float", null);
        imports.put("double", null);
        imports.put("boolean", null);
        imports.put("void", null);
        this.setImports(imports);
        this.setStringBuilder(new StringBuilder());
        this.out = out;
    }

    public JavaClassBuilder(File file) throws FileNotFoundException {
        this(new PrintWriter(file));
        assert (file != null);
    }

    public void close() {
        this.end();
        this.out.close();
    }

    public JavaClassBuilder pkg(String pkg) {
        if (this.sb.length() > 0) {
            this.out.append(this.sb);
            this.sb.setLength(0);
        }
        this.pkg = pkg;
        if (pkg != null) {
            this.out.print("package ");
            this.out.print(pkg);
            this.out.println(";");
            this.out.println();
        }
        return this;
    }

    public JavaClassBuilder className(String name) {
        this.name = name;
        this.headerStarted = true;
        if (this.pkg == null) {
            this.imports.put(name, name);
        } else {
            this.imports.put(name, this.pkg + "." + name);
        }
        this.sb.append("public class ");
        this.sb.append(name);
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaClassBuilder abstractName(String name) {
        this.name = name;
        this.headerStarted = true;
        if (this.pkg == null) {
            this.imports.put(name, name);
        } else {
            this.imports.put(name, this.pkg + "." + name);
        }
        this.sb.append("public abstract class ");
        this.sb.append(name);
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaClassBuilder interfaceName(String name) {
        this.name = name;
        this.headerStarted = true;
        this.isInterface = true;
        if (this.pkg == null) {
            this.imports.put(name, name);
        } else {
            this.imports.put(name, this.pkg + "." + name);
        }
        this.sb.append("public interface ");
        this.sb.append(name);
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaClassBuilder annotationName(String name) {
        this.name = name;
        this.headerStarted = true;
        this.isInterface = true;
        if (this.pkg == null) {
            this.imports.put(name, name);
        } else {
            this.imports.put(name, this.pkg + "." + name);
        }
        this.sb.append("public @interface ");
        this.sb.append(name);
        this.closeHeader();
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaClassBuilder extend(String name) {
        if (this.extended.contains(name)) {
            return this;
        }
        this.extended.add(name);
        this.closeHeader = true;
        if (this.extendsPrinted) {
            this.sb.append(", ");
        } else {
            this.sb.append(" extends ");
            this.extendsPrinted = true;
        }
        this.sb.append(this.imports(name));
        return this;
    }

    public JavaClassBuilder implement(String name) {
        if (this.isInterface) {
            return this.extend(name);
        }
        if (this.extended.contains(name)) {
            return this;
        }
        this.extended.add(name);
        this.closeHeader = true;
        if (this.implementsPrinted) {
            this.sb.append(", ");
        } else {
            this.sb.append(" implements ");
            this.implementsPrinted = true;
        }
        this.sb.append(this.imports(name));
        return this;
    }

    @Override
    protected void begin() {
        if (this.closeHeader) {
            this.closeHeader();
        }
        super.begin();
    }

    public JavaMethodBuilder staticMethod(String name) {
        this.closeHeader();
        return new JavaMethodBuilder(name, this.isInterface, true, false, this.imports, this.sb);
    }

    public JavaClassBuilder staticURIField(String name, URI value) {
        this.closeHeader();
        this.sb.append("\tpublic static final ").append(this.imports(URI.class));
        this.sb.append(" ").append(name).append(" = new ").append(this.imports(URIImpl.class));
        this.sb.append("(\"").append(value.stringValue()).append("\");\n");
        return this;
    }

    public JavaClassBuilder staticURIArrayField(String name, Collection<String> names) {
        this.closeHeader();
        this.sb.append("\tpublic static final ").append(this.imports(URI.class));
        this.sb.append("[] ").append(name).append(" = new ").append(this.imports(URI.class));
        this.sb.append("[]{");
        Iterator<String> iter = names.iterator();
        while (iter.hasNext()) {
            this.sb.append(iter.next());
            if (!iter.hasNext()) continue;
            this.sb.append(", ");
        }
        this.sb.append("};\n");
        return this;
    }

    public JavaClassBuilder staticField(String type, String name, String code) {
        this.closeHeader();
        this.sb.append("\tprivate static ").append(this.imports(type));
        this.sb.append(" ").append(this.var(name)).append(" = ").append(code).append(";\n");
        return this;
    }

    public JavaClassBuilder field(String type, String name) {
        this.closeHeader();
        this.sb.append("\tprivate ").append(this.imports(type));
        this.sb.append(" ").append(this.var(name)).append(";\n");
        return this;
    }

    public JavaMethodBuilder constructor() {
        this.closeHeader();
        this.sb.append("\n");
        return new JavaMethodBuilder(this.name, this.isInterface, false, false, this.imports, this.sb);
    }

    public JavaPropertyBuilder property(String name) {
        this.closeHeader();
        return new JavaPropertyBuilder(name, this.isInterface, this.imports, this.sb);
    }

    public JavaMethodBuilder method(String name, boolean isAbstract) {
        this.closeHeader();
        return new JavaMethodBuilder(name, this.isInterface, false, isAbstract, this.imports, this.sb);
    }

    public JavaClassBuilder code(String code) {
        this.closeHeader();
        this.sb.append(code);
        return this;
    }

    private void end() {
        if (this.ended) {
            return;
        }
        this.ended = true;
        boolean importsPrinted = false;
        ArrayList values = new ArrayList(this.imports.values());
        values.removeAll(Collections.singleton(null));
        for (String cn : new TreeSet(values)) {
            String pack;
            int packageEnd;
            if (cn == null || (packageEnd = cn.lastIndexOf(46)) <= 0 || (pack = cn.substring(0, packageEnd)).equals(this.pkg)) continue;
            this.out.print("import ");
            this.out.print(cn);
            this.out.println(";");
            importsPrinted = true;
        }
        if (importsPrinted) {
            this.out.println();
        }
        this.setIndent(this.getindent().replaceAll("\t$", ""));
        if (this.headerStarted) {
            this.closeHeader();
            this.out.append(this.sb);
            this.out.println("}");
        }
        this.out.flush();
    }

    private void closeHeader() {
        if (!this.headerPrinted) {
            this.headerPrinted = true;
            this.sb.append(" {\n");
        }
    }
}

