/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

public class JavaCommentBuilder {
    private StringBuilder out;
    private StringBuilder sb;
    private String indent;
    private boolean newline;

    public JavaCommentBuilder(StringBuilder out, String indent, String comment) {
        this.out = out;
        this.sb = new StringBuilder();
        this.indent = indent;
        if (comment != null) {
            this.newline = comment.contains("\n");
            if (this.newline) {
                this.sb.append(comment.replace("\n", "\n" + indent + " * "));
            } else {
                this.sb.append(comment);
            }
        }
    }

    public JavaCommentBuilder seeAlso(String seeAlso) {
        this.sb.append("\n").append(this.indent).append(" * @see ").append(seeAlso);
        this.newline = true;
        return this;
    }

    public JavaCommentBuilder seeAlso(String className, String member) {
        this.sb.append("\n").append(this.indent).append(" * @see ").append(className).append("#").append(member);
        this.newline = true;
        return this;
    }

    public JavaCommentBuilder seeBooleanProperty(String className, String property) {
        return this.seeAlso(className, "is" + this.initcap(property));
    }

    public JavaCommentBuilder seeProperty(String className, String property) {
        return this.seeAlso(className, "get" + this.initcap(property));
    }

    public JavaCommentBuilder version(String version) {
        this.sb.append("\n").append(this.indent).append(" * @version ").append(version);
        this.newline = true;
        return this;
    }

    public void end() {
        if (this.sb.length() > 0) {
            this.out.append(this.indent);
            this.out.append("/** ");
            if (this.newline) {
                this.out.append("\n").append(this.indent).append(" * ");
            }
            this.out.append((CharSequence)this.sb);
            if (this.newline) {
                this.out.append("\n").append(this.indent);
            }
            this.out.append(" */\n");
        }
    }

    private String initcap(String name) {
        String cap = name.substring(0, 1).toUpperCase();
        return cap + name.substring(1);
    }
}

