/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCompiler {
    final Logger logger = LoggerFactory.getLogger(JavaCompiler.class);
    private String version = "5";
    private boolean useTools = true;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Iterable<String> content, File dir, List<File> classpath) throws IOException {
        ArrayList<File> source = new ArrayList<File>();
        for (String name : content) {
            String filename = name.replace('.', File.separatorChar);
            source.add(new File(dir.getAbsoluteFile(), filename + ".java"));
        }
        File argfile = this.buildJavacArgfile(source, classpath);
        try {
            String[] args = new String[]{"@" + argfile.getAbsolutePath()};
            if (this.javac(args) != 0) {
                throw new IOException("Could not compile");
            }
        }
        finally {
            argfile.delete();
        }
    }

    private int javac(String[] args) throws IOException {
        int result = -1;
        if (this.useTools && (result = this.javaCompilerTool(args)) < 0) {
            result = this.javaSunTools(args);
        }
        if (result == 0) {
            return result;
        }
        result = this.javacCommand(args);
        if (result == 0) {
            this.useTools = false;
        }
        if (result >= 0) {
            return result;
        }
        throw new AssertionError((Object)"No Compiler Found");
    }

    private int javaCompilerTool(String[] args) {
        try {
            Class<?> provider = this.forName("javax.tools.ToolProvider");
            Method getJavaCompiler = provider.getMethod("getSystemJavaCompiler", new Class[0]);
            Class<?> tool = this.forName("javax.tools.Tool");
            Method run = tool.getMethod("run", InputStream.class, OutputStream.class, OutputStream.class, args.getClass());
            Object compiler = getJavaCompiler.invoke(null, new Object[0]);
            if (compiler == null) {
                return -1;
            }
            this.logger.debug("invoke javax.tools.JavaCompiler#run");
            Object[] param = new Object[]{null, null, null, args};
            Object result = run.invoke(compiler, param);
            return ((Number)result).intValue();
        }
        catch (InvocationTargetException e) {
            this.logger.warn(e.toString());
            return -1;
        }
        catch (ClassNotFoundException e) {
            return -1;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
        catch (SecurityException e) {
            return -1;
        }
        catch (NoSuchMethodException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> forName(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            return Class.forName(className);
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return Class.forName(className, true, cl);
        }
    }

    private int javaSunTools(String[] args) {
        try {
            Class<?> sun;
            try {
                sun = this.forName("com.sun.tools.javac.Main");
            }
            catch (ClassNotFoundException e) {
                return -1;
            }
            Method method = sun.getMethod("compile", args.getClass());
            this.logger.debug("invoke com.sun.tools.javac.Main#compile");
            Object result = method.invoke(null, new Object[]{args});
            return ((Number)result).intValue();
        }
        catch (InvocationTargetException e) {
            this.logger.warn(e.toString());
            return -1;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
        catch (SecurityException e) {
            return -1;
        }
        catch (NoSuchMethodException e) {
            return -1;
        }
    }

    private int javacCommand(String[] args) throws IOException {
        String javac = this.findJavac();
        if (javac == null) {
            return -1;
        }
        return this.exec(javac, args);
    }

    private String findJavac() {
        String javac = this.findJavac(System.getProperty("jdk.home"));
        if (javac == null) {
            javac = this.findJavac(System.getProperty("java.home"));
        }
        if (javac == null) {
            javac = this.findJavac(System.getenv("JAVA_HOME"));
        }
        if (javac == null) {
            String systemPath = System.getenv("PATH");
            for (String path : systemPath.split(File.pathSeparator)) {
                File file = new File(path, "javac");
                if (!this.exists(file)) continue;
                return file.getPath();
            }
        }
        return javac;
    }

    private String findJavac(String home) {
        if (home == null) {
            return null;
        }
        File javac = new File(new File(home, "bin"), "javac");
        if (this.exists(javac)) {
            return javac.getPath();
        }
        javac = new File(new File(home, "bin"), "javac.exe");
        if (this.exists(javac)) {
            return javac.getPath();
        }
        File parent = new File(home).getParentFile();
        javac = new File(new File(parent, "bin"), "javac");
        if (this.exists(javac)) {
            return javac.getPath();
        }
        javac = new File(new File(parent, "bin"), "javac.exe");
        if (this.exists(javac)) {
            return javac.getPath();
        }
        for (File dir : parent.listFiles()) {
            javac = new File(new File(dir, "bin"), "javac");
            if (this.exists(javac)) {
                return javac.getPath();
            }
            javac = new File(new File(dir, "bin"), "javac.exe");
            if (!this.exists(javac)) continue;
            return javac.getPath();
        }
        return null;
    }

    private boolean exists(File javac) {
        try {
            return javac.exists();
        }
        catch (SecurityException e) {
            this.logger.warn(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(String cmd, String[] args) throws IOException {
        this.logger.debug("exec {}", (Object)cmd);
        String[] cmdArray = new String[1 + args.length];
        cmdArray[0] = cmd;
        System.arraycopy(args, 0, cmdArray, 1, args.length);
        File wd = File.createTempFile("javac", "dir");
        wd.delete();
        wd = wd.getParentFile();
        final Process exec = Runtime.getRuntime().exec(cmdArray, null, wd);
        try {
            Thread gobbler = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        InputStream in = exec.getInputStream();
                        try {
                            InputStreamReader isr = new InputStreamReader(in);
                            BufferedReader br = new BufferedReader(isr);
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {
                        JavaCompiler.this.logger.error(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            };
            gobbler.start();
            InputStream stderr = exec.getErrorStream();
            try {
                exec.getOutputStream().close();
                InputStreamReader isr = new InputStreamReader(stderr);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.err.println(line);
                }
            }
            finally {
                stderr.close();
            }
            try {
                int isr = exec.waitFor();
                return isr;
            }
            catch (InterruptedException cause) {
                InterruptedIOException e = new InterruptedIOException(cause.getMessage());
                e.initCause(cause);
                throw e;
            }
        }
        finally {
            exec.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildJavacArgfile(List<File> sources, List<File> classpath) throws IOException {
        File args = File.createTempFile("javac", "args");
        PrintWriter w = new PrintWriter(new FileWriter(args));
        try {
            w.println("-nowarn");
            w.println("-source");
            w.println(this.version);
            w.println("-target");
            w.println(this.version);
            w.println("-classpath");
            w.print("\"");
            for (File jar : classpath) {
                w.print(jar.getAbsolutePath().replace("\\", "\\\\"));
                w.print(File.pathSeparatorChar);
            }
            w.println("\"");
            int n = sources.size();
            for (int i = 0; i < n; ++i) {
                w.print("\"");
                w.print(sources.get(i).getAbsolutePath().replace("\\", "\\\\"));
                w.println("\"");
            }
        }
        finally {
            w.close();
        }
        return args;
    }
}

