/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.repository.object.compiler.JavaNameResolver;
import org.openrdf.repository.object.compiler.model.RDFClass;
import org.openrdf.repository.object.compiler.model.RDFProperty;
import org.openrdf.repository.object.compiler.source.JavaAnnotationBuilder;
import org.openrdf.repository.object.compiler.source.JavaMethodBuilder;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;

public class JavaMessageBuilder
extends JavaAnnotationBuilder {
    public JavaMessageBuilder(File source, JavaNameResolver resolver) throws FileNotFoundException {
        super(source, resolver);
    }

    public void message(RDFClass msg) throws ObjectStoreConfigException {
        String methodName = this.getMessageName(msg);
        if (methodName == null) {
            return;
        }
        URI uri = msg.getURI();
        if (this.isBeanProperty(msg, methodName)) {
            uri = null;
        }
        JavaMethodBuilder code = this.method(methodName, true);
        this.comment(code, msg);
        this.annotationProperties(code, msg);
        URI rdfType = this.resolver.getType(uri);
        if (rdfType != null) {
            code.annotateURI(Iri.class, "value", rdfType);
        }
        RDFProperty response = msg.getResponseProperty();
        String range = this.getResponseClassName(msg, response);
        if (msg.isFunctional(response)) {
            code.returnType(range);
        } else {
            code.returnSetOf(range);
        }
        for (RDFProperty param : msg.getParameters()) {
            String name;
            String type = this.getParameterClassName(msg, param);
            URI pred = param.getURI();
            URI rdf = this.resolver.getType(pred);
            this.annotationProperties(code, param);
            for (RDFClass c : msg.getRestrictions()) {
                RDFProperty property = c.getRDFProperty(OWL.ONPROPERTY);
                if (!param.equals(property)) continue;
                this.annotationProperties(code, c);
            }
            if (rdf != null) {
                code.annotateURI(Iri.class, "value", rdf);
            }
            if (msg.isFunctional(param)) {
                name = this.resolver.getSingleParameterName(pred);
                code.param(type, name);
                continue;
            }
            name = this.resolver.getPluralParameterName(pred);
            code.paramSetOf(type, name);
        }
        code.end();
    }

    private String getMessageName(RDFClass msg) {
        List<? extends Value> list = msg.getList(OWL.INTERSECTIONOF);
        if (list != null) {
            for (Value value : list) {
                String name;
                RDFClass rc;
                if (!(value instanceof URI) || !(rc = new RDFClass(msg.getModel(), (Resource)((URI)value))).isMessageClass() || (name = this.getMessageName(rc)) == null) continue;
                return name;
            }
        }
        if (this.resolver.isAnonymous(msg.getURI())) {
            return null;
        }
        return this.resolver.getMethodName(msg.getURI());
    }

    private boolean isBeanProperty(RDFClass code, String methodName) throws ObjectStoreConfigException {
        RDFProperty response;
        String range;
        if (methodName.startsWith("get") && code.getParameters().isEmpty()) {
            return true;
        }
        if (methodName.startsWith("set") && code.getParameters().size() == 1) {
            return true;
        }
        return methodName.startsWith("is") && code.getParameters().isEmpty() && "boolean".equals(range = this.getResponseClassName(code, response = code.getResponseProperty()));
    }
}

