/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.util.Map;
import org.openrdf.repository.object.compiler.source.JavaSourceBuilder;

public class JavaMethodBuilder
extends JavaSourceBuilder {
    private String methodName;
    private boolean isInterface;
    private boolean isStatic;
    private boolean hasParameters;
    private boolean isAbstract = true;
    private boolean hasReturnType;
    private boolean endParameter;
    private boolean headerPrinted;
    private boolean bodyPrinted;
    private StringBuilder body = new StringBuilder();

    public JavaMethodBuilder(String name, boolean isInterface, boolean isStatic, boolean isAbstract, Map<String, String> imports, StringBuilder sb) {
        this.methodName = name;
        this.isInterface = isInterface;
        this.isStatic = isStatic;
        this.isAbstract = isAbstract;
        this.setImports(imports);
        this.setStringBuilder(sb);
        this.setIndent("\t");
    }

    public JavaMethodBuilder returnType(String type) {
        this.hasReturnType = true;
        this.printHeader();
        if (Void.class.getName().equals(type)) {
            this.body.append("void").append(" ");
        } else {
            this.body.append(this.imports(type)).append(" ");
        }
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaMethodBuilder returnSetOf(String type) {
        this.hasReturnType = true;
        this.printHeader();
        this.body.append(this.imports("java.util.Set"));
        this.body.append("<").append(this.imports(type)).append("> ");
        this.setIndent(this.getindent() + "\t");
        return this;
    }

    public JavaMethodBuilder paramSetOf(String type, String name) {
        if (this.hasParameters && this.endParameter) {
            this.body.append(",\n");
        } else if (!this.hasParameters) {
            this.hasParameters = true;
            this.printHeader();
            this.body.append(this.methodName);
            this.body.append("(\n");
        }
        this.body.append(this.getindent()).append(this.imports("java.util.Set"));
        this.body.append("<").append(this.imports(type)).append("> ");
        this.body.append(name);
        this.endParameter = true;
        return this;
    }

    public JavaMethodBuilder param(String type, String name) {
        if (this.hasParameters && this.endParameter) {
            this.body.append(",\n");
        } else if (!this.hasParameters) {
            this.hasParameters = true;
            this.printHeader();
            this.body.append(this.methodName);
            this.body.append("(\n");
        }
        this.body.append(this.getindent()).append(this.imports(type)).append(" ").append(this.var(name));
        this.endParameter = true;
        return this;
    }

    public JavaMethodBuilder code(String code) {
        if (code == null) {
            return this;
        }
        if (!this.bodyPrinted) {
            if (!this.hasParameters) {
                this.printHeader();
                this.body.append(this.methodName);
                this.body.append("(");
            }
            this.isAbstract = false;
            this.bodyPrinted = true;
            this.body.append(") {\n");
        }
        this.body.append(this.getindent()).append(code);
        return this;
    }

    public void end() {
        this.setIndent("\t");
        this.printHeader();
        this.sb.append((CharSequence)this.body);
        if (!this.bodyPrinted) {
            if (!this.hasParameters) {
                this.printHeader();
                this.sb.append(this.methodName);
                this.sb.append("(");
            }
            this.sb.append(");\n\n");
        } else {
            this.sb.append("\n\t}\n\n");
        }
    }

    @Override
    protected void begin() {
        if (this.endParameter) {
            this.body.append(",\n");
            this.endParameter = false;
        } else if (this.hasReturnType && !this.hasParameters) {
            this.hasParameters = true;
            this.printHeader();
            this.body.append(this.methodName);
            this.body.append("(\n");
        }
        this.sb.append((CharSequence)this.body);
        this.body.setLength(0);
    }

    private void printHeader() {
        if (!this.headerPrinted) {
            this.body.append("\t");
            if (!this.isInterface) {
                this.body.append("public ");
                if (this.isStatic) {
                    this.body.append("static ");
                }
                if (this.isAbstract) {
                    this.body.append("abstract ");
                }
            }
            this.headerPrinted = true;
        }
    }
}

