/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.util.Map;
import org.openrdf.repository.object.compiler.source.JavaSourceBuilder;

public class JavaPropertyBuilder
extends JavaSourceBuilder {
    private String name;
    private String type;
    private String extype;
    private boolean isInterface;

    public JavaPropertyBuilder(String name, boolean isInterface, Map<String, String> imports, StringBuilder sb) {
        this.name = name;
        this.isInterface = isInterface;
        this.setImports(imports);
        this.setStringBuilder(sb);
        this.setIndent("\t");
    }

    public JavaPropertyBuilder type(String type) {
        this.type = this.extype = this.imports(type);
        return this;
    }

    public JavaPropertyBuilder setOf(String type) {
        this.type = this.imports("java.util.Set") + "<" + this.imports(type) + ">";
        this.extype = Object.class.getName().equals(type) ? this.imports("java.util.Set") + "<?>" : this.imports("java.util.Set") + "<? extends " + this.imports(type) + ">";
        return this;
    }

    public void getter() {
        this.sb.append("\t");
        if (!this.isInterface) {
            this.sb.append("public abstract ");
        }
        if ("boolean".equals(this.type)) {
            this.sb.append("boolean is");
        } else {
            this.sb.append(this.type).append(" get");
        }
        String cap = this.name.substring(0, 1).toUpperCase();
        this.sb.append(cap).append(this.name.substring(1));
        this.sb.append("();\n");
    }

    public void openSetter() {
        String cap = this.name.substring(0, 1).toUpperCase();
        this.sb.append("\t");
        if (!this.isInterface) {
            this.sb.append("public abstract ");
        }
        this.sb.append("void set");
        this.sb.append(cap).append(this.name.substring(1));
        this.sb.append("(");
    }

    public void closeSetter() {
        this.sb.append(this.extype);
        this.sb.append(" ").append(this.var(this.name)).append(");\n");
    }

    public void end() {
        this.sb.append("\n");
    }
}

