/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.compiler.source;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.repository.object.compiler.source.JavaCommentBuilder;

public class JavaSourceBuilder {
    private static Collection<String> keywords = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null");
    protected Map<String, String> imports;
    protected StringBuilder sb;
    protected String indent = "";

    protected void setImports(Map<String, String> imports) {
        assert (imports != null);
        this.imports = imports;
    }

    protected void setStringBuilder(StringBuilder sb) {
        this.sb = sb;
    }

    protected String getindent() {
        return this.indent;
    }

    protected void setIndent(String indent) {
        this.indent = indent;
    }

    public String imports(Class<?> klass) {
        return this.imports(klass.getName());
    }

    public String imports(String klass) {
        String name = klass.trim();
        if (name.contains("<")) {
            return this.importsGeneric(name);
        }
        if (name.endsWith("[]")) {
            return this.imports(name.substring(0, name.length() - 2)) + "[]";
        }
        if (name.indexOf(46) < 0) {
            return name;
        }
        this.imports.put(name.substring(0, name.indexOf(46)), null);
        int idx = name.lastIndexOf(46);
        String sn = name.substring(idx + 1);
        if (!this.imports.containsKey(sn)) {
            this.imports.put(sn, name);
            return sn;
        }
        if (name.equals(this.imports.get(sn))) {
            return sn;
        }
        return name;
    }

    public JavaCommentBuilder comment(String comment) {
        this.begin();
        return new JavaCommentBuilder(this.sb, this.indent, comment);
    }

    public JavaSourceBuilder annotate(Class<?> ann) {
        this.begin();
        this.sb.append(this.indent).append("@");
        this.sb.append(this.imports(ann.getName())).append("\n");
        return this;
    }

    public JavaSourceBuilder annotateStrings(String ann, String attr, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append("{");
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.appendString(this.sb, value);
        }
        this.sb.append("})\n");
        return this;
    }

    public JavaSourceBuilder annotateString(String ann, String attr, String value) {
        if (value == null) {
            return this;
        }
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.appendString(this.sb, value);
        this.sb.append(")\n");
        return this;
    }

    public JavaSourceBuilder annotateURI(Class<?> ann, String attr, URI value) {
        if (value == null) {
            return this;
        }
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.appendString(this.sb, value);
        this.sb.append(")\n");
        return this;
    }

    public JavaSourceBuilder annotateURIs(Class<?> ann, String attr, List<URI> values) {
        if (values.isEmpty()) {
            return this;
        }
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append("{");
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            this.appendString(this.sb, values.get(i));
        }
        this.sb.append("})\n");
        return this;
    }

    public JavaSourceBuilder annotateClasses(String ann, String attr, List<String> values) {
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append("{");
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            String type = values.get(i);
            this.sb.append(this.imports(type)).append(".class");
        }
        this.sb.append("})\n");
        return this;
    }

    public JavaSourceBuilder annotateClass(String ann, String attr, String value) {
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append(this.imports(value)).append(".class)\n");
        return this;
    }

    public JavaSourceBuilder annotateEnum(Class<?> ann, String attr, Class<?> e, String value) {
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann)).append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append(this.imports(e)).append(".");
        this.sb.append(value).append(")\n");
        return this;
    }

    public JavaSourceBuilder annotateEnums(Class<?> ann, String attr, Class<?> e, String ... values) {
        this.begin();
        this.sb.append(this.indent).append("@").append(this.imports(ann));
        this.sb.append("(");
        if (attr != null && !"value".equals(attr)) {
            this.sb.append(attr).append("=");
        }
        this.sb.append("{");
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            this.sb.append(this.imports(e)).append(".");
            this.sb.append(values[i]);
        }
        this.sb.append("})\n");
        return this;
    }

    protected String var(String name) {
        if (keywords.contains(name)) {
            return "_" + name;
        }
        return name;
    }

    protected void begin() {
    }

    private void appendString(StringBuilder sb, URI value) {
        this.appendString(sb, value.stringValue());
    }

    private void appendString(StringBuilder sb, String value) {
        String tab = this.indent + "\t";
        String newline = "\" + \n" + tab + "\"";
        String str = value;
        str = value.replace("\\", "\\\\");
        str = str.replace("\"", "\\\"");
        str = str.replace("\r\n", "\\r\\n" + newline);
        str = str.replace("\n", "\\n" + newline);
        if ((str = str.replace("\r", "\\r" + newline)).endsWith(newline)) {
            str = str.substring(0, str.length() - newline.length());
        }
        sb.append("\"");
        sb.append(str);
        sb.append("\"");
    }

    private String importsGeneric(String name) {
        int start = name.indexOf(60);
        int end = name.lastIndexOf(62);
        StringBuilder sb = new StringBuilder();
        sb.append(this.imports(name.substring(0, start)));
        sb.append('<');
        int idx = start + 1;
        int nested = 0;
        block5: for (int i = start + 1; i < end; ++i) {
            switch (name.charAt(i)) {
                case ',': {
                    if (nested != 0) continue block5;
                    sb.append(this.imports(name.substring(idx, i))).append(", ");
                    idx = i + 1;
                    continue block5;
                }
                case '<': {
                    ++nested;
                    continue block5;
                }
                case '>': {
                    --nested;
                }
            }
        }
        sb.append(this.imports(name.substring(idx, end)));
        sb.append('>');
        return sb.toString();
    }
}

