/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.composition.BehaviourProvider;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.composition.CodeBuilder;
import org.openrdf.repository.object.composition.MethodBuilder;
import org.openrdf.repository.object.composition.helpers.BehaviourConstructor;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.managers.PropertyMapper;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;

public class AbstractClassFactory
implements BehaviourProvider {
    private static final String BEAN_FIELD_NAME = "_$bean";
    private static final String CLASS_PREFIX = "object.behaviours.";
    private ClassFactory cp;
    private Set<Class<?>> bases;

    @Override
    public void setClassDefiner(ClassFactory definer) {
        this.cp = definer;
    }

    @Override
    public void setBaseClasses(Set<Class<?>> bases) {
        this.bases = bases;
    }

    @Override
    public void setPropertyMapper(PropertyMapper mapper) {
    }

    @Override
    public Collection<? extends BehaviourFactory> getBehaviourFactories(Collection<Class<?>> classes) throws ObjectCompositionException {
        Set<Class<?>> faces = new HashSet();
        for (Class<?> i : classes) {
            faces.add(i);
            faces = this.getImplementingClasses(i, faces);
        }
        ArrayList<BehaviourFactory> result = new ArrayList<BehaviourFactory>(faces.size());
        for (Class clazz : faces) {
            result.addAll(this.getBehaviourFactories(clazz));
        }
        return result;
    }

    private Collection<BehaviourFactory> getBehaviourFactories(Class<?> concept) throws ObjectCompositionException {
        try {
            ArrayList<BehaviourFactory> result = new ArrayList<BehaviourFactory>();
            if (this.isEnhanceable(concept)) {
                for (Class<?> mapper : this.findImplementations(concept)) {
                    result.add(new BehaviourConstructor(mapper));
                }
            }
            return result;
        }
        catch (ObjectCompositionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCompositionException(e);
        }
    }

    private Collection<? extends Class<?>> findImplementations(Class<?> concept) throws Exception {
        return Collections.singleton(this.findBehaviour(concept));
    }

    private boolean isBaseClass(Class<?> role) {
        return this.bases != null && this.bases.contains(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Class<?> findBehaviour(Class<?> concept) throws Exception {
        String className = this.getJavaClassName(concept);
        ClassFactory classFactory = this.cp;
        synchronized (classFactory) {
            try {
                return this.cp.classForName(className);
            }
            catch (ClassNotFoundException e2) {
                return this.implement(className, concept);
            }
        }
    }

    private ClassTemplate createBehaviourTemplate(String className, Class<?> concept) {
        ClassTemplate cc = this.createClassTemplate(className, concept);
        cc.addInterface(RDFObjectBehaviour.class);
        this.addNewConstructor(cc, concept);
        this.addRDFObjectBehaviourMethod(cc);
        return cc;
    }

    private boolean isOverridden(Method m) {
        if (m.getParameterTypes().length > 0) {
            return false;
        }
        return "getBehaviourDelegate".equals(m.getName());
    }

    private String getJavaClassName(Class<?> concept) {
        String suffix = this.getClass().getSimpleName().replaceAll("Factory$", "");
        return CLASS_PREFIX + concept.getName() + suffix;
    }

    private Class<?> implement(String className, Class<?> concept) throws Exception {
        ClassTemplate cc = this.createBehaviourTemplate(className, concept);
        this.enhance(cc, concept);
        return this.cp.createClass(cc);
    }

    private void addNewConstructor(ClassTemplate cc, Class<?> concept) {
        if (!concept.isInterface()) {
            try {
                concept.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ObjectCompositionException(concept.getSimpleName() + " must have a default constructor");
            }
        }
        cc.createField(Object.class, BEAN_FIELD_NAME);
        cc.addConstructor(new Class[]{Object.class}, "_$bean = $1;");
    }

    private void addRDFObjectBehaviourMethod(ClassTemplate cc) {
        cc.createMethod(Object.class, "getBehaviourDelegate", new Class[0]).code("return ").code(BEAN_FIELD_NAME).code(";").end();
    }

    private Set<Class<?>> getImplementingClasses(Class<?> role, Set<Class<?>> implementations) {
        return implementations;
    }

    private ClassTemplate createClassTemplate(String className, Class<?> role) {
        ClassTemplate cc = this.cp.createClassTemplate(className, role);
        cc.copyAnnotationsFrom(role);
        return cc;
    }

    private boolean isEnhanceable(Class<?> role) {
        return !role.isInterface() && Modifier.isAbstract(role.getModifiers()) && !this.isBaseClass(role);
    }

    private void enhance(ClassTemplate cc, Class<?> c) throws Exception {
        if (Object.class.equals(c.getMethod("toString", new Class[0]).getDeclaringClass())) {
            this.overrideToStringMethod(cc);
        }
        if (Object.class.equals(c.getMethod("equals", Object.class).getDeclaringClass()) && Object.class.equals(c.getMethod("hashCode", new Class[0]).getDeclaringClass())) {
            this.overrideEqualsMethod(cc);
        }
        for (Method m : this.getMethods(c)) {
            if (Modifier.isFinal(m.getModifiers()) || !Modifier.isAbstract(m.getModifiers()) || this.isOverridden(m)) continue;
            Class<?> r = m.getReturnType();
            Class<?>[] types = m.getParameterTypes();
            MethodBuilder code = cc.createInstancePrivateMethod(m);
            boolean isInterface = m.getDeclaringClass().isInterface();
            if (!isInterface) {
                code.code("try {");
            }
            if (!Void.TYPE.equals(r)) {
                code.code("return ($r) ");
            }
            if (isInterface) {
                code.code("(").castObject(m.getDeclaringClass()).code(BEAN_FIELD_NAME);
                code.code(").").code(m.getName()).code("($$);");
            } else {
                code.code(BEAN_FIELD_NAME).code(".getClass().getMethod(");
                code.insert(m.getName()).code(", ").insert(types).code(")").code(".invoke(");
                code.code(BEAN_FIELD_NAME).code(", $args);");
            }
            if (!isInterface) {
                code.code("} catch (").code(InvocationTargetException.class.getName());
                code.code(" e) {throw e.getCause();}");
            }
            ((CodeBuilder)code).end();
        }
    }

    private Collection<Method> getMethods(Class<?> c) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(c.getMethods()));
        HashMap<Object, Method> map = new HashMap<Object, Method>();
        Map<Object, Method> pms = this.getProtectedMethods(c, map);
        methods.addAll(pms.values());
        return methods;
    }

    private Map<Object, Method> getProtectedMethods(Class<?> c, Map<Object, Method> methods) {
        if (c == null) {
            return methods;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!Modifier.isProtected(m.getModifiers())) continue;
            List<Class<?>> types = Arrays.asList(m.getParameterTypes());
            List<Object> key = Arrays.asList(m.getName(), types);
            if (methods.containsKey(key)) continue;
            methods.put(key, m);
        }
        return this.getProtectedMethods(c.getSuperclass(), methods);
    }

    private void overrideToStringMethod(ClassTemplate cc) {
        try {
            Method toString = Object.class.getMethod("toString", new Class[0]);
            MethodBuilder m = cc.createInstancePrivateMethod(toString);
            m.code("return ").code("getBehaviourDelegate");
            m.code("().toString()").semi().end();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void overrideEqualsMethod(ClassTemplate cc) {
        try {
            Method hashCode = Object.class.getMethod("hashCode", new Class[0]);
            MethodBuilder m = cc.createInstancePrivateMethod(hashCode);
            m.code("return ").code("getBehaviourDelegate");
            m.code("().hashCode()").semi().end();
            Method equals = Object.class.getMethod("equals", Object.class);
            m = cc.createInstancePrivateMethod(equals);
            m.code("return ").code("getBehaviourDelegate");
            m.code("().equals($1)").semi().end();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

