/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;

public class ClassFactory
extends ClassLoader {
    private Reference<ClassPool> cp;
    private File output;
    private List<ClassLoader> alternatives = new ArrayList<ClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> classForName(String name, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            return Class.forName(name);
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return Class.forName(name, true, cl);
        }
    }

    public ClassFactory(File dir) {
        this(dir, Thread.currentThread().getContextClassLoader());
    }

    public ClassFactory(File dir, ClassLoader parent) {
        super(parent);
        this.output = dir;
        dir.mkdirs();
    }

    public synchronized Class<?> classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this);
    }

    public synchronized Object newInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.classForName(name).newInstance();
    }

    public Class<?> createClass(ClassTemplate template) throws ObjectCompositionException {
        CtClass cc = template.getCtClass();
        String name = cc.getName();
        try {
            byte[] bytecode = cc.toBytecode();
            cc.detach();
            return this.defineClass(name, bytecode);
        }
        catch (IOException e) {
            throw new ObjectCompositionException(e);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public ClassTemplate createClassTemplate(String className) {
        ClassPool cp = this.getClassPool();
        return new ClassTemplate(cp.makeClass(className), this);
    }

    public ClassTemplate loadClassTemplate(Class<?> class1) {
        return new ClassTemplate(this.get(class1), this);
    }

    public ClassTemplate createClassTemplate(String name, Class<?> class1) {
        ClassPool cp = this.getClassPool();
        CtClass cc = cp.makeClass(name, this.get(class1));
        return new ClassTemplate(cc, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        try {
            File file = new File(this.output, name);
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        List<ClassLoader> list = this.alternatives;
        synchronized (list) {
            for (ClassLoader cl : this.alternatives) {
                url = cl.getResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream;
        File file = new File(this.output, name);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((stream = this.getParent().getResourceAsStream(name)) != null) {
            return stream;
        }
        List<ClassLoader> list = this.alternatives;
        synchronized (list) {
            for (ClassLoader cl : this.alternatives) {
                stream = cl.getResourceAsStream(name);
                if (stream == null) continue;
                return stream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        if (resources.hasMoreElements()) {
            return resources;
        }
        List<ClassLoader> list = this.alternatives;
        synchronized (list) {
            for (ClassLoader cl : this.alternatives) {
                resources = cl.getResources(name);
                if (!resources.hasMoreElements()) continue;
                return resources;
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            List<ClassLoader> list = this.alternatives;
            synchronized (list) {
                for (ClassLoader cl : this.alternatives) {
                    try {
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException e1) {
                    }
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendClassLoader(ClassLoader cl) {
        List<ClassLoader> list = this.alternatives;
        synchronized (list) {
            this.alternatives.add(cl);
        }
    }

    CtClass get(Class<?> type) throws ObjectCompositionException {
        ClassPool cp = this.getClassPool();
        if (type.isPrimitive()) {
            return this.getPrimitive(type);
        }
        try {
            if (type.isArray()) {
                return Descriptor.toCtClass((String)type.getName(), (ClassPool)cp);
            }
            return cp.get(type.getName());
        }
        catch (NotFoundException e) {
            try {
                ClassLoader cl = type.getClassLoader();
                if (cl == null) {
                    throw new ObjectCompositionException(e);
                }
                this.appendClassLoader(cl);
                if (type.isArray()) {
                    return Descriptor.toCtClass((String)type.getName(), (ClassPool)cp);
                }
                return cp.get(type.getName());
            }
            catch (NotFoundException e1) {
                throw new ObjectCompositionException(e);
            }
        }
    }

    private CtClass getPrimitive(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return CtClass.booleanType;
        }
        if (type.equals(Byte.TYPE)) {
            return CtClass.byteType;
        }
        if (type.equals(Character.TYPE)) {
            return CtClass.charType;
        }
        if (type.equals(Double.TYPE)) {
            return CtClass.doubleType;
        }
        if (type.equals(Float.TYPE)) {
            return CtClass.floatType;
        }
        if (type.equals(Integer.TYPE)) {
            return CtClass.intType;
        }
        if (type.equals(Long.TYPE)) {
            return CtClass.longType;
        }
        if (type.equals(Short.TYPE)) {
            return CtClass.shortType;
        }
        if (type.equals(Void.TYPE)) {
            return CtClass.voidType;
        }
        throw new ObjectCompositionException("Unknown primative type: " + type.getName());
    }

    private synchronized ClassPool getClassPool() {
        ClassPool pool;
        ClassPool classPool = pool = this.cp == null ? null : this.cp.get();
        if (pool == null) {
            pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath((ClassLoader)this));
            this.cp = new SoftReference<ClassPool>(pool);
        }
        return pool;
    }

    private Class<?> defineClass(String name, byte[] bytecode) {
        String resource = name.replace('.', '/') + ".class";
        this.saveResource(resource, bytecode);
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResource(String fileName, byte[] bytecode) {
        try {
            File file = new File(this.output, fileName);
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(bytecode);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    Class<?> getJavaClass(CtClass cc) throws ClassNotFoundException {
        if (cc.isPrimitive()) {
            if (cc.equals(CtClass.booleanType)) {
                return Boolean.TYPE;
            }
            if (cc.equals(CtClass.byteType)) {
                return Byte.TYPE;
            }
            if (cc.equals(CtClass.charType)) {
                return Character.TYPE;
            }
            if (cc.equals(CtClass.doubleType)) {
                return Double.TYPE;
            }
            if (cc.equals(CtClass.floatType)) {
                return Float.TYPE;
            }
            if (cc.equals(CtClass.intType)) {
                return Integer.TYPE;
            }
            if (cc.equals(CtClass.longType)) {
                return Long.TYPE;
            }
            if (cc.equals(CtClass.shortType)) {
                return Short.TYPE;
            }
            throw new AssertionError();
        }
        String name = Descriptor.toJavaName((String)Descriptor.toJvmName((CtClass)cc));
        return this.classForName(name);
    }
}

