/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.model.URI;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.helpers.BehaviourConstructor;
import org.openrdf.repository.object.composition.helpers.BehaviourProviderService;
import org.openrdf.repository.object.composition.helpers.ClassComposer;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.PropertyMapper;
import org.openrdf.repository.object.managers.RoleMapper;
import org.openrdf.repository.object.managers.helpers.DirUtil;
import org.openrdf.repository.object.managers.helpers.RoleClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassResolver {
    private static final Set<URI> EMPTY_SET = Collections.emptySet();
    private static final String PKG_PREFIX = "object.proxies._";
    private static final String CLASS_PREFIX = "_EntityProxy";
    private final Logger logger = LoggerFactory.getLogger(ClassResolver.class);
    private final PropertyMapper properties;
    private final ClassFactory cp;
    private final Collection<Class<?>> baseClassRoles;
    private final RoleMapper mapper;
    private final Class<?> blank;
    private final ConcurrentMap<Set<URI>, Class<?>> multiples = new ConcurrentHashMap();
    private final BehaviourProviderService behaviourService;

    private static RoleMapper newRoleMapper(ClassLoader cl) throws ObjectStoreConfigException {
        if (cl == null) {
            return ClassResolver.newRoleMapper(ClassResolver.class.getClassLoader());
        }
        RoleMapper mapper = new RoleMapper();
        new RoleClassLoader(mapper).loadRoles(cl);
        return mapper;
    }

    public ClassResolver() throws ObjectStoreConfigException {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassResolver(ClassLoader cl) throws ObjectStoreConfigException {
        this(ClassResolver.newRoleMapper(cl), cl == null ? ClassResolver.class.getClassLoader() : cl);
    }

    public ClassResolver(RoleMapper mapper, ClassLoader cl) throws ObjectStoreConfigException {
        this(mapper, new PropertyMapper(cl, mapper.isNamedTypePresent()), cl);
    }

    public ClassResolver(RoleMapper mapper, PropertyMapper properties, ClassLoader cl) throws ObjectStoreConfigException {
        this.mapper = mapper;
        this.properties = properties;
        try {
            File dir = DirUtil.createTempDir("classes");
            DirUtil.deleteOnExit(dir);
            this.cp = new ClassFactory(dir, cl);
            this.behaviourService = BehaviourProviderService.newInstance(this.cp);
            Collection<Class<?>> baseClassRoles = mapper.getConceptClasses();
            this.baseClassRoles = new ArrayList(baseClassRoles.size());
            for (Class<?> base : baseClassRoles) {
                try {
                    base.getConstructor(new Class[0]);
                    this.baseClassRoles.add(base);
                }
                catch (NoSuchMethodException e) {
                    this.logger.warn("Concept will only be mergable: {}", base);
                }
            }
            this.blank = this.resolveBlankEntity(EMPTY_SET);
        }
        catch (IOException e) {
            throw new ObjectStoreConfigException(e);
        }
    }

    public RoleMapper getRoleMapper() {
        return this.mapper;
    }

    public PropertyMapper getPropertyMapper() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.cp;
    }

    public Class<?> resolveBlankEntity() {
        return this.blank;
    }

    public Class<?> resolveBlankEntity(Set<URI> types) {
        Class<?> proxy = (Class<?>)this.multiples.get(types);
        if (proxy != null) {
            return proxy;
        }
        ArrayList roles = new ArrayList();
        proxy = this.resolveRoles(this.mapper.findRoles(types, roles));
        this.multiples.putIfAbsent(types, proxy);
        return proxy;
    }

    public Class<?> resolveEntity(URI resource) {
        if (resource != null && this.mapper.isIndividualRolesPresent(resource)) {
            return this.resolveIndividualEntity(resource, EMPTY_SET);
        }
        return this.resolveBlankEntity();
    }

    public Class<?> resolveEntity(URI resource, Set<URI> types) {
        if (resource != null && this.mapper.isIndividualRolesPresent(resource)) {
            return this.resolveIndividualEntity(resource, types);
        }
        return this.resolveBlankEntity(types);
    }

    private Class<?> resolveIndividualEntity(URI resource, Collection<URI> types) {
        Collection<Class<?>> roles = new ArrayList();
        roles = this.mapper.findIndividualRoles(resource, roles);
        roles = this.mapper.findRoles(types, roles);
        return this.resolveRoles(roles);
    }

    private Class<?> resolveRoles(Collection<Class<?>> roles) {
        try {
            String className = this.getJavaClassName(roles);
            return this.getComposedBehaviours(className, roles);
        }
        catch (Exception e) {
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Class<?> f : roles) {
                roleNames.add(f.getSimpleName());
            }
            throw new ObjectCompositionException(e.toString() + " for entity with roles: " + roleNames, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getComposedBehaviours(String className, Collection<Class<?>> roles) throws Exception {
        ClassFactory classFactory = this.cp;
        synchronized (classFactory) {
            try {
                return this.cp.classForName(className);
            }
            catch (ClassNotFoundException e1) {
                return this.composeBehaviours(className, roles);
            }
        }
    }

    private Class<?> composeBehaviours(String className, Collection<Class<?>> roles) throws Exception {
        List<Class<?>> types = new ArrayList(roles.size());
        types.addAll(roles);
        types = this.removeSuperClasses(types);
        ClassComposer cc = new ClassComposer(className, types.size());
        cc.setClassFactory(this.cp);
        LinkedHashSet behaviours = new LinkedHashSet(types.size());
        LinkedHashSet<BehaviourConstructor> concretes = new LinkedHashSet<BehaviourConstructor>(types.size());
        LinkedHashSet bases = new LinkedHashSet();
        Class baseClass = Object.class;
        for (Class<?> role : types) {
            if (role.isInterface()) {
                cc.addInterface(role);
                continue;
            }
            if (this.baseClassRoles.contains(role)) {
                if (baseClass != null && baseClass.isAssignableFrom(role)) {
                    baseClass = role;
                } else if (!role.equals(baseClass)) {
                    baseClass = null;
                }
                bases.add(role);
            } else if (!Modifier.isAbstract(role.getModifiers())) {
                try {
                    concretes.add(new BehaviourConstructor(role));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            behaviours.add(role);
        }
        if (baseClass == null) {
            this.logger.error("Cannot compose multiple concept classes: " + types);
        } else {
            cc.setBaseClass(baseClass);
        }
        HashSet allRoles = new HashSet(behaviours.size() + cc.getInterfaces().size());
        allRoles.addAll(behaviours);
        allRoles.addAll(cc.getInterfaces());
        PropertyMapper pm = this.properties;
        cc.addAllBehaviours(concretes);
        cc.addAllBehaviours(this.behaviourService.findImplementations(pm, allRoles, bases));
        return cc.compose();
    }

    private List<Class<?>> removeSuperClasses(List<Class<?>> classes) {
        block0: for (int i = classes.size() - 1; i >= 0; --i) {
            Class<?> c = classes.get(i);
            for (int j = classes.size() - 1; j >= 0; --j) {
                Class<?> d = classes.get(j);
                if (i == j || !c.isAssignableFrom(d) || c.isInterface() != d.isInterface()) continue;
                classes.remove(i);
                continue block0;
            }
        }
        return classes;
    }

    private String getJavaClassName(Collection<Class<?>> javaClasses) {
        String phex = this.packagesToHexString(javaClasses);
        String chex = this.classesToHexString(javaClasses);
        return PKG_PREFIX + phex + "." + CLASS_PREFIX + chex;
    }

    private String packagesToHexString(Collection<Class<?>> javaClasses) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> clazz : javaClasses) {
            if (clazz.getPackage() == null) continue;
            names.add(clazz.getPackage().getName());
        }
        return this.toHexString(names);
    }

    private String classesToHexString(Collection<Class<?>> javaClasses) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> clazz : javaClasses) {
            names.add(clazz.getName());
        }
        return this.toHexString(names);
    }

    private String toHexString(TreeSet<String> names) {
        long hashCode = 0L;
        for (String name : names) {
            hashCode = 31L * hashCode + (long)name.hashCode();
        }
        return Long.toHexString(hashCode);
    }
}

