/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import org.openrdf.annotations.InstancePrivate;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.CodeBuilder;
import org.openrdf.repository.object.composition.MethodBuilder;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTemplate {
    private Logger logger = LoggerFactory.getLogger(ClassTemplate.class);
    private CodeBuilder cb;
    private CtClass cc;
    private ClassFactory cp;

    protected ClassTemplate(final CtClass cc, ClassFactory cp) {
        this.cc = cc;
        this.cp = cp;
        this.cb = new CodeBuilder(this){

            @Override
            public CodeBuilder end() {
                try {
                    this.semi();
                    cc.makeClassInitializer().insertAfter(this.toString());
                }
                catch (CannotCompileException e) {
                    throw new ObjectCompositionException(e.getMessage() + " for " + this.toString(), e);
                }
                this.clear();
                return this;
            }
        };
    }

    public String getName() {
        return this.cc.getName();
    }

    public void addConstructor(Class<?>[] types, String string) throws ObjectCompositionException {
        try {
            this.logger.trace("public {}({}) {{}}", new Object[]{this.getName(), types, string});
            CtConstructor con = new CtConstructor(this.asCtClassArray(types), this.cc);
            con.setBody("{" + string + "}");
            this.cc.addConstructor(con);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public String toString() {
        return this.cc.getName();
    }

    public void addInterface(Class<?> face) throws ObjectCompositionException {
        this.logger.trace("{} implements {}", (Object)this.getName(), (Object)face.getName());
        this.cc.addInterface(this.get(face));
    }

    public CodeBuilder assignStaticField(final Class<?> type, final String fieldName) throws ObjectCompositionException {
        try {
            CtField field = new CtField(this.get(type), fieldName, this.cc);
            field.setModifiers(9);
            this.cc.addField(field);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        CodeBuilder code = new CodeBuilder(this){

            @Override
            public CodeBuilder end() {
                this.semi();
                String codeString = this.toString();
                ClassTemplate.this.logger.trace("public static {} {} = {}", new Object[]{type.getName(), fieldName, codeString});
                return ClassTemplate.this.cb.code(codeString).end();
            }
        };
        return code.assign(fieldName);
    }

    public void createField(Class<?> type, String fieldName) throws ObjectCompositionException {
        try {
            this.logger.trace("public {} {};", (Object)type.getName(), (Object)fieldName);
            CtField field = new CtField(this.get(type), fieldName, this.cc);
            field.setModifiers(1);
            this.cc.addField(field);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public MethodBuilder createMethod(Class<?> type, String name, Class<?> ... parameters) throws ObjectCompositionException {
        CtClass[] exces = new CtClass[]{this.get(Throwable.class)};
        try {
            CtMethod cm = CtNewMethod.make((CtClass)this.get(type), (String)name, (CtClass[])this.asCtClassArray(parameters), (CtClass[])exces, null, (CtClass)this.cc);
            return this.begin(cm, parameters);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public MethodBuilder createPrivateMethod(Class<?> type, String name, Class<?> ... parameters) throws ObjectCompositionException {
        CtClass[] exces = new CtClass[]{this.get(Throwable.class)};
        try {
            CtMethod cm = CtNewMethod.make((int)2, (CtClass)this.get(type), (String)name, (CtClass[])this.asCtClassArray(parameters), (CtClass[])exces, null, (CtClass)this.cc);
            return this.begin(cm, parameters);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public void copyAnnotationsFrom(Class<?> c) {
        ClassFile cf = this.get(c).getClassFile();
        AnnotationsAttribute ai = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (ai != null && ai.getAnnotations().length > 0) {
            ClassFile info = this.cc.getClassFile();
            info.addAttribute(ai.copy(info.getConstPool(), Collections.EMPTY_MAP));
        }
    }

    public void addAnnotation(Class<?> type, Class<?> ... values) {
        ClassFile cf = this.cc.getClassFile();
        ConstPool cp = cf.getConstPool();
        ClassMemberValue[] elements = new ClassMemberValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            elements[i] = this.cb.createClassMemberValue(values[i], cp);
        }
        ArrayMemberValue value = new ArrayMemberValue(cp);
        value.setValue((MemberValue[])elements);
        AnnotationsAttribute ai = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (ai == null) {
            ai = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            cf.addAttribute((AttributeInfo)ai);
        }
        try {
            Annotation annotation = new Annotation(cp, this.get(type));
            annotation.addMemberValue("value", (MemberValue)value);
            ai.addAnnotation(annotation);
        }
        catch (NotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public MethodBuilder copyMethod(Method method, String name, boolean bridge) throws ObjectCompositionException {
        try {
            CtClass[] parameters = this.asCtClassArray(this.getParameterTypes(method));
            CtClass[] exces = new CtClass[]{this.get(Throwable.class)};
            CtMethod cm = CtNewMethod.make((CtClass)this.get(method.getReturnType()), (String)name, (CtClass[])parameters, (CtClass[])exces, null, (CtClass)this.cc);
            MethodInfo info = cm.getMethodInfo();
            this.copyAttributes(method, info);
            if (bridge) {
                info.setAccessFlags(info.getAccessFlags() | 0x40);
            }
            return this.begin(cm, this.getParameterTypes(method));
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public MethodBuilder createInstancePrivateMethod(Method method) throws ObjectCompositionException {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] parameters = this.getParameterTypes(method);
        CtClass[] exces = new CtClass[]{this.get(Throwable.class)};
        try {
            CtMethod cm = CtNewMethod.make((CtClass)this.get(type), (String)name, (CtClass[])this.asCtClassArray(parameters), (CtClass[])exces, null, (CtClass)this.cc);
            MethodInfo info = cm.getMethodInfo();
            this.copyAttributes(method, info);
            info.setAccessFlags(info.getAccessFlags() | 0x40);
            ConstPool cp = info.getConstPool();
            AnnotationsAttribute ai = (AnnotationsAttribute)info.getAttribute("RuntimeVisibleAnnotations");
            if (ai == null) {
                ai = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
                info.addAttribute((AttributeInfo)ai);
            }
            try {
                ai.addAnnotation(new Annotation(cp, this.get(InstancePrivate.class)));
            }
            catch (NotFoundException e) {
                throw new AssertionError((Object)e);
            }
            return this.begin(cm, parameters);
        }
        catch (CannotCompileException e) {
            throw new ObjectCompositionException(e);
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public CodeBuilder getCodeBuilder() {
        return this.cb;
    }

    public CtClass getCtClass() {
        return this.cc;
    }

    public Set<String> getDeclaredFieldNames() {
        CtField[] fields = this.cc.getDeclaredFields();
        HashSet<String> result = new HashSet<String>(fields.length);
        for (CtField field : fields) {
            result.add(field.getName());
        }
        return result;
    }

    public Class<?> getSuperclass() {
        try {
            return this.cp.getJavaClass(this.cc.getSuperclass());
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public Class<?>[] getInterfaces() throws ObjectCompositionException {
        try {
            CtClass[] cc1 = this.cc.getInterfaces();
            Class[] result = new Class[cc1.length];
            for (int i = 0; i < cc1.length; ++i) {
                result[i] = this.cp.getJavaClass(cc1[i]);
            }
            return result;
        }
        catch (NotFoundException e) {
            throw new ObjectCompositionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectCompositionException(e);
        }
    }

    public MethodBuilder overrideMethod(Method method, boolean bridge) throws ObjectCompositionException {
        return this.copyMethod(method, method.getName(), bridge);
    }

    public Set<Field> getFieldsRead(Method method) throws NotFoundException {
        String name = method.getName();
        CtClass[] parameters = this.asCtClassArray(this.getParameterTypes(method));
        HashSet<CtMethod> methods = new HashSet<CtMethod>();
        final HashSet<Field> accessed = new HashSet<Field>();
        for (CtMethod cm : this.cc.getMethods()) {
            if (!this.equals(cm, name, parameters)) continue;
            this.findMethodCalls(cm, methods);
        }
        for (CtMethod cm : methods) {
            try {
                cm.instrument(new ExprEditor(){

                    public void edit(FieldAccess f) {
                        try {
                            if (f.isReader()) {
                                CtField field = f.getField();
                                String name = field.getName();
                                String dname = field.getDeclaringClass().getName();
                                Class<?> declared = ClassTemplate.this.cp.loadClass(dname);
                                accessed.add(declared.getDeclaredField(name));
                            }
                        }
                        catch (RuntimeException exc) {
                            throw exc;
                        }
                        catch (Exception exc) {
                            ClassTemplate.this.logger.warn(exc.toString(), (Throwable)exc);
                        }
                    }
                });
            }
            catch (CannotCompileException e) {
                throw new AssertionError((Object)e);
            }
        }
        return accessed;
    }

    public Set<Field> getFieldsWritten(Method method) throws NotFoundException {
        String name = method.getName();
        CtClass[] parameters = this.asCtClassArray(this.getParameterTypes(method));
        HashSet<CtMethod> methods = new HashSet<CtMethod>();
        final HashSet<Field> accessed = new HashSet<Field>();
        for (CtMethod cm : this.cc.getMethods()) {
            if (!this.equals(cm, name, parameters)) continue;
            this.findMethodCalls(cm, methods);
        }
        for (CtMethod cm : methods) {
            try {
                cm.instrument(new ExprEditor(){

                    public void edit(FieldAccess f) {
                        try {
                            if (f.isWriter()) {
                                CtField field = f.getField();
                                String name = field.getName();
                                String dname = field.getDeclaringClass().getName();
                                Class<?> declared = ClassTemplate.this.cp.loadClass(dname);
                                accessed.add(declared.getDeclaredField(name));
                            }
                        }
                        catch (RuntimeException exc) {
                            throw exc;
                        }
                        catch (Exception exc) {
                            ClassTemplate.this.logger.warn(exc.toString(), (Throwable)exc);
                        }
                    }
                });
            }
            catch (CannotCompileException e) {
                throw new AssertionError((Object)e);
            }
        }
        return accessed;
    }

    CtClass get(Class<?> type) throws ObjectCompositionException {
        return this.cp.get(type);
    }

    private Set<CtMethod> getAll(Method method) throws NotFoundException {
        HashSet<CtMethod> result = new HashSet<CtMethod>();
        String name = method.getName();
        CtClass[] parameters = this.asCtClassArray(this.getParameterTypes(method));
        for (CtMethod cm : this.get(method.getDeclaringClass()).getDeclaredMethods()) {
            if (!this.equals(cm, name, parameters)) continue;
            result.add(cm);
        }
        return result;
    }

    private Class<?>[] getParameterTypes(Method method) {
        if (method.isAnnotationPresent(ParameterTypes.class)) {
            return method.getAnnotation(ParameterTypes.class).value();
        }
        return method.getParameterTypes();
    }

    private boolean equals(CtMethod cm, String name, CtClass[] parameters) throws NotFoundException {
        if (!cm.getName().equals(name)) {
            return false;
        }
        if (Arrays.equals(cm.getParameterTypes(), parameters)) {
            return true;
        }
        if (cm.getParameterTypes().length != 1) {
            return false;
        }
        MethodInfo mi = cm.getMethodInfo();
        AnnotationsAttribute ainfo = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (ainfo == null) {
            return false;
        }
        Annotation[] anno = ainfo.getAnnotations();
        if (anno == null) {
            return false;
        }
        String typeName = ParameterTypes.class.getName();
        for (int i = 0; i < anno.length; ++i) {
            if (!anno[i].getTypeName().equals(typeName)) continue;
            ArrayMemberValue mv = (ArrayMemberValue)anno[i].getMemberValue("value");
            MemberValue[] mvalues = mv.getValue();
            if (mvalues.length != parameters.length) {
                return false;
            }
            for (int j = 0; j < mvalues.length; ++j) {
                ClassMemberValue cmv = (ClassMemberValue)mvalues[j];
                if (parameters[j].getName().equals(cmv.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void findMethodCalls(CtMethod cm, final Set<CtMethod> methods) {
        if (methods.add(cm)) {
            try {
                cm.instrument(new ExprEditor(){

                    public void edit(MethodCall m) {
                        try {
                            CtClass enclosing = m.getEnclosingClass();
                            String className = m.getClassName();
                            if (this.isAssignableFrom(className, enclosing)) {
                                ClassTemplate.this.findMethodCalls(m.getMethod(), methods);
                            }
                        }
                        catch (NotFoundException e) {
                            ClassTemplate.this.logger.warn(e.toString(), (Throwable)e);
                        }
                    }

                    private boolean isAssignableFrom(String className, CtClass enclosing) throws NotFoundException {
                        if (enclosing == null) {
                            return false;
                        }
                        if (className.equals(enclosing.getName())) {
                            return true;
                        }
                        return this.isAssignableFrom(className, enclosing.getSuperclass());
                    }
                });
            }
            catch (CannotCompileException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void copyAttributes(Method method, MethodInfo info) throws NotFoundException {
        this.copyMethodAnnotations(method, info);
        this.copyParameterAnnotations(method, info);
        this.copyMethodSignature(method, info);
    }

    private void copyMethodAnnotations(Method method, MethodInfo info) throws NotFoundException {
        for (CtMethod e : this.getAll(method)) {
            MethodInfo em = e.getMethodInfo();
            AnnotationsAttribute ai = (AnnotationsAttribute)em.getAttribute("RuntimeVisibleAnnotations");
            if (ai == null || ai.getAnnotations().length <= 0) continue;
            info.addAttribute(ai.copy(info.getConstPool(), Collections.EMPTY_MAP));
            break;
        }
    }

    private void copyParameterAnnotations(Method method, MethodInfo info) throws NotFoundException {
        for (CtMethod e : this.getAll(method)) {
            MethodInfo em = e.getMethodInfo();
            ParameterAnnotationsAttribute ai = (ParameterAnnotationsAttribute)em.getAttribute("RuntimeVisibleParameterAnnotations");
            if (ai == null) continue;
            Annotation[][] anns = ai.getAnnotations();
            int n = anns.length;
            for (int i = 0; i < n; ++i) {
                if (anns[i].length <= 0) continue;
                info.addAttribute(ai.copy(info.getConstPool(), Collections.EMPTY_MAP));
                return;
            }
        }
    }

    private void copyMethodSignature(Method method, MethodInfo info) throws NotFoundException {
        for (CtMethod e : this.getAll(method)) {
            MethodInfo em = e.getMethodInfo();
            SignatureAttribute sa = (SignatureAttribute)em.getAttribute("Signature");
            if (sa == null || sa.getSignature() == null) continue;
            info.addAttribute(sa.copy(info.getConstPool(), Collections.EMPTY_MAP));
            break;
        }
    }

    private CtClass[] asCtClassArray(Class<?>[] cc) throws NotFoundException {
        CtClass[] result = new CtClass[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            result[i] = this.get(cc[i]);
        }
        return result;
    }

    private MethodBuilder begin(CtMethod cm, Class<?> ... parameters) {
        return new MethodBuilder(this, cm);
    }
}

