/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.ClassMemberValue;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;

public abstract class CodeBuilder {
    private StringBuilder body = new StringBuilder();
    private ClassTemplate klass;
    private Map<String, Map<List<Class<?>>, String>> methodTemplateVars = new HashMap();
    private Map<Method, String> methodVars = new HashMap<Method, String>();
    private int varCounter;

    protected CodeBuilder(ClassTemplate klass) {
        this.klass = klass;
    }

    public CodeBuilder assign(String var) {
        this.body.append(var).append(" = ");
        return this;
    }

    public CodeBuilder castObject(Class<?> type) {
        this.body.append("(");
        if (type.isPrimitive()) {
            this.body.append(this.getPrimitiveWrapper(type)).append(")");
        } else {
            this.body.append(this.getJavaClassCodeNameOf(type)).append(")");
        }
        return this;
    }

    public CodeBuilder valueOf(Class<?> type) {
        if (type.isPrimitive()) {
            this.body.append(this.getPrimitiveWrapper(type)).append(".valueOf");
        } else {
            this.body.append("(");
            this.body.append(this.getJavaClassCodeNameOf(type)).append(")");
        }
        return this;
    }

    public CodeBuilder cast(Class<?> type) {
        this.body.append("(");
        this.body.append(this.getJavaClassCodeNameOf(type)).append(")");
        return this;
    }

    public CodeBuilder code(String str) {
        this.body.append(str);
        return this;
    }

    public CodeBuilder codeInstanceof(String field, Class<?> type) {
        this.body.append(field).append(" instanceof ");
        this.body.append(this.getJavaClassCodeNameOf(type));
        return this;
    }

    public CodeBuilder codeObject(String field, Class<?> type) {
        if (type.isPrimitive()) {
            this.body.append(this.getPrimitiveWrapper(type));
            this.body.append(".valueOf(").append(field).append(")");
        } else {
            this.body.append(field);
        }
        return this;
    }

    public CodeBuilder construct(Class<?> javaClass, Object ... args) {
        this.body.append("new ").append(javaClass.getName()).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.code(",");
            }
            this.insert(args[i]);
        }
        this.body.append(")");
        return this;
    }

    public CodeBuilder staticInvoke(Method method, Object ... args) {
        this.code(method.getDeclaringClass().getName());
        this.code(".").code(method.getName()).code("(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                this.code(",");
            }
            this.insert(args[i]);
        }
        this.code(")");
        return this;
    }

    public CodeBuilder declareObject(Class<?> type, String var) {
        this.code(this.getJavaClassCodeNameOf(type));
        return this.code(" ").assign(var);
    }

    public CodeBuilder declareWrapper(Class<?> type, String var) {
        if (type.isPrimitive()) {
            this.code(this.getPrimitiveWrapper(type));
        } else {
            this.code(this.getJavaClassCodeNameOf(type));
        }
        return this.code(" ").assign(var);
    }

    public abstract CodeBuilder end();

    public CodeBuilder insert(boolean b) {
        this.body.append(b);
        return this;
    }

    public CodeBuilder insert(char c) {
        this.body.append("'").append(c).append("'");
        return this;
    }

    public CodeBuilder insert(Class<?> javaClass) {
        return this.insert(this.klass.get(javaClass));
    }

    public CodeBuilder insertObjectClass(String className) {
        this.body.append(ClassFactory.class.getName());
        this.body.append(".classForName(\"");
        this.body.append(className);
        this.body.append("\", ").append(Class.class.getName());
        this.body.append(".forName(\"").append(this.klass.getName()).append("\")");
        this.body.append(".getClassLoader())");
        return this;
    }

    public CodeBuilder insert(double d) {
        this.body.append(d);
        return this;
    }

    public CodeBuilder insert(float f) {
        this.body.append(f);
        return this;
    }

    public CodeBuilder insert(int i) {
        this.body.append(i);
        return this;
    }

    public CodeBuilder insert(long lng) {
        this.body.append(lng);
        return this;
    }

    public CodeBuilder insert(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        CodeBuilder cb = this.klass.getCodeBuilder();
        String var = cb.methodVars.get(method);
        if (var != null) {
            this.body.append(var);
            return this;
        }
        var = cb.getVarName("Method");
        String before = this.toString();
        this.clear();
        String parameterTypes = this.declareVar(params, cb);
        CodeBuilder field = this.klass.assignStaticField(Method.class, var);
        field.insert(declaringClass);
        field.code(".getDeclaredMethod(").insert(name);
        field.code(", ").code(parameterTypes).code(")").end();
        cb.methodVars.put(method, var);
        this.code(before);
        this.body.append(var);
        return this;
    }

    public CodeBuilder insert(Object o) {
        if (o == null) {
            this.body.append("null");
        } else {
            this.visit(o, o.getClass());
        }
        return this;
    }

    public CodeBuilder insert(String str) {
        if (str == null) {
            this.body.append("null");
        } else {
            this.body.append("\"").append(str).append("\"");
        }
        return this;
    }

    public CodeBuilder insert(Class<?>[] params) {
        CodeBuilder cb = this.klass.getCodeBuilder();
        String parameterTypes = this.declareVar(params, cb);
        String var = cb.getVarName("Classes");
        CodeBuilder field = this.klass.assignStaticField(params.getClass(), var);
        field.code(parameterTypes).end();
        this.body.append(var);
        return this;
    }

    public CodeBuilder insertMethod(String name, Class<?>[] params) {
        CtClass cc = this.klass.getCtClass();
        String className = Descriptor.toJavaName((String)Descriptor.toJvmName((CtClass)cc));
        List<Class<?>> list = Arrays.asList(params);
        CodeBuilder cb = this.klass.getCodeBuilder();
        Map<List<Class<?>>, String> map = cb.methodTemplateVars.get(name);
        if (map == null) {
            map = new HashMap();
            cb.methodTemplateVars.put(name, map);
        } else if (map.containsKey(list)) {
            this.body.append(map.get(list));
            return this;
        }
        String parameterTypes = this.declareVar(params, cb);
        String var = cb.getVarName("Method");
        CodeBuilder field = this.klass.assignStaticField(Method.class, var);
        field.insertObjectClass(className);
        field.code(".getDeclaredMethod(").insert(name);
        field.code(", ").code(parameterTypes).code(")").end();
        map.put(list, var);
        this.body.append(var);
        return this;
    }

    public int length() {
        return this.body.length();
    }

    public CodeBuilder semi() {
        this.body.append(";\n");
        return this;
    }

    public String toString() {
        return this.body.toString();
    }

    protected void clear() {
        this.body.delete(0, this.length());
    }

    protected ClassMemberValue createClassMemberValue(Class<?> type, ConstPool cp) {
        int idx = cp.addUtf8Info(CodeBuilder.descriptor(type));
        return new ClassMemberValue(idx, cp);
    }

    public static String descriptor(Class<?> type) {
        if (type.isArray()) {
            return "[" + CodeBuilder.descriptor(type.getComponentType());
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    private String declareVar(Class<?>[] classes, CodeBuilder cb) {
        String var = cb.getVarName("Classes");
        cb.code("java.lang.Class[] ").code(var);
        cb.code(" = ").code("new java.lang.Class[");
        cb.insert(classes.length).code("]").code(";\n");
        for (int i = 0; i < classes.length; ++i) {
            cb.code(var).code("[").insert(i).code("]");
            cb.code(" = ");
            cb.insert(classes[i]);
            cb.code(";\n");
        }
        return var;
    }

    private String getJavaClassCodeNameOf(Class<?> type) {
        return this.klass.get(type).getName();
    }

    private Class<?> getPrimitiveJavaClassWrapper(CtClass cc) {
        if (cc.equals(CtClass.booleanType)) {
            return Boolean.class;
        }
        if (cc.equals(CtClass.byteType)) {
            return Byte.class;
        }
        if (cc.equals(CtClass.charType)) {
            return Character.class;
        }
        if (cc.equals(CtClass.doubleType)) {
            return Double.class;
        }
        if (cc.equals(CtClass.floatType)) {
            return Float.class;
        }
        if (cc.equals(CtClass.intType)) {
            return Integer.class;
        }
        if (cc.equals(CtClass.longType)) {
            return Long.class;
        }
        if (cc.equals(CtClass.shortType)) {
            return Short.class;
        }
        throw new AssertionError();
    }

    private String getPrimitiveWrapper(Class<?> type) {
        String wrap;
        if (Boolean.TYPE.equals(type)) {
            wrap = Boolean.class.getName();
        } else if (Character.TYPE.equals(type)) {
            wrap = Character.class.getName();
        } else if (Integer.TYPE.equals(type)) {
            wrap = Integer.class.getName();
        } else {
            String prim = type.getName();
            wrap = Character.toUpperCase(prim.charAt(0)) + prim.substring(1);
        }
        return wrap;
    }

    private String getVarName(String type) {
        return "_$" + type + this.varCounter++;
    }

    private CodeBuilder insert(CtClass cc) {
        if (cc.isPrimitive()) {
            this.body.append(this.getPrimitiveJavaClassWrapper(cc).getName()).append(".TYPE");
            return this;
        }
        return this.insertObjectClass(Descriptor.toJavaName((String)Descriptor.toJvmName((CtClass)cc)));
    }

    private boolean visit(Object o, Class oc) {
        try {
            Class<?> c = this.getClass();
            Class[] args = new Class[]{oc};
            Method m = c.getMethod("insert", args);
            m.invoke((Object)this, o);
            return true;
        }
        catch (NoSuchMethodException e) {
            Class sc = oc.getSuperclass();
            if (sc != null && !Object.class.equals(sc) && this.visit(o, sc)) {
                return true;
            }
            for (Class<?> face : oc.getInterfaces()) {
                if (!this.visit(o, face)) continue;
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            throw new ObjectCompositionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCompositionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectCompositionException(e);
        }
    }
}

