/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition;

import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.composition.CodeBuilder;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodBuilder
extends CodeBuilder {
    private final Logger logger = LoggerFactory.getLogger(MethodBuilder.class);
    private ClassTemplate klass;
    private CtMethod cm;

    protected MethodBuilder(ClassTemplate klass, CtMethod cm) {
        super(klass);
        this.klass = klass;
        this.cm = cm;
        this.code("{");
    }

    public MethodBuilder ann(Class<?> type, Class<?> ... values) {
        MethodInfo info = this.cm.getMethodInfo();
        ConstPool cp = info.getConstPool();
        ClassMemberValue[] elements = new ClassMemberValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            elements[i] = this.createClassMemberValue(values[i], cp);
        }
        ArrayMemberValue value = new ArrayMemberValue(cp);
        value.setValue((MemberValue[])elements);
        AnnotationsAttribute ai = (AnnotationsAttribute)info.getAttribute("RuntimeVisibleAnnotations");
        if (ai == null) {
            ai = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            info.addAttribute((AttributeInfo)ai);
        }
        try {
            Annotation annotation = new Annotation(cp, this.klass.get(type));
            annotation.addMemberValue("value", (MemberValue)value);
            ai.addAnnotation(annotation);
        }
        catch (NotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    @Override
    public CodeBuilder end() {
        this.code("}");
        CtClass cc = this.cm.getDeclaringClass();
        String body = this.toString();
        try {
            int mod = this.cm.getModifiers();
            mod = Modifier.clear((int)mod, (int)1024);
            mod = Modifier.clear((int)mod, (int)256);
            this.cm.setModifiers(mod);
            this.cm.setBody(body);
            cc.addMethod(this.cm);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("public {} {}({}) {{}}", new Object[]{this.cm.getReturnType().getName(), this.cm.getName(), this.cm.getParameterTypes(), body});
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            try {
                for (CtClass inter : cc.getInterfaces()) {
                    sb.append(inter.getSimpleName()).append(" ");
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            String sn = cc.getSimpleName();
            System.err.println(sn + " implements " + sb);
            throw new ObjectCompositionException(e.getMessage() + " for " + body, e);
        }
        this.clear();
        return this;
    }
}

