/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.annotations.InstancePrivate;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.annotations.Precedes;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;

public class BehaviourConstructor
implements BehaviourFactory {
    private static Set<String> special = new HashSet<String>(Arrays.asList("groovy.lang.GroovyObject", RDFObjectBehaviour.class.getName()));
    private final Class<?> behaviourClass;
    private final Constructor<?> constructor;

    public BehaviourConstructor(Class<?> behaviourClass) throws NoSuchMethodException {
        Constructor<?> constructor;
        this.behaviourClass = behaviourClass;
        try {
            constructor = behaviourClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = behaviourClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException exc) {
                String msg = exc.getMessage() + " no default constructor in " + behaviourClass;
                throw new NoSuchMethodException(msg);
            }
        }
        this.constructor = constructor;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getBehaviourType().getSimpleName();
    }

    @Override
    public Class<?> getBehaviourType() {
        return this.behaviourClass;
    }

    @Override
    public Class<?>[] getInterfaces() {
        LinkedHashSet interfaces = new LinkedHashSet();
        this.addInterfaces(this.behaviourClass, interfaces);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    @Override
    public boolean precedes(Method in, BehaviourFactory factory, Method to) {
        if (in.isAnnotationPresent(ParameterTypes.class) && !to.isAnnotationPresent(ParameterTypes.class)) {
            return true;
        }
        if (!in.isAnnotationPresent(ParameterTypes.class) && to.isAnnotationPresent(ParameterTypes.class)) {
            return false;
        }
        return this.overrides(this.getBehaviourType(), factory.getBehaviourType(), false, new HashSet());
    }

    @Override
    public Method[] getMethods() {
        return this.behaviourClass.getMethods();
    }

    @Override
    public Method getInvocation(Method method) {
        Object[] types = this.getParameterTypes(method);
        try {
            Method m = this.behaviourClass.getMethod(method.getName(), (Class<?>[])types);
            if (!this.isSpecial(m)) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Method m : this.behaviourClass.getMethods()) {
            ParameterTypes ann;
            if (!m.getName().equals(method.getName()) || (ann = m.getAnnotation(ParameterTypes.class)) == null || !Arrays.equals(ann.value(), types) || this.isSpecial(m)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Object getSingleton() {
        return null;
    }

    @Override
    public Object newInstance(Object composed) throws Throwable {
        try {
            if (this.constructor.getParameterTypes().length == 0) {
                return this.constructor.newInstance(new Object[0]);
            }
            return this.constructor.newInstance(composed);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.toString());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public int hashCode() {
        return this.behaviourClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BehaviourConstructor other = (BehaviourConstructor)obj;
        return this.behaviourClass.equals(other.behaviourClass);
    }

    private Class<?>[] getParameterTypes(Method m) {
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return m.getAnnotation(ParameterTypes.class).value();
        }
        return m.getParameterTypes();
    }

    private boolean isSpecial(Method m) {
        if (this.isObjectMethod(m)) {
            return true;
        }
        if ("methodMissing".equals(m.getName())) {
            return true;
        }
        if ("propertyMissing".equals(m.getName())) {
            return true;
        }
        return m.isAnnotationPresent(InstancePrivate.class);
    }

    private boolean isObjectMethod(Method m) {
        return m.getDeclaringClass().getName().equals(Object.class.getName());
    }

    private boolean overrides(Class<?> a, Class<?> b, boolean explicit, Collection<Class<?>> exclude) {
        Class<?>[] values;
        if (b.equals(a)) {
            return false;
        }
        if (exclude.contains(a)) {
            return false;
        }
        exclude.add(a);
        Precedes ann = a.getAnnotation(Precedes.class);
        if (ann == null) {
            return false;
        }
        for (Class<?> c : values = ann.value()) {
            if (c.equals(b)) {
                return true;
            }
            if (c.isAssignableFrom(b)) {
                return explicit || !this.overrides(b, c, true, new HashSet());
            }
            if (!this.overrides(c, b, explicit, exclude)) continue;
            return explicit || !this.overrides(b, c, true, new HashSet());
        }
        return false;
    }

    private void addInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        Class<?> superclass;
        if (interfaces.contains(clazz)) {
            return;
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            this.addInterfaces(superclass, interfaces);
        }
        for (Class<?> face : clazz.getInterfaces()) {
            if (!Modifier.isPublic(face.getModifiers()) || this.isSpecial(face)) continue;
            this.addInterfaces(face, interfaces);
        }
    }

    private boolean isSpecial(Class<?> face) {
        return special.contains(face.getName());
    }
}

