/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition.helpers;

import java.lang.reflect.Method;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.annotations.Precedes;
import org.openrdf.repository.object.advice.Advice;
import org.openrdf.repository.object.composition.BehaviourFactory;

public class BehaviourMethod {
    private final BehaviourFactory factory;
    private final Method method;

    public BehaviourMethod(BehaviourFactory behaviour, Method method) {
        assert (behaviour != null);
        assert (method != null);
        this.factory = behaviour;
        this.method = method;
    }

    public BehaviourFactory getFactory() {
        return this.factory;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isMessage() {
        return this.method.isAnnotationPresent(ParameterTypes.class) || this.method.getDeclaringClass().equals(Advice.class);
    }

    public boolean isEmptyOverridesPresent() {
        Precedes ann = this.factory.getBehaviourType().getAnnotation(Precedes.class);
        if (ann == null) {
            return false;
        }
        Class<?>[] values = ann.value();
        return values != null && values.length == 0;
    }

    public boolean precedes(BehaviourMethod b1) {
        return this.factory.precedes(this.getMethod(), b1.getFactory(), b1.getMethod());
    }

    public String toString() {
        return this.factory.toString();
    }
}

