/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.Set;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.composition.BehaviourProvider;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.managers.PropertyMapper;

public class BehaviourProviderService {
    private final ServiceLoader<BehaviourProvider> loader;
    private final ClassFactory cl;

    public static BehaviourProviderService newInstance(ClassFactory cl) {
        return new BehaviourProviderService(cl);
    }

    public BehaviourProviderService(ClassFactory cl) {
        this.cl = cl;
        this.loader = ServiceLoader.load(BehaviourProvider.class, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BehaviourFactory> findImplementations(PropertyMapper mapper, Collection<Class<?>> classes, Set<Class<?>> bases) throws IOException {
        ArrayList<BehaviourFactory> implementations = new ArrayList<BehaviourFactory>();
        ServiceLoader<BehaviourProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            for (BehaviourProvider bf : this.loader) {
                bf.setClassDefiner(this.cl);
                bf.setPropertyMapper(mapper);
                bf.setBaseClasses(bases);
                implementations.addAll(bf.getBehaviourFactories(classes));
            }
        }
        return implementations;
    }
}

