/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.annotations.InstancePrivate;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.object.composition.BehaviourFactory;
import org.openrdf.repository.object.composition.ClassFactory;
import org.openrdf.repository.object.composition.ClassTemplate;
import org.openrdf.repository.object.composition.CodeBuilder;
import org.openrdf.repository.object.composition.MethodBuilder;
import org.openrdf.repository.object.composition.helpers.BehaviourMethod;
import org.openrdf.repository.object.composition.helpers.InvocationMessageContext;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassComposer {
    private static int count;
    private static Set<String> special;
    private static Logger logger;
    private ClassFactory cp;
    private final String className;
    private Class<?> baseClass = Object.class;
    private final Set<Class<?>> interfaces;
    private final Set<BehaviourFactory> allBehaviours;
    private Collection<Method> methods;
    private Map<String, Method> namedMethods;
    private Map<Method, String> superMethods = new HashMap<Method, String>();
    private Map<String, Set<BehaviourFactory>> behaviours;
    private ClassTemplate cc;

    public static void calling(Object target, String method, Object[] args) {
        Throwable stack;
        StackTraceElement[] trace;
        if (++count % 512 == 0 && (trace = (stack = new Throwable()).getStackTrace()).length > 512) {
            String string = Arrays.asList(args).toString();
            String substring = string.substring(1, string.length() - 1);
            logger.warn(target + "<-" + method + "(" + substring + ")", stack);
        }
    }

    public ClassComposer(String className, int size) {
        this.className = className;
        this.interfaces = new LinkedHashSet(size);
        this.allBehaviours = new LinkedHashSet<BehaviourFactory>(size);
    }

    public void setClassFactory(ClassFactory cp) {
        this.cp = cp;
    }

    public void setBaseClass(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    public Set<Class<?>> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add(iface);
    }

    public void addAllBehaviours(Collection<? extends BehaviourFactory> factories) {
        this.allBehaviours.addAll(factories);
    }

    public Class<?> compose() throws Exception {
        logger.trace("public class {} extends {}", (Object)this.className, this.baseClass);
        this.cc = this.cp.createClassTemplate(this.className, this.baseClass);
        for (BehaviourFactory behaviourFactory : this.allBehaviours) {
            for (Class<?> clazz : behaviourFactory.getInterfaces()) {
                this.addInterfaces(clazz);
            }
        }
        for (Class clazz : this.interfaces) {
            this.cc.addInterface(clazz);
        }
        this.behaviours = new HashMap<String, Set<BehaviourFactory>>();
        for (BehaviourFactory behaviourFactory : this.allBehaviours) {
            this.addBehaviour(behaviourFactory);
            for (Method method : behaviourFactory.getMethods()) {
                if (this.isSpecial(method)) continue;
                Set<BehaviourFactory> s = this.behaviours.get(method.getName());
                if (s == null) {
                    s = new HashSet<BehaviourFactory>();
                    this.behaviours.put(method.getName(), s);
                }
                s.add(behaviourFactory);
            }
        }
        Collection<Method> all = this.getAllMethods();
        this.methods = this.getUniqueMethods(all);
        this.namedMethods = this.getNamedMethods(all);
        for (Method method : this.methods) {
            if (method.getName().startsWith("_$")) continue;
            boolean bridge = this.isBridge(method, this.methods);
            this.implementMethod(method, method.getName(), bridge);
        }
        try {
            Class<?> clazz = this.cp.createClass(this.cc);
            for (BehaviourFactory clazz2 : this.allBehaviours) {
                this.populateBehaviourField(clazz2, clazz);
            }
            return clazz;
        }
        catch (LinkageError linkageError) {
            String string = linkageError.getMessage() + " while composing " + this.baseClass.getSimpleName() + " with " + this.interfaces;
            LinkageError error = new LinkageError(string);
            error.initCause(linkageError);
            throw error;
        }
    }

    private void addInterfaces(Class<?> clazz) {
        Class<?> superclass;
        if (this.interfaces.contains(clazz)) {
            return;
        }
        if (clazz.isInterface()) {
            this.interfaces.add(clazz);
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            this.addInterfaces(superclass);
        }
        for (Class<?> face : clazz.getInterfaces()) {
            if (!Modifier.isPublic(face.getModifiers()) || this.isSpecial(face)) continue;
            this.addInterfaces(face);
        }
    }

    private boolean isSpecial(Class<?> face) {
        return special.contains(face.getName());
    }

    private Collection<Method> getAllMethods() {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> jc : this.interfaces) {
            for (Method m : jc.getMethods()) {
                if (this.isSpecial(m)) continue;
                methods.add(m);
            }
        }
        for (BehaviourFactory factory : this.allBehaviours) {
            for (Method m : factory.getMethods()) {
                if (this.isSpecial(m)) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    private Collection<Method> getUniqueMethods(Collection<Method> methods) {
        HashMap map = new HashMap(methods.size());
        for (Method m : methods) {
            Class<?>[] ptypes = this.getParameterTypes(m);
            ArrayList<Object> list = new ArrayList<Object>(ptypes.length + 2);
            list.add(m.getName());
            list.add(m.getReturnType());
            list.addAll(Arrays.asList(ptypes));
            if (map.containsKey(list)) {
                if (this.getRank(m) <= this.getRank((Method)map.get(list))) continue;
                map.put(list, m);
                continue;
            }
            map.put(list, m);
        }
        return map.values();
    }

    private Map<String, Method> getNamedMethods(Collection<Method> all) {
        HashMap<String, Method> namedMethods = new HashMap<String, Method>(all.size());
        for (Method method : all) {
            String uri;
            if (!method.isAnnotationPresent(Iri.class) || namedMethods.containsKey(uri = method.getAnnotation(Iri.class).value()) && this.isBridge(method, this.methods)) continue;
            namedMethods.put(uri, method);
        }
        return namedMethods;
    }

    private int getRank(Method m) {
        int rank = m.getAnnotations().length;
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return rank - 2;
        }
        return rank;
    }

    private boolean isSpecial(Method m) {
        if (this.isObjectMethod(m)) {
            return true;
        }
        if ("methodMissing".equals(m.getName())) {
            return true;
        }
        if ("propertyMissing".equals(m.getName())) {
            return true;
        }
        return m.isAnnotationPresent(InstancePrivate.class);
    }

    private Class<?>[] getParameterTypes(Method m) {
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return m.getAnnotation(ParameterTypes.class).value();
        }
        return m.getParameterTypes();
    }

    private boolean isBridge(Method method, Collection<Method> methods) {
        for (Method m : methods) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(this.getParameterTypes(m), this.getParameterTypes(method)) || m.getReturnType().isAssignableFrom(method.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private boolean implementMethod(Method method, String name, boolean bridge) throws Exception {
        List<BehaviourMethod> chain = this.chain(method);
        List<Object[]> implementations = this.getImpls(chain, method);
        if (implementations.isEmpty()) {
            return false;
        }
        Class<?> type = method.getReturnType();
        boolean voidReturnType = type.equals(Void.TYPE);
        boolean chained = implementations.size() > 1 && !voidReturnType || this.isChainRequired(chain, method);
        Method face = this.findInterfaceMethod(method);
        MethodBuilder body = this.cc.copyMethod(face, name, bridge);
        boolean primitiveReturnType = type.isPrimitive();
        boolean setReturnType = type.equals(Set.class);
        if (logger.isTraceEnabled()) {
            body.code(ClassComposer.class.getName() + ".calling(this, \"" + method.getName() + "\", $args);");
        }
        if (chained) {
            if (!voidReturnType && primitiveReturnType) {
                body.code(type.getName()).code(" result;\n");
            } else if (setReturnType) {
                body.code(Set.class.getName() + " result;\n");
            } else if (!voidReturnType) {
                body.code(Object.class.getName() + " result;\n");
            }
        } else if (!voidReturnType) {
            body.code("return ($r) ");
        }
        boolean chainStarted = false;
        for (Object[] ar : implementations) {
            assert (ar.length == 2);
            String target = (String)ar[0];
            Method m = (Method)ar[1];
            if (chained) {
                if (!chainStarted) {
                    chainStarted = true;
                    if (!type.equals(Void.TYPE)) {
                        body.code("result = ($r) ");
                    }
                    body.code("new ");
                    body.code(InvocationMessageContext.class.getName());
                    body.code("($0, ");
                    body.insert(face);
                    body.code(", $args)\n");
                }
                if ("super".equals(target)) {
                    String dname = this.createSuperCall(m);
                    this.appendInvocation("this", dname, m.getParameterTypes(), body);
                    continue;
                }
                this.appendInvocation(target, m, body);
                continue;
            }
            body.code(this.getMethodCall(target, m));
        }
        if (chainStarted) {
            body.code(".proceed();\n");
            chainStarted = false;
        }
        if (chained && !voidReturnType) {
            body.code("return ($r) result;\n");
        }
        ((CodeBuilder)body).end();
        return true;
    }

    private String createSuperCall(Method m) {
        if (this.superMethods.containsKey(m)) {
            return this.superMethods.get(m);
        }
        Class<?> rtype = m.getReturnType();
        Class<?>[] ptypes = m.getParameterTypes();
        String name = "_$super" + this.superMethods.size() + "_" + m.getName();
        MethodBuilder delegating = this.cc.createMethod(rtype, name, ptypes);
        if (!Void.TYPE.equals(rtype)) {
            delegating.code("return ");
        }
        delegating.code(this.getMethodCall("super", m)).end();
        this.superMethods.put(m, name);
        return name;
    }

    private List<BehaviourMethod> chain(Method method) throws Exception {
        if (this.behaviours.isEmpty()) {
            return null;
        }
        ArrayList<BehaviourMethod> list = new ArrayList<BehaviourMethod>();
        this.addAllBehaviourMethods(method, list);
        for (Method m : this.getEquivalentMethods(method)) {
            if (m.equals(method)) continue;
            this.addAllBehaviourMethods(m, list);
        }
        for (Method m : this.getSuperMethods(method)) {
            if (m.equals(method)) continue;
            list.addAll(this.chain(m));
        }
        return list;
    }

    private void addAllBehaviourMethods(Method method, List<BehaviourMethod> list) {
        Set<BehaviourFactory> set = this.behaviours.get(method.getName());
        if (set != null) {
            for (BehaviourFactory behaviour : set) {
                Method m = behaviour.getInvocation(method);
                if (m == null) continue;
                list.add(new BehaviourMethod(behaviour, m));
            }
        }
    }

    private List<BehaviourMethod> sort(List<BehaviourMethod> list, int size) {
        if (size < 2) {
            return list;
        }
        List<BehaviourMethod> sorted = new ArrayList<BehaviourMethod>(size);
        block0: for (BehaviourMethod bm : list) {
            int n = sorted.size();
            for (int i = 0; i < n; ++i) {
                if (!bm.precedes((BehaviourMethod)sorted.get(i))) continue;
                sorted.add(i, bm);
                sorted = this.sort(sorted, size);
                continue block0;
            }
            sorted.add(bm);
        }
        return sorted;
    }

    private boolean isChainRequired(List<BehaviourMethod> behaviours, Method method) throws Exception {
        if (behaviours != null) {
            for (BehaviourMethod behaviour : behaviours) {
                if (behaviour.isMessage()) {
                    return true;
                }
                Class<?> rt = behaviour.getMethod().getReturnType();
                if (method.getReturnType().equals(rt)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Object[]> getImpls(List<BehaviourMethod> behaviours, Method method) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Class<?> type = method.getReturnType();
        Class<?> superclass = this.cc.getSuperclass();
        Class<?>[] types = this.getParameterTypes(method);
        if (behaviours != null) {
            for (BehaviourMethod behaviour : this.sort(behaviours, behaviours.size())) {
                String target;
                if (behaviour.getFactory().isSingleton()) {
                    target = this.getBehaviourFieldName(behaviour.getFactory());
                    list.add(new Object[]{target, behaviour.getMethod()});
                    continue;
                }
                target = this.getPrivateBehaviourMethod(behaviour.getFactory()) + "()";
                list.add(new Object[]{target, behaviour.getMethod()});
            }
        }
        if (!superclass.equals(Object.class)) {
            try {
                Method m = superclass.getMethod(method.getName(), types);
                Class<?> returnType = m.getReturnType();
                if (!this.isSpecial(m) && !Modifier.isAbstract(m.getModifiers()) && returnType.equals(type)) {
                    list.add(new Object[]{"super", m});
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return list;
    }

    private List<Method> getSuperMethods(Method method) {
        ArrayList<Method> list = new ArrayList<Method>();
        String subClassOf = RDFS.SUBCLASSOF.stringValue();
        for (String uri : this.getAnnotationValueByIri(method, subClassOf)) {
            Method m = this.namedMethods.get(uri);
            if (m == null || this.isSpecial(m)) continue;
            list.add(m);
        }
        return list;
    }

    private List<Method> getEquivalentMethods(Method method) {
        ArrayList<Method> list = new ArrayList<Method>();
        String equivalentClass = OWL.EQUIVALENTCLASS.stringValue();
        for (String uri : this.getAnnotationValueByIri(method, equivalentClass)) {
            Method m = this.namedMethods.get(uri);
            if (m == null || this.isSpecial(m)) continue;
            list.add(m);
        }
        return list;
    }

    private String[] getAnnotationValueByIri(Method method, String annotationID) {
        for (Annotation ann : method.getAnnotations()) {
            for (Method am : ann.annotationType().getDeclaredMethods()) {
                Object value;
                Iri iri;
                if (am.getParameterTypes().length > 0 || (iri = am.getAnnotation(Iri.class)) == null || !annotationID.equals(iri.value()) || !((value = this.invoke(am, ann)) instanceof String[])) continue;
                return (String[])value;
            }
        }
        return new String[0];
    }

    private Object invoke(Method method, Annotation ann) {
        try {
            return method.invoke((Object)ann, new Object[0]);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            throw new ExceptionInInitializerError(e.getCause());
        }
    }

    private void appendInvocation(String target, Method method, CodeBuilder body) {
        body.code(".appendInvocation(");
        body.code(target).code(", ");
        body.insert(method);
        body.code(")\n");
    }

    private void appendInvocation(String target, String name, Class<?>[] params, CodeBuilder body) {
        body.code(".appendInvocation(");
        body.code(target).code(", ");
        body.insertMethod(name, params);
        body.code(")\n");
    }

    private String getMethodCall(String target, Method method) {
        StringBuilder eval = new StringBuilder();
        eval.append(target);
        eval.append(".").append(method.getName()).append("($$);\n");
        return eval.toString();
    }

    private Method findInterfaceMethod(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] types = this.getParameterTypes(method);
        Class<?>[] faces = this.cc.getInterfaces();
        Method m = this.findInterfaceMethod(faces, name, type, types);
        if (m != null) {
            return m;
        }
        m = this.findSuperMethod(this.cc.getSuperclass(), name, type, types);
        if (m != null) {
            return m;
        }
        return method;
    }

    private Method findInterfaceMethod(Class<?>[] interfaces, String name, Class<?> type, Class<?>[] types) {
        Collection<Method> methods = this.findInterfaceMethods(interfaces, name, type, types);
        LinkedHashSet<Method> withIdentifiers = new LinkedHashSet<Method>();
        for (Method m : methods) {
            Annotation[][] anns = m.getParameterAnnotations();
            for (int i = 0; i < anns.length; ++i) {
                for (int j = 0; j < anns[i].length; ++j) {
                    if (!anns[i][j].annotationType().equals(Iri.class)) continue;
                    withIdentifiers.add(m);
                }
            }
        }
        if (withIdentifiers.isEmpty()) {
            return this.findSubMethod(methods);
        }
        return this.findSubMethod(withIdentifiers);
    }

    private Method findSubMethod(Collection<Method> methods) {
        if (methods.isEmpty()) {
            return null;
        }
        Iterator<Method> iter = methods.iterator();
        if (methods.size() == 1) {
            return iter.next();
        }
        block0: while (iter.hasNext()) {
            Method m1 = iter.next();
            Class<?> c1 = m1.getDeclaringClass();
            for (Method m2 : methods) {
                Class<?> c2 = m2.getDeclaringClass();
                if (c1.equals(c2) || !c1.isAssignableFrom(c2)) continue;
                iter.remove();
                continue block0;
            }
        }
        return methods.iterator().next();
    }

    private Collection<Method> findInterfaceMethods(Class<?>[] interfaces, String name, Class<?> type, Class<?>[] types) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        for (Class<?> face : interfaces) {
            Class<?>[] faces;
            Method m;
            try {
                Method m2 = face.getDeclaredMethod(name, types);
                if (m2.getReturnType().equals(type)) {
                    methods.add(m2);
                    continue;
                }
            }
            catch (NoSuchMethodException m2) {
                // empty catch block
            }
            if ((m = this.findInterfaceMethod(faces = face.getInterfaces(), name, type, types)) == null) continue;
            methods.add(m);
        }
        return methods;
    }

    private Method findSuperMethod(Class<?> base, String name, Class<?> type, Class<?>[] types) {
        Method m2;
        if (base == null) {
            return null;
        }
        try {
            m2 = base.getDeclaredMethod(name, types);
            if (m2.getReturnType().equals(type)) {
                return m2;
            }
        }
        catch (NoSuchMethodException m2) {
            // empty catch block
        }
        m2 = this.findSuperMethod(base.getSuperclass(), name, type, types);
        if (m2 == null) {
            return null;
        }
        return m2;
    }

    private void addBehaviour(BehaviourFactory factory) throws Exception {
        if (factory.isSingleton()) {
            String fieldName = this.getBehaviourFieldName(factory);
            Class<?> clazz = factory.getBehaviourType();
            this.cc.assignStaticField(clazz, fieldName).code("null").end();
        } else {
            String getterName = this.getPrivateBehaviourMethod(factory);
            String fieldFactoryName = this.getBehaviourFactoryFieldName(factory);
            this.cc.assignStaticField(BehaviourFactory.class, fieldFactoryName).code("null").end();
            String fieldName = this.getBehaviourFieldName(factory);
            Class<?> clazz = factory.getBehaviourType();
            this.cc.createField(clazz, fieldName);
            MethodBuilder code = this.cc.createPrivateMethod(clazz, getterName, new Class[0]);
            code.code("if (").code(fieldName).code(" != null){\n");
            code.code("return ").code(fieldName).code(";\n} else {\n");
            code.code("return ").code(fieldName).code(" = ($r) ");
            code.code(fieldFactoryName).code(".newInstance($0)");
            code.code(";\n}").end();
        }
    }

    private void populateBehaviourField(BehaviourFactory factory, Class<?> createdClass) throws NoSuchFieldException, IllegalAccessException {
        if (factory.isSingleton()) {
            String fieldName = this.getBehaviourFieldName(factory);
            createdClass.getField(fieldName).set(null, factory.getSingleton());
        } else {
            String fieldName = this.getBehaviourFactoryFieldName(factory);
            createdClass.getField(fieldName).set(null, factory);
        }
    }

    private String getPrivateBehaviourMethod(BehaviourFactory factory) {
        String simpleName = factory.getName().replaceAll("\\W", "_");
        return "_$get" + simpleName + "Behaviour" + Integer.toHexString(System.identityHashCode(factory));
    }

    private String getBehaviourFieldName(BehaviourFactory factory) {
        String getterName = this.getPrivateBehaviourMethod(factory);
        return "_$" + getterName.substring(5);
    }

    private String getBehaviourFactoryFieldName(BehaviourFactory factory) {
        String getterName = this.getPrivateBehaviourMethod(factory);
        return "_$" + getterName.substring(5) + "Factory";
    }

    private boolean isObjectMethod(Method m) {
        return m.getDeclaringClass().getName().equals(Object.class.getName());
    }

    static {
        special = new HashSet<String>(Arrays.asList("groovy.lang.GroovyObject", RDFObjectBehaviour.class.getName()));
        logger = LoggerFactory.getLogger(ClassComposer.class);
    }
}

